/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.model;

import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.model.WrappedGalleryModel;
import com.mathworks.util.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilteredGalleryModel
extends WrappedGalleryModel {
    private Predicate<Item> fFilter;
    public static final String FILTERED_RESULTS_PROPERTY = "filtered-results";

    public FilteredGalleryModel(@NotNull GalleryModel galleryModel) {
        super(galleryModel);
    }

    public void setFilter(Predicate<Item> predicate) {
        this.fFilter = predicate;
        this.fPropertySupport.firePropertyChange(FILTERED_RESULTS_PROPERTY, null, this.fFilter);
    }

    public Predicate<Item> getFilter() {
        return this.fFilter;
    }

    public void updateFilter() {
        this.fPropertySupport.firePropertyChange(FILTERED_RESULTS_PROPERTY, null, this.fFilter);
    }

    @Override
    public List<Item> getItems(Category category) {
        List<Item> list = super.getItems(category);
        if (this.fFilter != null) {
            ArrayList<Item> arrayList = new ArrayList<Item>(list.size());
            for (Item item : list) {
                if (!this.fFilter.accept((Object)item)) continue;
                arrayList.add(item);
            }
            list = arrayList;
        }
        return list;
    }

    @Override
    public void moveItem(Category category, Item item, int n) {
        this.fParentModel.moveItem(category, item, this.convertIndexToParent(category, n));
    }

    protected int convertIndexToParent(Category category, int n) {
        if (this.fFilter == null) {
            return n;
        }
        int n2 = 0;
        for (Item item : this.fParentModel.getItems(category)) {
            if (this.fFilter.accept((Object)item) && --n < 0) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }
}

