/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSScrollPane;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.TSComponentUI;
import com.mathworks.toolstrip.plaf.TextEventListener;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class ToolstripTextAreaUI
extends BasicTextAreaUI
implements TSComponentUI {
    private CustomEventListener fEventListener;

    public static ToolstripTextAreaUI createUI(JComponent jComponent) {
        return new ToolstripTextAreaUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTextArea jTextArea = (JTextArea)this.getComponent();
        jTextArea.setFont(ToolstripTheme.getInstance().getTextAreaFont());
        jTextArea.setSelectedTextColor(Color.BLACK);
        jTextArea.setSelectionColor(ToolstripTheme.getInstance().getTextSelectionBackground());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(true);
        jTextArea.putClientProperty("canManageOpacity", true);
        this.fEventListener = new CustomEventListener();
        jTextArea.addMouseListener(this.fEventListener);
        jTextArea.addMouseMotionListener(this.fEventListener);
        jTextArea.addFocusListener(this.fEventListener);
        jTextArea.addKeyListener(this.fEventListener);
        TextEventListener.updateBackground(jTextArea);
    }

    @Override
    protected void uninstallDefaults() {
        JTextArea jTextArea = (JTextArea)this.getComponent();
        jTextArea.removeFocusListener(this.fEventListener);
        jTextArea.removeMouseListener(this.fEventListener);
        jTextArea.removeMouseMotionListener(this.fEventListener);
        jTextArea.removeKeyListener(this.fEventListener);
        super.uninstallDefaults();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Container container;
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled") || propertyChangeEvent.getPropertyName().equals("mouse-is-over")) {
            TextEventListener.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        } else if (propertyChangeEvent.getPropertyName().equals("ancestor") && this.fEventListener != null && (container = SwingUtilities.getAncestorOfClass(TSScrollPane.class, this.getComponent())) != null) {
            this.fEventListener.setComponentToRepaint(container);
        }
    }

    @Override
    public int getPreferredWidth(TSComponent tSComponent, LayoutMode layoutMode) {
        return this.getPreferredSize((JComponent)((JComponent)((Object)tSComponent))).width;
    }

    private static class CustomEventListener
    extends TextEventListener
    implements KeyListener {
        private CustomEventListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                TSUtil.relinquishFocus(keyEvent.getComponent());
                TSUtil.toolstripActionProcessed(keyEvent.getComponent());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

