/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.TSComponentUI;
import com.mathworks.toolstrip.plaf.TextEventListener;
import com.mathworks.toolstrip.plaf.ToolstripTextBorder;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class ToolstripTextFieldUI
extends BasicTextFieldUI
implements TSComponentUI {
    private static final CustomEventListener sEventListener = new CustomEventListener();

    public static ToolstripTextFieldUI createUI(JComponent jComponent) {
        return new ToolstripTextFieldUI();
    }

    public ToolstripTextFieldUI() {
        this.copy("font", "foreground", "caretForeground", "selectionForeground", "inactiveForeground", "margin", "keyBindings", "focusInputMap", "actionMap", "keyBindings");
        this.put("selectionBackground", ToolstripTheme.getInstance().getTextSelectionBackground());
        this.put("disabledBackground", ToolstripTheme.getInstance().getTextDisabledBackground());
        this.put("background", ToolstripTheme.getInstance().getTextBackground());
        this.put("inactiveBackground", ToolstripTheme.getInstance().getTextBackground());
        this.put("activeBackground", ToolstripTheme.getInstance().getTextActiveBackground());
    }

    private void put(String string, Object object) {
        UIManager.getDefaults().put(this.getPropertyPrefix() + "." + string, object);
    }

    private void copy(String ... stringArray) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        for (String string : stringArray) {
            uIDefaults.put(this.getPropertyPrefix() + "." + string, uIDefaults.get("TextField." + string));
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTextField jTextField = (JTextField)this.getComponent();
        jTextField.setFont(ToolstripTheme.getInstance().getTSTextFieldFont());
        jTextField.setSelectedTextColor(Color.BLACK);
        jTextField.setOpaque(true);
        jTextField.setBorder(new ToolstripTextBorder(jTextField, new Insets(0, 2, 0, 2)));
        jTextField.putClientProperty("canManageOpacity", true);
        jTextField.addMouseListener(sEventListener);
        jTextField.addMouseMotionListener(sEventListener);
        jTextField.addFocusListener(sEventListener);
        jTextField.addActionListener(sEventListener);
        jTextField.addKeyListener(sEventListener);
        TextEventListener.updateBackground(jTextField);
    }

    @Override
    protected void uninstallDefaults() {
        JTextField jTextField = (JTextField)this.getComponent();
        jTextField.removeFocusListener(sEventListener);
        jTextField.removeMouseListener(sEventListener);
        jTextField.removeMouseMotionListener(sEventListener);
        jTextField.removeActionListener(sEventListener);
        jTextField.removeKeyListener(sEventListener);
        super.uninstallDefaults();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled") || propertyChangeEvent.getPropertyName().equals("mouse-is-over")) {
            TextEventListener.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private boolean isEditable() {
        JTextComponent jTextComponent = this.getComponent();
        return jTextComponent.isEnabled() && jTextComponent.isEditable();
    }

    @Override
    public int getPreferredWidth(TSComponent tSComponent, LayoutMode layoutMode) {
        return this.getPreferredSize((JComponent)((JComponent)((Object)tSComponent))).width;
    }

    @Override
    protected String getPropertyPrefix() {
        return "TSTextField";
    }

    private static class CustomEventListener
    extends TextEventListener
    implements KeyListener,
    ActionListener {
        private CustomEventListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                TSUtil.relinquishFocus(keyEvent.getComponent());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getComponent();
            jTextField.selectAll();
            CustomEventListener.updateBackground(jTextField);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TSUtil.toolstripActionProcessed((Component)actionEvent.getSource());
        }
    }
}

