/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.common.sounds;

import com.mathworks.common.sounds.ISound;
import com.mathworks.util.DebugUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

final class Sound
implements ISound {
    private final File fSoundFile;
    private final String fName;

    Sound(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name must not be null.");
        }
        URL uRL = this.getClass().getResource(string);
        this.fSoundFile = uRL != null ? new File(uRL.getFile()) : null;
        this.fName = string;
    }

    @Override
    public void play() {
        block8: {
            if (this.fSoundFile == null) {
                assert (DebugUtils.warning((String)("Cannot find sound file: " + this.fName)));
                return;
            }
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.fSoundFile);
                Clip clip = AudioSystem.getClip();
                clip.open(audioInputStream);
                clip.start();
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                assert (DebugUtils.warning((String)("Unsupported audio file type or format: " + this.fName)));
            }
            catch (IOException iOException) {
                assert (DebugUtils.outputException((Throwable)iOException));
            }
            catch (LineUnavailableException lineUnavailableException) {
                if ($assertionsDisabled || DebugUtils.warning((String)("Resource unavailable: " + this.fName))) break block8;
                throw new AssertionError();
            }
        }
    }
}

