/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.SharedActivationPolicyPermission;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.ProxyAccessor;
import net.jini.loader.ClassAnnotation;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;

public class ActivateWrapper
implements Remote,
Serializable {
    static final Logger logger = Logger.getLogger("com.sun.jini.start.wrapper");
    private static AggregatePolicyProvider globalPolicy;
    private static Policy initialGlobalPolicy;
    private Object impl;
    private static final Class[] actTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivateWrapper(ActivationID activationID, MarshalledObject marshalledObject) throws Exception {
        try {
            Object object;
            logger.entering(ActivateWrapper.class.getName(), "ActivateWrapper", new Object[]{activationID, marshalledObject});
            ActivateDesc activateDesc = (ActivateDesc)marshalledObject.get();
            logger.log(Level.FINEST, "ActivateDesc: {0}", activateDesc);
            ExportClassLoader exportClassLoader = null;
            try {
                exportClassLoader = new ExportClassLoader(activateDesc.importLocation, activateDesc.exportLocation);
                logger.log(Level.FINEST, "Created ExportClassLoader: {0}", exportClassLoader);
            }
            catch (Exception exception) {
                logger.throwing(ActivateWrapper.class.getName(), "ActivateWrapper", exception);
                throw exception;
            }
            ActivateWrapper.checkPolicyPermission(activateDesc.policy, activateDesc.importLocation);
            Object object2 = ActivateWrapper.class;
            synchronized (object2) {
                if (globalPolicy == null) {
                    initialGlobalPolicy = Policy.getPolicy();
                    globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                    Policy.setPolicy(globalPolicy);
                    logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
                }
                object = new DynamicPolicyProvider(new PolicyFileProvider(activateDesc.policy));
                LoaderSplitPolicyProvider loaderSplitPolicyProvider = new LoaderSplitPolicyProvider(exportClassLoader, (Policy)object, new DynamicPolicyProvider(initialGlobalPolicy));
                loaderSplitPolicyProvider.grant(this.getClass(), null, new Permission[]{new AllPermission()});
                globalPolicy.setPolicy(exportClassLoader, loaderSplitPolicyProvider);
                logger.log(Level.FINEST, "Added policy to set: {0}", activateDesc.policy);
            }
            object2 = Thread.currentThread();
            object = ((Thread)object2).getContextClassLoader();
            logger.log(Level.FINEST, "Saved current context class loader: {0}", object);
            ((Thread)object2).setContextClassLoader(exportClassLoader);
            logger.log(Level.FINEST, "Set new context class loader: {0}", exportClassLoader);
            try {
                boolean bl = false;
                Class<?> clazz = Class.forName(activateDesc.className, bl, exportClassLoader);
                logger.log(Level.FINEST, "Obtained implementation class: {0}", clazz);
                Constructor<?> constructor = clazz.getDeclaredConstructor(actTypes);
                logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                constructor.setAccessible(true);
                this.impl = constructor.newInstance(activationID, activateDesc.data);
                logger.log(Level.FINEST, "Obtained implementation instance: {0}", this.impl);
                Object var11_14 = null;
                ((Thread)object2).setContextClassLoader((ClassLoader)object);
                logger.log(Level.FINEST, "Context class loader reset to: {0}", object);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                ((Thread)object2).setContextClassLoader((ClassLoader)object);
                logger.log(Level.FINEST, "Context class loader reset to: {0}", object);
                throw throwable;
            }
        }
        catch (Exception exception) {
            logger.throwing(ActivateWrapper.class.getName(), "ActivateWrapper", exception);
            throw exception;
        }
        logger.exiting(ActivateWrapper.class.getName(), "ActivateWrapper");
    }

    private Object writeReplace() throws ObjectStreamException {
        Object object = this.impl;
        if (this.impl instanceof ProxyAccessor) {
            object = ((ProxyAccessor)this.impl).getProxy();
            logger.log(Level.FINEST, "Obtained implementation proxy: {0}", object);
            if (object == null) {
                throw new InvalidObjectException("Implementation's getProxy() returned null");
            }
        }
        return object;
    }

    public static ActivationID register(ActivationGroupID activationGroupID, ActivateDesc activateDesc, boolean bl, ActivationSystem activationSystem) throws ActivationException, RemoteException {
        MarshalledObject<ActivateDesc> marshalledObject;
        logger.entering(ActivateWrapper.class.getName(), "register", new Object[]{activationGroupID, activateDesc, new Boolean(bl), activationSystem});
        try {
            marshalledObject = new MarshalledObject<ActivateDesc>(activateDesc);
        }
        catch (Exception exception) {
            MarshalException marshalException = new MarshalException("marshalling ActivateDesc", exception);
            logger.throwing(ActivateWrapper.class.getName(), "register", marshalException);
            throw marshalException;
        }
        ActivationDesc activationDesc = new ActivationDesc(activationGroupID, ActivateWrapper.class.getName(), null, marshalledObject, bl);
        logger.log(Level.FINEST, "Registering descriptor with activation: {0}", activationDesc);
        ActivationID activationID = activationSystem.registerObject(activationDesc);
        logger.exiting(ActivateWrapper.class.getName(), "register", activationID);
        return activationID;
    }

    private static void checkPolicyPermission(String string, URL[] uRLArray) {
        logger.entering(ActivateWrapper.class.getName(), "checkPolicyPermission", new Object[]{string, ActivateWrapper.urlsToPath(uRLArray)});
        SharedActivationPolicyPermission sharedActivationPolicyPermission = new SharedActivationPolicyPermission(string);
        Certificate[] certificateArray = null;
        CodeSource codeSource = null;
        ProtectionDomain protectionDomain = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            codeSource = new CodeSource(uRLArray[i], certificateArray);
            protectionDomain = new ProtectionDomain(codeSource, null, null, null);
            logger.log(Level.FINEST, "Checking protection domain: {0}", protectionDomain);
            if (protectionDomain.implies(sharedActivationPolicyPermission)) continue;
            SecurityException securityException = new SecurityException("ProtectionDomain " + protectionDomain + " does not have required permission: " + sharedActivationPolicyPermission);
            logger.throwing(ActivateWrapper.class.getName(), "checkPolicyPermission", securityException);
            throw securityException;
        }
        logger.exiting(ActivateWrapper.class.getName(), "checkPolicyPermission");
    }

    private static String urlsToPath(URL[] uRLArray) {
        if (uRLArray.length == 0) {
            return null;
        }
        if (uRLArray.length == 1) {
            return uRLArray[0].toExternalForm();
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toExternalForm());
        for (int i = 1; i < uRLArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(uRLArray[i].toExternalForm());
        }
        return stringBuffer.toString();
    }

    static {
        actTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    }

    static class ExportClassLoader
    extends URLClassLoader
    implements ClassAnnotation {
        private final URL[] exportURLs;
        private String exportAnnotation;

        public ExportClassLoader(URL[] uRLArray, URL[] uRLArray2) {
            super(uRLArray);
            this.exportURLs = uRLArray2;
            this.exportAnnotation = ActivateWrapper.urlsToPath(uRLArray2);
        }

        public URL[] getURLs() {
            return (URL[])this.exportURLs.clone();
        }

        public String getClassAnnotation() {
            return this.exportAnnotation;
        }
    }

    public static class ActivateDesc
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final String className;
        public final URL[] importLocation;
        public final URL[] exportLocation;
        public final String policy;
        public final MarshalledObject data;

        public ActivateDesc(String string, URL[] uRLArray, URL[] uRLArray2, String string2, MarshalledObject marshalledObject) {
            this.className = string;
            this.importLocation = uRLArray;
            this.exportLocation = uRLArray2;
            this.policy = string2;
            this.data = marshalledObject;
        }

        public String toString() {
            return "[className=" + this.className + "," + "importLocation=" + Arrays.asList(this.importLocation) + "," + "exportLocation=" + Arrays.asList(this.exportLocation) + "," + "policy=" + this.policy + "," + "data=" + this.data + "]";
        }
    }
}

