/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ServiceStarter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPDStatus {
    private static final Logger logger = ServiceStarter.logger;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: HTTPDStatus URL1 [URL2 ... URLN]");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            HTTPDStatus.httpdWarning(stringArray[i]);
        }
    }

    public static void httpdWarning(String string) {
        if (string == null) {
            logger.log(Level.WARNING, "httpserver.warning", new Object[]{string, "Codebase is null"});
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = null;
        URL uRL = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                uRL = new URL(string2);
                String string3 = uRL.getFile();
                if (string3 == null || string3.endsWith("/")) {
                    logger.log(Level.FINEST, "httpserver.skipping", string2);
                } else {
                    try {
                        HTTPDStatus.drainStream(uRL.openStream());
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "httpserver.warning", new Object[]{string2, exception.toString()});
                        logger.log(Level.FINEST, "httpserver.exception", exception);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.WARNING, "httpserver.unknownprotocol", string2);
                logger.log(Level.FINEST, "httpserver.exception", malformedURLException);
            }
            ++n;
        }
    }

    private static void drainStream(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while (bufferedInputStream.read() != -1) {
        }
    }
}

