/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ProxyVerifier;
import com.sun.jini.start.SharedGroupBackEnd;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

public class SharedGroupImpl
implements SharedGroupBackEnd,
ServerProxyTrust,
ProxyAccessor {
    private static final String START_PACKAGE = "com.sun.jini.start";
    private static final Logger logger = Logger.getLogger("com.sun.jini.start.sharedGroup");
    private ActivationID activationID = null;
    private ActivationSystem activationSystem;
    private Remote ourStub;
    private final LoginContext loginContext;
    protected Exporter exporter;
    static /* synthetic */ Class class$com$sun$jini$start$SharedGroupImpl$DestroyThread;

    private SharedGroupImpl(ActivationID activationID, MarshalledObject marshalledObject) throws Exception {
        logger.entering(SharedGroupImpl.class.getName(), "SharedGroupImpl", new Object[]{activationID, marshalledObject});
        this.activationID = activationID;
        try {
            String[] stringArray = (String[])marshalledObject.get();
            Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray);
            this.loginContext = (LoginContext)configuration.getEntry(START_PACKAGE, "loginContext", LoginContext.class, null);
            if (this.loginContext != null) {
                this.doInitWithLogin(configuration, this.loginContext);
            } else {
                this.doInit(configuration);
            }
        }
        catch (Exception exception) {
            this.cleanup();
            throw exception;
        }
        logger.exiting(SharedGroupImpl.class.getName(), "SharedGroupImpl");
    }

    private void doInitWithLogin(final Configuration configuration, LoginContext loginContext) throws Exception {
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    SharedGroupImpl.this.doInit(configuration);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    private void doInit(Configuration configuration) throws Exception {
        ProxyPreparer proxyPreparer = (ProxyPreparer)configuration.getEntry(START_PACKAGE, "activationSystemPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (proxyPreparer == null) {
            throw new ConfigurationException("com.sun.jini.start.activationSystemPreparer entry should not be null");
        }
        logger.log(Level.FINE, "com.sun.jini.start.activationSystemPreparer: {0}", proxyPreparer);
        ProxyPreparer proxyPreparer2 = (ProxyPreparer)configuration.getEntry(START_PACKAGE, "activationIdPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (proxyPreparer2 == null) {
            throw new ConfigurationException("com.sun.jini.start.activationIdPreparer entry should not be null");
        }
        logger.log(Level.FINE, "com.sun.jini.start.activationIdPreparer: {0}", proxyPreparer2);
        this.activationSystem = (ActivationSystem)proxyPreparer.prepareProxy((Object)ActivationGroup.getSystem());
        logger.log(Level.FINE, "Prepared ActivationSystem: {0}", this.activationSystem);
        this.activationID = (ActivationID)proxyPreparer2.prepareProxy((Object)this.activationID);
        logger.log(Level.FINEST, "Prepared ActivationID: {0}", this.activationID);
        this.exporter = (Exporter)configuration.getEntry(START_PACKAGE, "exporter", Exporter.class, (Object)new ActivationExporter(this.activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory(), false, true)), (Object)this.activationID);
        if (this.exporter == null) {
            throw new ConfigurationException("com.sun.jini.start.exporter entry should not be null");
        }
        logger.log(Level.FINE, "com.sun.jini.start.exporter: {0}", this.exporter);
        this.ourStub = this.exporter.export((Remote)this);
        logger.log(Level.FINEST, "Exported service proxy: {0}", this.ourStub);
    }

    public void destroyVM() throws RemoteException, ActivationException {
        logger.entering(SharedGroupImpl.class.getName(), "destroyVM");
        if (this.activationSystem != null) {
            this.activationSystem.unregisterGroup(ActivationGroup.currentGroupID());
            logger.finest("ActivationGroup unregistered.");
            this.activationSystem = null;
        }
        new DestroyThread().start();
        logger.exiting(SharedGroupImpl.class.getName(), "destroyVM");
    }

    private void cleanup() {
        logger.entering(SharedGroupImpl.class.getName(), "cleanup");
        if (this.exporter != null) {
            try {
                this.exporter.unexport(true);
                logger.finest("SharedGroupImpl unexported.");
            }
            catch (Exception exception) {
                logger.log(Level.FINEST, "Problem unexporting SharedGroupImpl.", exception);
            }
        }
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
                logger.finest("SharedGroupImpl logged-out.");
            }
            catch (Exception exception) {
                logger.log(Level.FINEST, "Problem logging out for SharedGroupImpl.", exception);
            }
        }
        logger.exiting(SharedGroupImpl.class.getName(), "cleanup");
    }

    public Object getProxy() {
        logger.entering(SharedGroupImpl.class.getName(), "getProxy");
        logger.exiting(SharedGroupImpl.class.getName(), "getProxy", this.ourStub);
        return this.ourStub;
    }

    public TrustVerifier getProxyVerifier() {
        if (!(this.ourStub instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        return new ProxyVerifier((SharedGroupBackEnd)this.ourStub);
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        public void run() {
            logger.entering((class$com$sun$jini$start$SharedGroupImpl$DestroyThread == null ? (class$com$sun$jini$start$SharedGroupImpl$DestroyThread = SharedGroupImpl.class$("com.sun.jini.start.SharedGroupImpl$DestroyThread")) : class$com$sun$jini$start$SharedGroupImpl$DestroyThread).getName(), "run");
            logger.finest("Calling System.exit() ...");
            System.exit(0);
        }
    }
}

