/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dimension;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.openide.util.NbBundle;

public class ListCompletionView
extends JList
implements CompletionView {
    ListCellRenderer renderer;
    ListCellRenderer defaultRenderer;

    public ListCompletionView() {
        this((ListCellRenderer)null);
    }

    public ListCompletionView(ListCellRenderer listCellRenderer) {
        this.setSelectionMode(0);
        this.renderer = listCellRenderer;
        this.defaultRenderer = this.getCellRenderer();
        ResourceBundle resourceBundle = NbBundle.getBundle(BaseKit.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CompletionView"));
    }

    @Override
    public void setResult(CompletionQuery.Result result) {
        if (result != null) {
            this.setResult(result.getData());
        } else {
            this.setResult(Collections.EMPTY_LIST);
        }
    }

    public void setResult(List linkedList) {
        if (linkedList != null) {
            if (linkedList.size() == 0) {
                this.setCellRenderer(this.defaultRenderer);
                linkedList = new LinkedList();
                this.setModel(new Model(linkedList));
                this.clearSelection();
            } else {
                if (this.renderer != null) {
                    this.setCellRenderer(this.renderer);
                }
                this.setModel(new Model(linkedList));
                this.setSelectedIndex(0);
            }
        }
    }

    public void displayWaitStatus() {
        if (this.getCellRenderer() == this.defaultRenderer) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(NbBundle.getBundle(BaseKit.class).getString("please-wait"));
            this.setModel(new Model(linkedList));
            this.clearSelection();
        }
    }

    public boolean showingData() {
        return this.getCellRenderer() == this.renderer;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(this.getSelectedIndex() - 1);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    @Override
    public void down() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, n));
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    @Override
    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n2 = Math.max(this.getSelectedIndex() - n, 0);
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    @Override
    public void pageDown() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n3 = Math.min(this.getSelectedIndex() + n2, n);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    @Override
    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    @Override
    public void end() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List list) {
            this.data = list;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int n) {
            return n >= 0 && n < this.data.size() ? this.data.get(n) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

