/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FileStorage;
import org.netbeans.editor.ext.StringCache;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCFileProvider
extends JavaCompletion.AbstractProvider {
    static final int VERSION = 2;
    static final int OPCODE_ADD = 1;
    static final int OPCODE_REMOVE = 2;
    public static final String SKEL_FILE_EXT = "jcs";
    public static final String BODY_FILE_EXT = "jcb";
    protected static final StringCache strCache = new StringCache(200, 5003);
    private boolean valid = true;
    protected FileStorage skels;
    protected FileStorage bodies;
    HashMap classes;
    int fileVersion;

    protected JCFileProvider() {
    }

    public JCFileProvider(String string) {
        this(string + "." + SKEL_FILE_EXT, string + "." + BODY_FILE_EXT);
    }

    public JCFileProvider(String string, String string2) {
        this(new FileStorage(string, strCache), new FileStorage(string2, strCache));
    }

    public JCFileProvider(FileStorage fileStorage, FileStorage fileStorage2) {
        this.skels = fileStorage;
        this.bodies = fileStorage2;
    }

    public void invalidate() {
        this.valid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() {
        boolean bl = false;
        try {
            this.skels.resetFile();
            this.bodies.resetFile();
            this.skels.open(true);
            this.skels.setVersion(1);
            this.skels.putInteger(2);
            this.fileVersion = 2;
            this.setVersion(this.fileVersion);
            this.skels.write();
            this.skels.close();
            this.bodies.open(true);
            this.bodies.setVersion(1);
            this.bodies.putInteger(2);
            this.setVersion(this.fileVersion);
            this.bodies.write();
            this.bodies.close();
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (!bl) {
                this.skels.resetBytes();
                this.bodies.resetBytes();
            }
        }
    }

    private void setVersion(int n) {
        this.skels.setVersion(n);
        this.bodies.setVersion(n);
    }

    @Override
    protected boolean appendClass(JCClass jCClass) {
        try {
            this.skels.putInteger(1);
            this.writeClass(jCClass);
            this.skels.write();
            this.bodies.write();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected boolean removeClass(JCClass jCClass) {
        try {
            this.skels.putInteger(2);
            this.skels.putString(jCClass.toString());
            this.skels.write();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(JCClassProvider jCClassProvider) {
        boolean bl;
        boolean bl2 = false;
        try {
            if (this.skels.getFileLength() <= 0) {
                this.reset();
            }
            this.skels.open(true);
            if (!super.remove(jCClassProvider)) {
                boolean bl3 = false;
                return bl3;
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println("Error occurred during updating Code Completion DB: " + this);
            throwable.printStackTrace();
            if (throwable instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)throwable;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            boolean bl6 = true;
            try {
                this.skels.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl6 = false;
            }
            if (!bl2 || !bl6) {
                this.skels.resetBytes();
            }
        }
        return bl2 && bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean append(JCClassProvider jCClassProvider) {
        boolean bl;
        boolean bl2 = false;
        try {
            if (this.skels.getFileLength() <= 0) {
                this.reset();
            }
            this.skels.open(true);
            this.bodies.open(true);
            if (!super.append(jCClassProvider)) {
                boolean bl3 = false;
                return bl3;
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println("Error occurred during updating Code Completion DB: " + this);
            throwable.printStackTrace();
            if (throwable instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)throwable;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            boolean bl6 = true;
            try {
                this.skels.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl6 = false;
            }
            try {
                this.bodies.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl6 = false;
            }
            if (!bl2 || !bl6) {
                this.skels.resetBytes();
                this.bodies.resetBytes();
            }
        }
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator getClasses() {
        int n;
        boolean bl = false;
        try {
            this.skels.open(false);
            bl = true;
            this.skels.seek(0);
            n = this.skels.getFileLength();
            if (n < 4) {
                Iterator iterator = new ArrayList().iterator();
                return iterator;
            }
            this.skels.read(n);
        }
        catch (IOException iOException) {
            if (!this.skels.fileNotFound) {
                Utilities.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Utilities.getLastActiveComponent(), MessageFormat.format(LocaleSupport.getString("pd-file-not-found"), JCFileProvider.this.bodies.toString()), LocaleSupport.getString("pd-file-not-found-title"), 2);
                    }
                });
                this.skels.fileNotFound = true;
            }
            Iterator iterator = new ArrayList().iterator();
            return iterator;
        }
        finally {
            if (bl) {
                try {
                    this.skels.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.setVersion(1);
        this.fileVersion = this.skels.getInteger();
        this.setVersion(this.fileVersion);
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        HashSet<Object> hashSet = new HashSet<Object>(Math.max(n / 38, 16));
        while (this.skels.getOffset() < n) {
            Object object;
            int n2 = this.skels.getInteger();
            if (n2 == 1) {
                object = new Cls();
                if (!hashSet.add(object)) {
                    hashSet.remove(object);
                    hashSet.add(object);
                }
                arrayList.remove(object);
                if (!((Cls)object).fullName.equals(JavaCompletion.OBJECT_CLASS.fullName)) continue;
                hashSet.add(((Cls)object).makeClone());
                continue;
            }
            if (n2 != 2) break;
            object = this.skels.getString();
            JCClass jCClass = JavaCompletion.createSimpleClass((String)object);
            if (arrayList.contains(object)) continue;
            arrayList.add(jCClass);
        }
        ArrayList arrayList2 = new ArrayList(hashSet);
        arrayList2.removeAll(arrayList);
        this.skels.resetBytes();
        return arrayList2.iterator();
    }

    void writeClass(JCClass jCClass) throws IOException {
        int n;
        this.bodies.putInteger(jCClass.getTagOffset());
        this.writeClassName(jCClass.getSuperclass(), this.bodies);
        JCClass[] jCClassArray = jCClass.getInterfaces();
        this.bodies.putInteger(jCClassArray.length);
        for (int i = 0; i < jCClassArray.length; ++i) {
            this.writeClassName(jCClassArray[i], this.bodies);
        }
        JCField[] jCFieldArray = jCClass.getFields();
        this.bodies.putInteger(jCFieldArray.length);
        for (int i = 0; i < jCFieldArray.length; ++i) {
            this.writeField(jCFieldArray[i]);
        }
        JCConstructor[] jCConstructorArray = jCClass.getConstructors();
        this.bodies.putInteger(jCConstructorArray.length);
        for (int i = 0; i < jCConstructorArray.length; ++i) {
            this.writeConstructor(jCConstructorArray[i]);
        }
        JCMethod[] jCMethodArray = jCClass.getMethods();
        this.bodies.putInteger(jCMethodArray.length);
        for (n = 0; n < jCMethodArray.length; ++n) {
            this.writeMethod(jCMethodArray[n]);
        }
        this.writeClassName(jCClass, this.skels);
        n = jCClass.getModifiers();
        this.skels.putInteger(n);
        this.skels.putInteger(this.bodies.getFilePointer());
        this.skels.putInteger(this.bodies.getOffset());
    }

    void writeType(JCType jCType) {
        this.writeClassName(jCType.getClazz(), this.bodies);
        this.bodies.putInteger(jCType.getArrayDepth());
    }

    void writeParameter(JCParameter jCParameter) {
        this.bodies.putString(jCParameter.getName());
        this.writeType(jCParameter.getType());
    }

    void writeField(JCField jCField) {
        this.bodies.putString(jCField.getName());
        this.writeType(jCField.getType());
        this.bodies.putInteger(jCField.getTagOffset());
        this.bodies.putInteger(jCField.getModifiers());
    }

    void writeConstructor(JCConstructor jCConstructor) {
        this.bodies.putInteger(jCConstructor.getTagOffset());
        this.bodies.putInteger(jCConstructor.getModifiers());
        JCParameter[] jCParameterArray = jCConstructor.getParameters();
        this.bodies.putInteger(jCParameterArray.length);
        for (int i = 0; i < jCParameterArray.length; ++i) {
            this.writeParameter(jCParameterArray[i]);
        }
        JCClass[] jCClassArray = jCConstructor.getExceptions();
        this.bodies.putInteger(jCClassArray.length);
        for (int i = 0; i < jCClassArray.length; ++i) {
            this.writeClassName(jCClassArray[i], this.bodies);
        }
    }

    void writeMethod(JCMethod jCMethod) {
        this.writeConstructor(jCMethod);
        this.bodies.putString(jCMethod.getName());
        this.writeType(jCMethod.getReturnType());
    }

    void writeClassName(JCClass jCClass, FileStorage fileStorage) {
        fileStorage.putString(jCClass.getFullName());
        fileStorage.putInteger(jCClass.getPackageName().length());
    }

    private JCClass getSimpleClass(String string, int n, boolean bl) {
        JCClass jCClass = null;
        if (n == 0) {
            jCClass = JavaCompletion.getPrimitiveClass(string);
        }
        if (jCClass == null) {
            String string2 = string.intern();
            if (string != string2) {
                strCache.putSurviveString(string2);
            }
            jCClass = string2.length() > 0 ? (bl ? JavaCompletion.getSimpleClass(string2, n) : new JavaCompletion.SimpleClass(string2, n, true)) : JavaCompletion.INVALID_CLASS;
        }
        return jCClass;
    }

    JCClass readSimpleClass(FileStorage fileStorage, boolean bl) {
        String string = fileStorage.getString();
        int n = fileStorage.getInteger();
        return this.getSimpleClass(string, n, bl);
    }

    JCClass readSimpleClass(FileStorage fileStorage) {
        return this.readSimpleClass(fileStorage, true);
    }

    private void readBC(JavaCompletion.BaseConstructor baseConstructor) {
        int n;
        baseConstructor.tagOffset = this.bodies.getInteger();
        baseConstructor.modifiers = this.bodies.getInteger();
        int n2 = this.bodies.getInteger();
        baseConstructor.parameters = n2 > 0 ? new JCParameter[n2] : JavaCompletion.EMPTY_PARAMETERS;
        for (n = 0; n < n2; ++n) {
            baseConstructor.parameters[n] = new Prm();
        }
        n2 = this.bodies.getInteger();
        baseConstructor.exceptions = n2 > 0 ? new JCClass[n2] : JavaCompletion.EMPTY_CLASSES;
        for (n = 0; n < n2; ++n) {
            baseConstructor.exceptions[n] = this.readSimpleClass(this.bodies);
        }
    }

    public String toString() {
        return "Skeleton: " + this.skels + " , Body: " + this.bodies;
    }

    static {
        strCache.putSurviveString("");
        Iterator iterator = JavaCompletion.getPrimitiveClassIterator();
        while (iterator.hasNext()) {
            strCache.putSurviveString(((JCClass)iterator.next()).getName());
        }
    }

    public class Prm
    extends JavaCompletion.BaseParameter {
        Prm() {
            this.name = JCFileProvider.this.bodies.getString();
            this.type = new Typ();
        }
    }

    final class Mtd
    extends JavaCompletion.BaseMethod {
        Mtd(JCClass jCClass) {
            this.clazz = jCClass;
            JCFileProvider.this.readBC(this);
            this.name = JCFileProvider.this.bodies.getString();
            this.returnType = new Typ();
        }
    }

    final class Ctr
    extends JavaCompletion.BaseConstructor {
        Ctr(JCClass jCClass) {
            this.clazz = jCClass;
            JCFileProvider.this.readBC(this);
        }
    }

    final class Fld
    extends JavaCompletion.BaseField {
        Fld(JCClass jCClass) {
            this.clazz = jCClass;
            this.name = JCFileProvider.this.bodies.getString();
            this.type = new Typ();
            this.tagOffset = JCFileProvider.this.bodies.getInteger();
            this.modifiers = JCFileProvider.this.bodies.getInteger();
        }
    }

    final class Typ
    extends JavaCompletion.BaseType {
        Typ() {
            this.clazz = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
            this.arrayDepth = JCFileProvider.this.bodies.getInteger();
        }
    }

    final class Cls
    extends JavaCompletion.AbstractClass {
        int bodySeekPointer;
        int bodyLen;
        boolean isInterface = false;

        public Cls() {
            JCClass jCClass = JCFileProvider.this.readSimpleClass(JCFileProvider.this.skels, false);
            this.fullName = jCClass.getFullName();
            this.name = jCClass.getName();
            this.packageName = jCClass.getPackageName();
            this.modifiers = JCFileProvider.this.skels.getInteger();
            this.bodySeekPointer = JCFileProvider.this.skels.getInteger();
            this.bodyLen = JCFileProvider.this.skels.getInteger();
        }

        public Cls(JCClass jCClass, int n, int n2) {
            this.fullName = jCClass.getFullName();
            this.name = jCClass.getName();
            this.packageName = jCClass.getPackageName();
            this.modifiers = jCClass.getModifiers();
            this.isInterface = jCClass.isInterface();
            this.bodySeekPointer = n;
            this.bodyLen = n2;
        }

        private Cls(Cls cls) {
            this.fullName = JavaCompletion.OBJECT_CLASS_ARRAY.fullName;
            this.name = JavaCompletion.OBJECT_CLASS_ARRAY.name;
            this.packageName = JavaCompletion.OBJECT_CLASS_ARRAY.packageName;
            this.body = new JavaCompletion.AbstractClass.Body();
            cls.init();
            this.body.superClass = cls.body.superClass;
            this.body.interfaces = cls.body.interfaces;
            this.body.constructors = cls.body.constructors;
            this.body.methods = cls.body.methods;
            this.body.fields = new JCField[1];
            this.body.fields[0] = new JavaCompletion.BaseField(this, "length", JavaCompletion.INT_TYPE, 17);
        }

        @Override
        public boolean isInterface() {
            if (this.isInterface) {
                return true;
            }
            return super.isInterface();
        }

        public Cls makeClone() {
            return new Cls(this);
        }

        private void invalidateBody() {
            this.body.tagOffset = -1;
            this.body.superClass = JavaCompletion.INVALID_CLASS;
            this.body.interfaces = JavaCompletion.EMPTY_CLASSES;
            this.body.fields = JavaCompletion.EMPTY_FIELDS;
            this.body.constructors = JavaCompletion.EMPTY_CONSTRUCTORS;
            this.body.methods = JavaCompletion.EMPTY_METHODS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void init() {
            JCFileProvider jCFileProvider = JCFileProvider.this;
            synchronized (jCFileProvider) {
                int n;
                this.body = new JavaCompletion.AbstractClass.Body();
                try {
                    if (!JCFileProvider.this.valid) {
                        this.invalidateBody();
                        return;
                    }
                    JCFileProvider.this.bodies.open(false);
                    JCFileProvider.this.bodies.seek(this.bodySeekPointer);
                    JCFileProvider.this.bodies.read(this.bodyLen);
                    JCFileProvider.this.bodies.close();
                }
                catch (IOException iOException) {
                    if (!JCFileProvider.this.bodies.fileNotFound) {
                        JOptionPane.showMessageDialog(Utilities.getLastActiveComponent(), MessageFormat.format(LocaleSupport.getString("pd-file-not-found"), JCFileProvider.this.bodies.toString()), LocaleSupport.getString("pd-file-not-found-title"), 2);
                        JCFileProvider.this.bodies.fileNotFound = true;
                        JCFileProvider.this.skels.fileNotFound = true;
                    }
                    this.invalidateBody();
                    return;
                }
                this.body.tagOffset = JCFileProvider.this.bodies.getInteger();
                this.body.superClass = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
                int n2 = JCFileProvider.this.bodies.getInteger();
                this.body.interfaces = n2 > 0 ? new JCClass[n2] : JavaCompletion.EMPTY_CLASSES;
                for (n = 0; n < n2; ++n) {
                    this.body.interfaces[n] = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
                }
                n2 = JCFileProvider.this.bodies.getInteger();
                this.body.fields = n2 > 0 ? new JCField[n2] : JavaCompletion.EMPTY_FIELDS;
                for (n = 0; n < n2; ++n) {
                    this.body.fields[n] = new Fld(this);
                }
                n2 = JCFileProvider.this.bodies.getInteger();
                this.body.constructors = n2 > 0 ? new JCConstructor[n2] : JavaCompletion.EMPTY_CONSTRUCTORS;
                for (n = 0; n < n2; ++n) {
                    this.body.constructors[n] = new Ctr(this);
                }
                n2 = JCFileProvider.this.bodies.getInteger();
                this.body.methods = n2 > 0 ? new JCMethod[n2] : JavaCompletion.EMPTY_METHODS;
                for (n = 0; n < n2; ++n) {
                    this.body.methods[n] = new Mtd(this);
                }
                try {
                    JCFileProvider.this.bodies.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

