/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.AbstractDefaultDirectoryProvider;
import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.Product;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import java.io.File;

final class DefaultDirectoryProviderWindows
implements DefaultDirectoryProvider {
    private final DefaultDirectoryProvider defaultDirectoryProvider;
    private final InstallConfiguration installConfiguration;
    private final Registry registry;
    private final Platform platform;

    @Inject
    DefaultDirectoryProviderWindows(Registry registry, InstallConfiguration installConfiguration, final Platform platform) {
        this.installConfiguration = installConfiguration;
        this.registry = registry;
        this.platform = platform;
        this.defaultDirectoryProvider = new AbstractDefaultDirectoryProvider(installConfiguration){

            @Override
            protected String getProductDirectory(InstallConfiguration installConfiguration, Product[] productArray) {
                return "MATLAB".concat(File.separator).concat(installConfiguration.getDefaultDirectoryName(platform, productArray));
            }
        };
    }

    @Override
    public File getDefaultDirectory(Product[] productArray) {
        File file;
        if (this.installConfiguration.isApplicationLocationStoredInRegistry(this.registry, this.platform.getArchString(), productArray) && (file = new File(this.installConfiguration.getApplicationLocation(this.registry, this.platform.getArchString(), productArray))).isDirectory()) {
            return file;
        }
        return this.defaultDirectoryProvider.getDefaultDirectory(productArray);
    }
}

