/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetDocumentBuilder;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.EmptyDocSetItemList;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.instutil.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class GenerateDocSetCommand
implements SharedDocSubCommand {
    private static final String DOCSET_FILE_NAME = "docset.xml";
    private final DocSetFileIO docSetFileIo;
    private final boolean writeEmptyFile;

    GenerateDocSetCommand(IO iO, boolean bl) {
        this(new DefaultDocSetFileIO(iO), bl);
    }

    GenerateDocSetCommand(DocSetFileIO docSetFileIO, boolean bl) {
        this.docSetFileIo = docSetFileIO;
        this.writeEmptyFile = bl;
    }

    @Override
    public void handleProductsFound(File file, DocSetItemList docSetItemList) throws InterruptedException, IOException {
        this.buildDocSet(file, docSetItemList);
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        if (this.writeEmptyFile) {
            this.buildDocSet(file, new EmptyDocSetItemList());
        } else {
            this.docSetFileIo.deleteDocsetFile(file);
        }
    }

    private void buildDocSet(File file, DocSetItemList docSetItemList) throws InterruptedException, IOException {
        this.docSetFileIo.deleteDocsetFile(file);
        DocSetDocumentBuilder docSetDocumentBuilder = new DocSetDocumentBuilder(docSetItemList);
        Document document = docSetDocumentBuilder.getDocument();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        try (OutputStream outputStream = this.docSetFileIo.getDocSetFileOutputStream(file);){
            xMLOutputter.output(document, outputStream);
        }
        catch (IOException iOException) {
            this.docSetFileIo.deleteDocsetFile(file);
            throw iOException;
        }
    }

    static class DefaultDocSetFileIO
    implements DocSetFileIO {
        private final IO io;

        DefaultDocSetFileIO(IO iO) {
            this.io = iO;
        }

        @Override
        public void deleteDocsetFile(File file) {
            File file2 = new File(file, GenerateDocSetCommand.DOCSET_FILE_NAME);
            if (this.io.isFile(file2)) {
                this.io.deleteFile(file2);
            }
        }

        @Override
        public OutputStream getDocSetFileOutputStream(File file) throws IOException {
            File file2 = new File(file, GenerateDocSetCommand.DOCSET_FILE_NAME);
            return new FileOutputStream(file2);
        }
    }

    static interface DocSetFileIO {
        public void deleteDocsetFile(File var1);

        public OutputStream getDocSetFileOutputStream(File var1) throws IOException;
    }
}

