/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.mnemonics;

import com.mathworks.desktop.mnemonics.MnemonicsManager;
import com.mathworks.desktop.mnemonics.MnemonicsManagerImpl;
import com.mathworks.util.event.AbstractInputEventsDispatcher;
import java.awt.Component;
import java.awt.KeyboardFocusManager;

public class MnemonicsManagers {
    private static final MnemonicsManagerFactory DEFAULT_FACTORY;
    private static MnemonicsManagerFactory sFactory;

    private MnemonicsManagers() {
    }

    public static MnemonicsManager get() {
        return sFactory.get();
    }

    public static void setFactory(MnemonicsManagerFactory mnemonicsManagerFactory) {
        sFactory = mnemonicsManagerFactory;
    }

    public static void setDefaultFactory() {
        MnemonicsManagers.setFactory(DEFAULT_FACTORY);
    }

    static {
        sFactory = DEFAULT_FACTORY = new DefaultFactory();
    }

    public static class DefaultFactory
    implements MnemonicsManagerFactory {
        private MnemonicsManager fManager;

        @Override
        public MnemonicsManager get() {
            if (this.fManager == null) {
                this.fManager = new MnemonicsManagerImpl(AbstractInputEventsDispatcher.getDefault(), new KeyboardFocusProvider(){

                    @Override
                    public Component getFocusOwner() {
                        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    }
                });
            }
            return this.fManager;
        }
    }

    public static interface MnemonicsManagerFactory {
        public MnemonicsManager get();
    }

    public static interface KeyboardFocusProvider {
        public Component getFocusOwner();
    }
}

