/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.util.concurrent;

import com.mathworks.toolbox.parallel.util.concurrent.Predicate;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateCondition;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateNotTrueException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.jetbrains.annotations.NotNull;

public final class ReentrantLock
extends java.util.concurrent.locks.ReentrantLock {
    @NotNull
    public PredicateCondition newPredicateCondition(Predicate predicate) {
        return new PredicateConditionImpl(predicate);
    }

    @Override
    @NotNull
    public PredicateCondition newCondition() {
        return new ConditionImpl();
    }

    private void ownLockCheck() {
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
    }

    private class ConditionImpl
    implements PredicateCondition {
        private final PredicateConditionImpl fCondition;
        private final PredicateConditionImpl fSignallingFinished;
        private int fNumToSignal = 0;
        private int fNumWaiters = 0;

        ConditionImpl() {
            this.fCondition = new PredicateConditionImpl(new Predicate(){

                @Override
                public boolean test() {
                    return ConditionImpl.this.fNumToSignal > 0;
                }
            });
            this.fSignallingFinished = new PredicateConditionImpl(new Predicate(){

                @Override
                public boolean test() {
                    return ConditionImpl.this.fNumToSignal <= 0;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            this.fSignallingFinished.await();
            try {
                this.beforeWait();
                this.fCondition.await();
                this.afterWait();
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitUninterruptibly() {
            ReentrantLock.this.ownLockCheck();
            this.fSignallingFinished.awaitUninterruptibly();
            try {
                this.beforeWait();
                this.fCondition.awaitUninterruptibly();
                this.afterWait();
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long awaitNanos(long l) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            l = this.fSignallingFinished.awaitNanos(l);
            if (l < 0L) {
                return l;
            }
            try {
                this.beforeWait();
                long l2 = this.fCondition.awaitNanos(l);
                this.afterWait();
                long l3 = l2;
                return l3;
            }
            finally {
                this.onAwaitExit();
            }
        }

        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.awaitNanos(timeUnit.toNanos(l)) > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean awaitUntil(@NotNull Date date) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            if (!this.fSignallingFinished.awaitDeadline(date)) {
                return false;
            }
            try {
                this.beforeWait();
                boolean bl = this.fCondition.awaitDeadline(date);
                this.afterWait();
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.onAwaitExit();
            }
        }

        @Override
        public void signal() {
            ReentrantLock.this.ownLockCheck();
            if (this.fNumWaiters > 0 && this.fNumToSignal < this.fNumWaiters) {
                ++this.fNumToSignal;
                this.fCondition.signal();
            }
        }

        @Override
        public void signalAll() {
            ReentrantLock.this.ownLockCheck();
            if (this.fNumWaiters > 0 && this.fNumToSignal < this.fNumWaiters) {
                this.fNumToSignal = this.fNumWaiters;
                this.fCondition.signalAll();
            }
        }

        private void beforeWait() {
            ++this.fNumWaiters;
        }

        private void afterWait() {
            if (this.fNumToSignal > 0) {
                --this.fNumToSignal;
                if (this.fNumToSignal == 0) {
                    this.fSignallingFinished.signalAll();
                }
            }
        }

        private void onAwaitExit() {
            --this.fNumWaiters;
            if (this.fNumWaiters == 0 && this.fNumToSignal > 0) {
                this.fNumToSignal = 0;
                this.fSignallingFinished.signalAll();
            }
        }
    }

    private class PredicateConditionImpl
    implements PredicateCondition {
        private final Predicate fPredicate;
        private final Condition fCondition;
        private static final String PREDICATE_FALSE_BEFORE_SIGNALLING = "Predicate must be true before signalling that it is true.";

        PredicateConditionImpl(Predicate predicate) {
            this.fPredicate = predicate;
            this.fCondition = ReentrantLock.super.newCondition();
        }

        @Override
        public void await() throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                this.fCondition.await();
            }
        }

        @Override
        public void awaitUninterruptibly() {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                this.fCondition.awaitUninterruptibly();
            }
        }

        @Override
        public long awaitNanos(long l) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                if (l > 0L) {
                    l = this.fCondition.awaitNanos(l);
                    continue;
                }
                return l;
            }
            return l;
        }

        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.awaitNanos(timeUnit.toNanos(l)) > 0L;
        }

        @Override
        public boolean awaitUntil(@NotNull Date date) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            return this.awaitDeadline(date);
        }

        boolean awaitDeadline(@NotNull Date date) throws InterruptedException {
            boolean bl = true;
            while (!this.fPredicate.test()) {
                if (bl) {
                    bl = this.fCondition.awaitUntil(date);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public void signal() {
            ReentrantLock.this.ownLockCheck();
            if (!this.fPredicate.test()) {
                throw new PredicateNotTrueException(PREDICATE_FALSE_BEFORE_SIGNALLING);
            }
            this.fCondition.signal();
        }

        @Override
        public void signalAll() {
            ReentrantLock.this.ownLockCheck();
            if (!this.fPredicate.test()) {
                throw new PredicateNotTrueException(PREDICATE_FALSE_BEFORE_SIGNALLING);
            }
            this.fCondition.signalAll();
        }
    }
}

