/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.LightButton;
import com.mathworks.widgets.ToolTipSourceParentIsNullException;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ClosableToolTip {
    private BalloonToolTip fBalloon;
    private final Rectangle fTargetBounds;
    private final ClosableToolTipData fData;
    private final Point fPoint;
    private final List<BalloonToolTip.ArrowDirection> fPossiblePositions;
    private static final int WINDOW_MOUSE_MOVE_BUFFER = 12;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.resources.RES_Widgets");

    public static ClosableToolTip show(MouseEvent mouseEvent, ClosableToolTipData closableToolTipData, Rectangle rectangle, List<BalloonToolTip.ArrowDirection> list, Point point) throws ToolTipSourceParentIsNullException {
        if (!closableToolTipData.isPreferenceSetToClose()) {
            ClosableToolTip closableToolTip = new ClosableToolTip(closableToolTipData, rectangle, list, point);
            Window window = SwingUtilities.windowForComponent((Component)mouseEvent.getSource());
            if (window == null) {
                throw new ToolTipSourceParentIsNullException("The tooltip source's parent is null.");
            }
            closableToolTip.show(window);
            return closableToolTip;
        }
        return null;
    }

    public void cleanup() {
        if (this.fBalloon != null) {
            this.fBalloon.cleanup();
        }
    }

    private ClosableToolTip(ClosableToolTipData closableToolTipData, Rectangle rectangle, List<BalloonToolTip.ArrowDirection> list, Point point) {
        this.fData = closableToolTipData;
        this.fTargetBounds = rectangle;
        this.fPossiblePositions = new ArrayList<BalloonToolTip.ArrowDirection>(list);
        this.fPoint = point;
    }

    private void show(Window window) {
        MJPanel mJPanel = new MJPanel();
        MJLabel mJLabel = new MJLabel(this.fData.getText());
        LightButton lightButton = new LightButton(BUNDLE.getString("button.tooltip.close"));
        lightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClosableToolTip.this.fData.setPreferenceToClose(true);
                ClosableToolTip.this.fBalloon.cleanup();
                ClosableToolTip.this.fBalloon = null;
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        if (this.fData.getIcon() != null) {
            MJLabel mJLabel2 = new MJLabel(this.fData.getIcon());
            mJPanel.setLayout((LayoutManager)new FormLayout("5px, p, 5px, p, 5px", "5px, fill:p, 5px, p, 5px"));
            mJPanel.add((Component)mJLabel2, (Object)cellConstraints.xy(2, 2, CellConstraints.LEFT, CellConstraints.TOP));
            mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(4, 2));
            mJPanel.add((Component)((Object)lightButton), (Object)cellConstraints.xy(4, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
        } else if (this.fData.isClosable()) {
            mJPanel.setLayout((LayoutManager)new FormLayout("5px, p, 5px", "5px, p, 5px, p, 5px"));
            mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
            mJPanel.add((Component)((Object)lightButton), (Object)cellConstraints.xy(2, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
        } else {
            mJPanel.setLayout((LayoutManager)new FormLayout("1dlu, p, 1dlu", "1dlu, p, 1dlu "));
            mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
        }
        mJPanel.setOpaque(true);
        mJPanel.setBackground(TooltipUtils.getTooltipBackground());
        this.fBalloon = this.createBalloonToolTip(window, mJPanel, mJLabel);
        this.fBalloon.getDialog().setName(this.fData.getName());
        this.fBalloon.show();
    }

    private BalloonToolTip createBalloonToolTip(Window window, MJPanel mJPanel, MJLabel mJLabel) {
        if (window instanceof Frame) {
            return new BalloonToolTip((Frame)window, (Component)mJPanel, this.fPossiblePositions, mJLabel.getPreferredSize(), this.fTargetBounds, this.fPoint);
        }
        if (window instanceof Dialog) {
            return new BalloonToolTip((Dialog)window, (Component)mJPanel, this.fPossiblePositions, mJLabel.getPreferredSize(), this.fTargetBounds, this.fPoint);
        }
        throw new IllegalArgumentException("Parent window type is not a Frame or Dialog");
    }

    public JDialog getDialog() {
        return this.fBalloon == null ? null : this.fBalloon.getDialog();
    }

    public boolean containsScreenPoint(Point point) {
        if (this.fBalloon != null) {
            Rectangle rectangle = this.fBalloon.getBounds();
            rectangle.x -= 12;
            rectangle.y -= 12;
            rectangle.height += 24;
            rectangle.width += 24;
            return rectangle.contains(point);
        }
        return false;
    }

    public static void preInit() {
        MJFrame mJFrame = new MJFrame();
        mJFrame.setPreferredSize(new Dimension(100, 100));
        BalloonToolTip balloonToolTip = new BalloonToolTip((Frame)mJFrame, (Component)new MJLabel(""), BalloonToolTip.EAST_WEST, new Dimension(10, 10), mJFrame.getBounds());
        balloonToolTip.show();
        mJFrame.dispose();
    }
}

