/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.swing.SearchEngineTextMatcherEditor;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.SelectAllUtils;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.FocusReturnHandler;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.KeyEventPreprocessor;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.PromptingTextField;
import com.mathworks.widgets.WidgetUtils;
import com.mathworks.widgets.WindowsWidgetFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public final class SearchTextField
implements ComponentBuilder {
    private final PromptingTextField fTextField;
    private JComponent fComponent;
    private JPopupMenu fOptionsPopupMenu = new MJPopupMenu();
    private PopupMenuCustomizer fOptionsMenuCustomizer;
    private List<Listener> fListeners = new ArrayList<Listener>();
    private FocusReturnHandler fFocusReturnHandler;
    public static final String TEXT_COMPONENT_NAME = "PromptingTextField";

    public SearchTextField() {
        this(PromptingTextField.getDefaultPromptText(), null);
    }

    public SearchTextField(String string) {
        this(string, null);
    }

    public SearchTextField(String string, KeyEventPreprocessor keyEventPreprocessor, MJPopupMenu mJPopupMenu) {
        this(new PromptingTextField(string, keyEventPreprocessor), null);
        if (mJPopupMenu != null) {
            this.fTextField.addContextMenu((JPopupMenu)mJPopupMenu);
        }
    }

    public SearchTextField(String string, PopupMenuCustomizer popupMenuCustomizer) {
        this(new PromptingTextField(string), popupMenuCustomizer);
    }

    private SearchTextField(PromptingTextField promptingTextField, PopupMenuCustomizer popupMenuCustomizer) {
        assert (promptingTextField != null) : "Supplied text field cannot be null";
        this.fTextField = promptingTextField;
        this.fOptionsMenuCustomizer = popupMenuCustomizer;
        this.fTextField.setName(TEXT_COMPONENT_NAME);
        this.fTextField.getAccessibleContext().setAccessibleName(WidgetUtils.lookup("searchTextField.accessibleName"));
        this.init();
        SelectAllUtils.install((Component)((Object)this.fTextField), (boolean)false);
    }

    private void init() {
        this.fComponent = this.buildComponent();
        this.fTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.createSearchAction());
        this.fTextField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), this.createCancelAction());
        this.fTextField.getDocument().addDocumentListener(this.createDocumentListener());
    }

    public void requestSearch() {
        for (Listener listener : this.fListeners) {
            listener.search(this.getSearchText());
        }
    }

    private void searchTextChanged() {
        for (Listener listener : this.fListeners) {
            listener.searchTextChanged(this.getSearchText());
        }
    }

    public void clearSearch() {
        if (this.fTextField.getText().length() > 0) {
            this.fTextField.setText("");
        }
        if (this.fFocusReturnHandler == null) {
            this.fTextField.requestFocus();
        } else {
            this.fFocusReturnHandler.relinquishFocus();
        }
        for (Listener listener : this.fListeners) {
            listener.searchCleared();
        }
    }

    public void enableFocusRelinquishing() {
        this.fFocusReturnHandler = new FocusReturnHandler((Component)((Object)this.fTextField));
    }

    public void requestFocus() {
        this.fTextField.requestFocusInWindow();
    }

    public void setEnabled(boolean bl) {
        ComponentUtils.setComponentEnabled((Container)this.getComponent(), (boolean)bl);
    }

    public void setPromptText(String string) {
        this.fTextField.setPromptText(string);
    }

    public <T> TextComponentMatcherEditor<T> createTextComponentMatcherEditor(TextFilterator<T> textFilterator) {
        return new TextComponentMatcherEditor((JTextComponent)((Object)this.fTextField), textFilterator);
    }

    public <T> SearchEngineTextMatcherEditor<T> createSearchEngineTextMatcherEditor(TextFilterator<T> textFilterator, Set<SearchEngineTextMatcherEditor.Field<T>> set) {
        SearchEngineTextMatcherEditor searchEngineTextMatcherEditor = new SearchEngineTextMatcherEditor((JTextField)((Object)this.fTextField), textFilterator);
        searchEngineTextMatcherEditor.setFields(set);
        this.addSearchTextFieldListener(new Listener(){

            private void doFilter() {
                SearchTextField.this.fTextField.postActionEvent();
            }

            @Override
            public void search(String string) {
                this.doFilter();
            }

            @Override
            public void searchTextChanged(String string) {
                this.doFilter();
            }

            @Override
            public void searchCleared() {
                this.doFilter();
            }
        });
        return searchEngineTextMatcherEditor;
    }

    public DocumentFilter getDocumentFilter() {
        DocumentFilter documentFilter = null;
        if (this.fTextField.getDocument() instanceof AbstractDocument) {
            documentFilter = ((AbstractDocument)this.fTextField.getDocument()).getDocumentFilter();
        }
        return documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        if (this.fTextField.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.fTextField.getDocument()).setDocumentFilter(documentFilter);
        }
    }

    public void addSearchTextFieldListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void removeSearchTextFieldListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public void selectAllSearchText() {
        this.fTextField.selectAll();
    }

    JTextComponent getTextComponent() {
        return this.fTextField;
    }

    private Action createSearchAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTextField.this.requestSearch();
            }
        };
    }

    private Action createCancelAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTextField.this.clearSearch();
            }
        };
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchTextField.this.searchTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchTextField.this.searchTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                SearchTextField.this.fOptionsMenuCustomizer.customize(SearchTextField.this.fOptionsPopupMenu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        };
    }

    private ActionListener createCancelButtonActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTextField.this.clearSearch();
            }
        };
    }

    private JComponent buildComponent() {
        JComponent jComponent = PlatformInfo.isMacOSLeopardOrLater() ? this.buildMacOSXLeopardOrLaterComponent() : this.buildDefaultComponent();
        jComponent.putClientProperty("mwjavaguitest.instance", this);
        return jComponent;
    }

    private JComponent buildDefaultComponent() {
        MJPanel mJPanel = new MJPanel();
        Insets insets = this.fTextField.getBorder() == null ? new Insets(0, 0, 0, 0) : this.fTextField.getBorder().getBorderInsets((Component)((Object)this.fTextField));
        mJPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), this.fTextField.getBorder()));
        mJPanel.setBackground(new Color(this.fTextField.getBackground().getRGB()));
        this.fTextField.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.fTextField.setBackground(null);
        AbstractButton abstractButton = this.fOptionsMenuCustomizer == null ? WindowsWidgetFactory.createSearchAndClearButton((JTextField)((Object)this.fTextField), this.createCancelButtonActionListener()) : WindowsWidgetFactory.createSearchWidgetButtonSet((JTextField)((Object)this.fTextField), this.createCancelButtonActionListener(), this.fOptionsPopupMenu, this.fOptionsMenuCustomizer);
        FormLayout formLayout = new FormLayout("d:grow, p", "p");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        panelBuilder.add((Component)((Object)this.fTextField), cellConstraints.xywh(1, 1, 1, 1, "fill, center"));
        panelBuilder.add((Component)abstractButton, cellConstraints.xywh(2, 1, 1, 1, "fill, fill"));
        return mJPanel;
    }

    private JComponent buildMacOSXLeopardOrLaterComponent() {
        this.fTextField.putClientProperty("JTextField.variant", "search");
        this.fTextField.putClientProperty("JTextField.Search.CancelAction", this.createCancelButtonActionListener());
        if (this.fOptionsMenuCustomizer != null) {
            this.fTextField.putClientProperty("JTextField.Search.FindPopup", this.fOptionsPopupMenu);
            this.fOptionsPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
        }
        return this.fTextField;
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    public String getSearchText() {
        return this.fTextField.getText();
    }

    public void setSearchText(String string) {
        this.fTextField.setText(string);
    }

    public void setSearchSelection(int n, int n2) {
        this.fTextField.select(n, n2);
    }

    static {
        MJUtilities.initJIDE();
    }

    public static interface Listener {
        public void search(String var1);

        public void searchTextChanged(String var1);

        public void searchCleared();
    }
}

