/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.util.StringUtils;
import com.mathworks.widgets.WidgetUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class SearchTextFieldHint {
    private final Category fCategory;
    private final String fHintText;
    public static final Matcher STARTS_WITH_MATCHER = SearchTextFieldHint.createStartsWithMatcher();
    public static final Matcher ALWAYS_MATCHER = SearchTextFieldHint.createAlwaysMatcher();
    public static final Category RECENT_SEARCHES_CATEGORY = new Category(WidgetUtils.lookup("intelliHints.defaultCategory.text"), 0, STARTS_WITH_MATCHER);

    public SearchTextFieldHint(String string) {
        this(string, RECENT_SEARCHES_CATEGORY);
    }

    public SearchTextFieldHint(String string, Category category) {
        Validate.notNull((Object)string, (String)"The hint cannot be null.");
        Validate.notEmpty((String)string, (String)"The hint cannot be empty.");
        Validate.notNull((Object)category, (String)"The category cannot be null.");
        this.fCategory = category;
        this.fHintText = string;
    }

    public Category getCategory() {
        return this.fCategory;
    }

    public String getDisplayString() {
        return this.fHintText;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof SearchTextFieldHint && this.getDisplayString().equals(((SearchTextFieldHint)object).getDisplayString()) && this.getCategory().equals(((SearchTextFieldHint)object).getCategory());
    }

    public String toString() {
        return this.fHintText;
    }

    public static List<SearchTextFieldHint> createHints(List<String> list) {
        ArrayList<SearchTextFieldHint> arrayList = new ArrayList<SearchTextFieldHint>();
        for (String string : list) {
            arrayList.add(new SearchTextFieldHint(string));
        }
        return arrayList;
    }

    public static List<String> createStrings(List<SearchTextFieldHint> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SearchTextFieldHint searchTextFieldHint : list) {
            arrayList.add(searchTextFieldHint.getDisplayString());
        }
        return arrayList;
    }

    private static Matcher createStartsWithMatcher() {
        return new Matcher(){

            @Override
            public boolean matches(SearchTextFieldHint searchTextFieldHint, String string) {
                return StringUtils.startsWith((String)searchTextFieldHint.getDisplayString(), (String)string, (int)0, (boolean)false);
            }
        };
    }

    private static Matcher createAlwaysMatcher() {
        return new Matcher(){

            @Override
            public boolean matches(SearchTextFieldHint searchTextFieldHint, String string) {
                return true;
            }
        };
    }

    public static interface Matcher {
        public boolean matches(SearchTextFieldHint var1, String var2);
    }

    public static final class Category
    implements Comparable<Category> {
        private final String fCategoryText;
        private final int fDisplayPriority;
        private final Matcher fMatcher;

        public Category(String string, int n) {
            this(string, n, ALWAYS_MATCHER);
        }

        public Category(String string, int n, Matcher matcher) {
            Validate.notNull((Object)string, (String)"The category text cannot be null.");
            Validate.notEmpty((String)string, (String)"The category text cannot be empty.");
            Validate.notNull((Object)matcher, (String)"The matcher cannot be null.");
            this.fCategoryText = string;
            this.fDisplayPriority = n;
            this.fMatcher = matcher;
        }

        public String getDisplayString() {
            return this.fCategoryText;
        }

        public int getDisplayPriority() {
            return this.fDisplayPriority;
        }

        boolean matches(SearchTextFieldHint searchTextFieldHint, String string) {
            return this.fMatcher.matches(searchTextFieldHint, string);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Category && this.getDisplayString().equals(((Category)object).getDisplayString()) && this.getDisplayPriority() == ((Category)object).getDisplayPriority();
        }

        @Override
        public int compareTo(Category category) {
            int n = this.getDisplayString().compareTo(category.getDisplayString());
            int n2 = Integer.valueOf(this.getDisplayPriority()).compareTo(category.getDisplayPriority());
            return n2 == 0 ? n : n2;
        }
    }
}

