/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.debug.ViewProvider;
import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.RobotUtils;
import com.mathworks.mwswing.api.ExtendedUndoManager;
import com.mathworks.mwswing.plaf.XORSplitPaneUI;
import com.mathworks.mwswing.undo.UndoManagerListener;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SplitScreenActions;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.fold.CodeFoldingUtilities;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public class SyntaxTextPaneMultiView
implements STPInterface {
    protected SyntaxTextPane fPrimaryPane;
    protected SyntaxTextPaneBase fSecondaryPane;
    private MJPanel fDisplayPanel = new MJPanel((LayoutManager)new BorderLayout());
    private MJStatusBar fStatusBar;
    private Map<String, ViewProvider> fLeftPanelViewProviders = new HashMap<String, ViewProvider>();
    private MJPanel fPrimaryLeftPanel;
    private MJPanel fSecondaryLeftPanel;
    private MJAbstractAction fSplitScreenOffAction;
    private MJAbstractAction fTopBottomAction;
    private MJAbstractAction fLeftRightAction;
    private MJAbstractAction fChangeFocusAction;
    private SplitScreenActions fSplitScreenActions;
    public static final int SPLIT_SCREEN_OFF = 0;
    public static final int TOP_BOTTOM_SPLIT = 1;
    public static final int LEFT_RIGHT_SPLIT = 2;
    private int fSplitScreenMode = 0;
    private DragButton fVerticalDragButton;
    private MJSplitPane fSplitPane;
    private MouseListener fDoubleClickListener = new DoubleClickListener();
    private static final double DEFAULT_DIVIDER_LOCATION = 0.5;
    protected double fDividerLocation = 0.5;
    private Dimension fLastMinimumSize;
    private Collection<CaretListener> fCaretListeners = new HashSet<CaretListener>();
    private Collection<KeyListener> fKeyListeners = new HashSet<KeyListener>();
    private Collection<FocusListener> fFocusListeners = new HashSet<FocusListener>();
    private Collection<MouseListener> fMouseListeners = new HashSet<MouseListener>();
    private Collection<MouseWheelListener> fMouseWheelListeners = new HashSet<MouseWheelListener>();
    private Collection<PropertyChangeListener> fOverwriteListeners = new HashSet<PropertyChangeListener>();
    private Collection<Observer> fIncSearchListeners = new HashSet<Observer>();
    private static final int ALMOST_CLOSED_AMOUNT = Math.max(8, new MJScrollPane().getHorizontalScrollBar().getPreferredSize().height);
    private FocusListener fLastActiveFocusListener = new LastActiveFocusListener();
    private SyntaxTextPaneBase fLastActivePane;
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private final List<ViewHierarchyChangeListener> fViewHierarchyListeners = new ArrayList<ViewHierarchyChangeListener>();
    public static final String BREAKPOINT_MARGIN_PANEL_NAME = "Breakpoint-Margin-Panel";

    public SyntaxTextPaneMultiView() {
        this.fPrimaryPane = this.createPrimarySTP();
        this.fPrimaryLeftPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fPrimaryLeftPanel.setName(BREAKPOINT_MARGIN_PANEL_NAME);
        this.fSplitScreenOffAction = new SplitScreenAction(0, "split-screen-off");
        this.fTopBottomAction = new SplitScreenAction(1, "split-screen-top-bottom");
        this.fLeftRightAction = new SplitScreenAction(2, "split-screen-left-right");
        this.fChangeFocusAction = new SwitchFocusAction("split-screen-switch-focus");
        this.fSplitScreenActions = new SplitScreenActions(this.fTopBottomAction, this.fLeftRightAction, this.fSplitScreenOffAction, this.fChangeFocusAction);
        MJPopupMenu mJPopupMenu = this.fPrimaryPane.getContextMenu();
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((JMenuItem)this.fSplitScreenActions.createMenu());
        this.addFocusListener(this.fLastActiveFocusListener);
    }

    protected void splitScreen(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Not acceptable type " + n);
        }
        int n2 = -1;
        int n3 = -1;
        Rectangle rectangle = null;
        JTextComponent jTextComponent = null;
        if (n != 0 && this.fSplitScreenMode == 0) {
            this.fChangeFocusAction.setEnabled(true);
            if (this.fSecondaryPane == null) {
                this.fSecondaryPane = this.fPrimaryPane.getClonedView();
                this.fSecondaryPane.getAccessibleContext().setAccessibleName(this.fPrimaryPane.getAccessibleContext().getAccessibleName());
                this.fSecondaryLeftPanel = new MJPanel((LayoutManager)new BorderLayout());
                Set<String> set = this.fLeftPanelViewProviders.keySet();
                if (!set.isEmpty()) {
                    for (String object : set) {
                        this.fSecondaryLeftPanel.add(this.fLeftPanelViewProviders.get(object).getView((ViewProviderKey)this.fSecondaryPane), (Object)object);
                    }
                    this.fSecondaryPane.setLeftPanel((JPanel)this.fSecondaryLeftPanel);
                }
                if (this.fStatusBar != null) {
                    this.fSecondaryPane.setClientStatusBar(this.fStatusBar);
                }
                for (CaretListener caretListener : this.fCaretListeners) {
                    this.fSecondaryPane.addCaretListener(caretListener);
                }
                for (KeyListener keyListener : this.fKeyListeners) {
                    this.fSecondaryPane.addKeyListener(keyListener);
                }
                for (MouseListener mouseListener : this.fMouseListeners) {
                    this.fSecondaryPane.addMouseListener(mouseListener);
                }
                for (MouseWheelListener mouseWheelListener : this.fMouseWheelListeners) {
                    this.fSecondaryPane.addMouseWheelListener(mouseWheelListener);
                }
                for (FocusListener focusListener : this.fFocusListeners) {
                    this.fSecondaryPane.addFocusListener(focusListener);
                }
                for (PropertyChangeListener propertyChangeListener : this.fOverwriteListeners) {
                    this.fSecondaryPane.addOverwriteListener(propertyChangeListener);
                }
                for (Observer observer : this.fIncSearchListeners) {
                    this.fSecondaryPane.addIncSearchObserver(observer);
                }
                for (ViewHierarchyChangeListener viewHierarchyChangeListener : this.fViewHierarchyListeners) {
                    this.fSecondaryPane.addViewHierarchyChangeListener(viewHierarchyChangeListener);
                }
                this.fSecondaryPane.setInputMap(2, this.fPrimaryPane.getInputMap(2));
                this.fSecondaryPane.setInputMap(0, this.fPrimaryPane.getInputMap(0));
                this.fSecondaryPane.setInputMap(1, this.fPrimaryPane.getInputMap(1));
                this.fSecondaryPane.setActionMap(this.fPrimaryPane.getActionMap());
            }
            SyntaxTextPaneMultiView.syncCodeFoldingState(this.fPrimaryPane, this.fSecondaryPane);
            n2 = this.fPrimaryPane.getCaret().getDot();
            n3 = this.fPrimaryPane.getCaret().getMark();
            rectangle = this.fPrimaryPane.getExtentBounds();
            jTextComponent = this.fSecondaryPane;
        } else if (n == 0) {
            this.fChangeFocusAction.setEnabled(false);
            SyntaxTextPaneBase syntaxTextPaneBase = this.getActiveSTP();
            if (syntaxTextPaneBase != null && syntaxTextPaneBase.equals(this.fSecondaryPane)) {
                n2 = this.fSecondaryPane.getCaret().getDot();
                n3 = this.fSecondaryPane.getCaret().getMark();
                rectangle = this.fSecondaryPane.getExtentBounds();
                jTextComponent = this.fPrimaryPane;
            }
            if (this.fSecondaryPane != null) {
                JumpList.removeEntries((JTextComponent)this.fSecondaryPane);
            }
        }
        this.fSplitScreenMode = n;
        this.populatePanel(n);
        if (n2 != -1) {
            jTextComponent.getCaret().setDot(n3);
            jTextComponent.getCaret().moveDot(n2);
            jTextComponent.scrollRectToVisible(rectangle);
        }
    }

    private static void syncCodeFoldingState(SyntaxTextPaneBase syntaxTextPaneBase, SyntaxTextPaneBase syntaxTextPaneBase2) {
        CodeFoldingUtilities.syncViewCodeFoldingStates(syntaxTextPaneBase, syntaxTextPaneBase2);
    }

    protected void populatePanel(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Not acceptable type " + n);
        }
        this.fDisplayPanel.removeAll();
        if (n != 0) {
            this.fSplitPane = new MJSplitPane(){

                public void updateUI() {
                    this.setUI((SplitPaneUI)new XORSplitPaneUI(ColorPrefs.getBackgroundColor()));
                }
            };
            ((BasicSplitPaneUI)this.fSplitPane.getUI()).getDivider().addMouseListener(this.fDoubleClickListener);
            this.fSplitPane.setResizeWeight(0.5);
            this.fSplitPane.setBorder(BorderFactory.createEmptyBorder());
            ((BasicSplitPaneUI)this.fSplitPane.getUI()).getDivider().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (SyntaxTextPaneMultiView.this.isSplitScreenAlmostClosed()) {
                        SyntaxTextPaneMultiView.this.triggerSplitScreenAction(0);
                    }
                }
            });
            if (n == 1) {
                this.fSplitPane.setOrientation(0);
                ((BasicSplitPaneUI)this.fSplitPane.getUI()).getDivider().setBorder(BorderFactory.createEmptyBorder());
            } else {
                this.fSplitPane.setOrientation(1);
            }
            JComponent jComponent = SyntaxTextPane.getDisplayComponent(this.fPrimaryPane);
            this.fLastMinimumSize = jComponent.getMinimumSize();
            jComponent.setMinimumSize(EMPTY_DIMENSION);
            this.fSplitPane.setLeftComponent((Component)jComponent);
            JComponent jComponent2 = SyntaxTextPane.getDisplayComponent(this.fSecondaryPane);
            jComponent2.setMinimumSize(EMPTY_DIMENSION);
            this.fSplitPane.setRightComponent((Component)jComponent2);
            this.fSplitPane.setDividerLocation(this.fDividerLocation);
            this.fDisplayPanel.add((Component)this.fSplitPane, (Object)"Center");
            ((MWEditorUI)Utilities.getEditorUI((JTextComponent)this.fPrimaryPane)).setCornerVisibility(false);
        } else {
            if (this.fSplitPane != null) {
                ((BasicSplitPaneUI)this.fSplitPane.getUI()).getDivider().removeMouseListener(this.fDoubleClickListener);
            }
            JComponent jComponent = SyntaxTextPane.getDisplayComponent(this.fPrimaryPane);
            if (this.fLastMinimumSize != null) {
                jComponent.setMinimumSize(this.fLastMinimumSize);
            }
            this.fDisplayPanel.add((Component)jComponent, (Object)"Center");
            if (this.fVerticalDragButton == null) {
                this.fVerticalDragButton = new DragButton(true);
                DragButton dragButton = new DragButton(false);
                ((MWEditorUI)Utilities.getEditorUI((JTextComponent)this.fPrimaryPane)).addCorners((Component)((Object)this.fVerticalDragButton), (Component)((Object)dragButton));
            }
            ((MWEditorUI)Utilities.getEditorUI((JTextComponent)this.fPrimaryPane)).setCornerVisibility(true);
        }
        this.fDisplayPanel.revalidate();
        this.fPrimaryPane.requestFocusInWindow();
    }

    protected SyntaxTextPane createPrimarySTP() {
        return new SyntaxTextPane();
    }

    protected SyntaxTextPane getPrimarySTP() {
        return this.fPrimaryPane;
    }

    protected SyntaxTextPaneBase getActiveSTP() {
        if (this.getSplitScreenMode() == 0 || this.fLastActivePane == null) {
            return this.fPrimaryPane;
        }
        return this.fLastActivePane;
    }

    @Override
    public void addViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null) {
            this.fPrimaryPane.addViewHierarchyChangeListener(viewHierarchyChangeListener);
            this.fViewHierarchyListeners.add(viewHierarchyChangeListener);
        }
    }

    @Override
    public void removeViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null) {
            this.fPrimaryPane.removeViewHierarchyChangeListener(viewHierarchyChangeListener);
            if (this.fSecondaryPane != null) {
                this.fSecondaryPane.removeViewHierarchyChangeListener(viewHierarchyChangeListener);
            }
            this.fViewHierarchyListeners.remove(viewHierarchyChangeListener);
        }
    }

    @Override
    public void read(InputStream inputStream, Object object, String string) throws IOException {
        this.fPrimaryPane.read(inputStream, object, string);
        this.updateSecondaryPaneContentType(string);
    }

    @Override
    public void read(File file) throws IOException {
        this.fPrimaryPane.read(file);
        this.updateSecondaryPaneContentType(this.fPrimaryPane.getContentType());
    }

    @Override
    public void read(InputStream inputStream, Object object, String string, String string2) throws IOException {
        this.fPrimaryPane.read(inputStream, object, string, string2);
        this.updateSecondaryPaneContentType(string);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.fPrimaryPane.write(writer);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.fPrimaryPane.write(outputStream);
    }

    @Override
    public void write(File file) throws IOException {
        this.fPrimaryPane.write(file);
    }

    @Override
    public void setDocument(Document document) {
        this.fPrimaryPane.setDocument(document);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setDocument(document);
        }
    }

    @Override
    public void setContentType(String string) {
        this.fPrimaryPane.setContentType(string);
        this.updateSecondaryPaneContentType(string);
    }

    @Override
    public String getContentType() {
        return this.fPrimaryPane.getContentType();
    }

    @Override
    public void setClientStatusBar(MJStatusBar mJStatusBar) {
        this.fStatusBar = mJStatusBar;
        this.fPrimaryPane.setClientStatusBar(mJStatusBar);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setClientStatusBar(mJStatusBar);
        }
    }

    @Override
    public Document getDocument() {
        return this.fPrimaryPane.getDocument();
    }

    @Override
    public EditorKit getEditorKit() {
        return this.fPrimaryPane.getEditorKit();
    }

    @Override
    public ExtendedUndoManager getUndoManager() {
        return this.fPrimaryPane.getUndoManager();
    }

    @Override
    public void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fPrimaryPane.addUndoManagerListener(undoManagerListener);
    }

    @Override
    public void removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fPrimaryPane.removeUndoManagerListener(undoManagerListener);
    }

    @Override
    public void setUndoManagerLimit(int n) {
        this.fPrimaryPane.setUndoManagerLimit(n);
    }

    @Override
    public void setUndoDirtyMarker() {
        this.fPrimaryPane.setUndoDirtyMarker();
    }

    @Override
    public void setUndoCleanMarker() {
        this.fPrimaryPane.setUndoCleanMarker();
    }

    @Override
    public void discardAllUndoEdits() {
        this.fPrimaryPane.discardAllUndoEdits();
    }

    @Override
    public boolean isDirty() {
        return this.fPrimaryPane.isDirty();
    }

    @Override
    public void setHighlightedLines(int[] nArray) {
        this.fPrimaryPane.setHighlightedLines(nArray);
    }

    @Override
    public void setBoldLines(int[] nArray) {
        this.fPrimaryPane.setBoldLines(nArray);
    }

    @Override
    public void setDrawAboveLines(int[] nArray) {
        this.fPrimaryPane.setDrawAboveLines(nArray);
    }

    @Override
    public void setFilename(String string) {
        this.fPrimaryPane.setFilename(string);
    }

    @Override
    public String getFilename() {
        return this.fPrimaryPane.getFilename();
    }

    @Override
    public String getUniqueKey() {
        return this.fPrimaryPane.getUniqueKey();
    }

    @Override
    public MJAbstractAction getCutAction() {
        return this.fPrimaryPane.getCutAction();
    }

    @Override
    public MJAbstractAction getCopyAction() {
        return this.fPrimaryPane.getCopyAction();
    }

    @Override
    public MJAbstractAction getPasteAction() {
        return this.fPrimaryPane.getPasteAction();
    }

    @Override
    public MJAbstractAction getUndoAction() {
        return this.fPrimaryPane.getUndoAction();
    }

    @Override
    public MJAbstractAction getRedoAction() {
        return this.fPrimaryPane.getRedoAction();
    }

    @Override
    public MJAbstractAction getIndentAction() {
        return this.fPrimaryPane.getIndentAction();
    }

    @Override
    public MJAbstractAction getUnindentAction() {
        return this.fPrimaryPane.getUnindentAction();
    }

    @Override
    public MJAbstractAction getSmartIndentAction() {
        return this.fPrimaryPane.getSmartIndentAction();
    }

    @Override
    public MJAbstractAction getSelectAllAction() {
        return this.fPrimaryPane.getSelectAllAction();
    }

    @Override
    public MJAbstractAction getDeleteAction() {
        return this.fPrimaryPane.getDeleteAction();
    }

    @Override
    public MJAbstractAction getCommentAction() {
        return this.fPrimaryPane.getCommentAction();
    }

    @Override
    public MJAbstractAction getUncommentAction() {
        return this.fPrimaryPane.getUncommentAction();
    }

    @Override
    public MJAbstractAction getWrapCommentsAction() {
        return this.fPrimaryPane.getWrapCommentsAction();
    }

    @Override
    public MJAbstractAction getToUpperCaseAction() {
        return this.fPrimaryPane.getToUpperCaseAction();
    }

    @Override
    public MJAbstractAction getToLowerCaseAction() {
        return this.fPrimaryPane.getToLowerCaseAction();
    }

    @Override
    public MJAbstractAction getPrevJumpAction() {
        return this.fPrimaryPane.getPrevJumpAction();
    }

    @Override
    public MJAbstractAction getNextJumpAction() {
        return this.fPrimaryPane.getNextJumpAction();
    }

    @Override
    public MJAbstractAction getCollapseAllFoldsAction() {
        return this.fPrimaryPane.getCollapseAllFoldsAction();
    }

    @Override
    public MJAbstractAction getExpandAllFoldsAction() {
        return this.fPrimaryPane.getExpandAllFoldsAction();
    }

    @Override
    public MJAbstractAction getExpandFoldAction() {
        return this.fPrimaryPane.getExpandFoldAction();
    }

    @Override
    public MJAbstractAction getCollapseFoldAction() {
        return this.fPrimaryPane.getCollapseFoldAction();
    }

    @Override
    public void validateCodeFoldActions() {
        this.getActiveSTP().validateCodeFoldActions();
    }

    @Override
    public MJAbstractAction getCodeFoldingMenuAction() {
        return this.fPrimaryPane.getCodeFoldingMenuAction();
    }

    @Override
    public MJPopupMenu getContextMenu() {
        return this.fPrimaryPane.getContextMenu();
    }

    @Override
    public ActionMap getActionMap() {
        return this.fPrimaryPane.getActionMap();
    }

    @Override
    public void setActionMap(ActionMap actionMap) {
        this.fPrimaryPane.setActionMap(actionMap);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setActionMap(actionMap);
        }
    }

    @Override
    public InputMap getInputMap(int n) {
        return this.fPrimaryPane.getInputMap(n);
    }

    @Override
    public InputMap getInputMap() {
        return this.fPrimaryPane.getInputMap();
    }

    @Override
    public void setInputMap(int n, InputMap inputMap) {
        this.fPrimaryPane.setInputMap(n, inputMap);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setInputMap(n, inputMap);
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.fPrimaryPane != null) {
            this.fPrimaryPane.setCursor(cursor);
        }
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setCursor(cursor);
        }
    }

    @Override
    public Color getLineNumberBackgroundColor() {
        return this.fPrimaryPane.getLineNumberBackgroundColor();
    }

    @Override
    public Color getLineNumberForeColor() {
        return this.fPrimaryPane.getLineNumberForeColor();
    }

    @Override
    public int getMinLineFromDocEvent(DocumentEvent documentEvent) {
        return this.fPrimaryPane.getMinLineFromDocEvent(documentEvent);
    }

    @Override
    public int getMaxLineFromDocEvent(DocumentEvent documentEvent) {
        return this.fPrimaryPane.getMaxLineFromDocEvent(documentEvent);
    }

    @Override
    public int getNumLines() {
        return this.fPrimaryPane.getNumLines();
    }

    @Override
    public int getLineHeight() {
        return this.fPrimaryPane.getLineHeight();
    }

    @Override
    public int getLineAscent() {
        return this.fPrimaryPane.getLineAscent();
    }

    @Override
    public void startBlockEdit() {
        this.fPrimaryPane.startBlockEdit();
    }

    @Override
    public void endBlockEdit() {
        this.fPrimaryPane.endBlockEdit();
    }

    @Override
    public int getLineFromPos(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineFromPos(n);
    }

    @Override
    public int getFirstNonWhitespace(int n) throws BadLocationException {
        return this.fPrimaryPane.getFirstNonWhitespace(n);
    }

    @Override
    public int getLineStart(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineStart(n);
    }

    @Override
    public int getLineEndNoEOL(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineEndNoEOL(n);
    }

    @Override
    public int getLineEnd(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineEnd(n);
    }

    @Override
    public int getLineEndFromPos(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineEndFromPos(n);
    }

    @Override
    public String getLineText(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineText(n);
    }

    @Override
    public String getLineTextNoEOL(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineTextNoEOL(n);
    }

    @Override
    public int getLineLength(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineLength(n);
    }

    @Override
    public int getLineLengthNoEOL(int n) throws BadLocationException {
        return this.fPrimaryPane.getLineLengthNoEOL(n);
    }

    @Override
    public char getCharAt(int n) throws BadLocationException {
        return this.fPrimaryPane.getCharAt(n);
    }

    @Override
    public char[] getChars(int n, int n2) throws BadLocationException {
        return this.fPrimaryPane.getChars(n, n2);
    }

    @Override
    public void insert(int n, String string) throws BadLocationException {
        this.fPrimaryPane.insert(n, string);
    }

    @Override
    public void insert(int n, char c) throws BadLocationException {
        this.fPrimaryPane.insert(n, c);
    }

    @Override
    public void delete(int n, int n2) throws BadLocationException {
        this.fPrimaryPane.delete(n, n2);
    }

    @Override
    public void replace(int n, int n2, String string) throws BadLocationException {
        this.fPrimaryPane.replace(n, n2, string);
    }

    @Override
    public String getText() {
        return this.fPrimaryPane.getText();
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        return this.fPrimaryPane.getText(n, n2);
    }

    @Override
    public String getTextStartEnd(int n, int n2) throws BadLocationException {
        return this.fPrimaryPane.getTextStartEnd(n, n2);
    }

    @Override
    public String getTerminator() {
        return this.fPrimaryPane.getTerminator();
    }

    @Override
    public int getLength() {
        return this.fPrimaryPane.getLength();
    }

    @Override
    public int getTotalWidthInChars(int n, int n2) throws BadLocationException {
        return this.fPrimaryPane.getTotalWidthInChars(n, n2);
    }

    @Override
    public int getColFromPos(int n) throws BadLocationException {
        return this.fPrimaryPane.getColFromPos(n);
    }

    @Override
    public int[] getTokenLocations(int n, int n2, TokenID[] tokenIDArray) throws BadLocationException {
        return this.fPrimaryPane.getTokenLocations(n, n2, tokenIDArray);
    }

    @Override
    public void printDocument(String string, int n, int n2) {
        this.fPrimaryPane.printDocument(string, n, n2);
    }

    @Override
    public int getWordStartFromPos(int n) throws BadLocationException {
        return this.fPrimaryPane.getWordStartFromPos(n);
    }

    @Override
    public int getWordEndFromPos(int n) throws BadLocationException {
        return this.fPrimaryPane.getWordEndFromPos(n);
    }

    @Override
    public void setEditable(boolean bl) {
        this.fPrimaryPane.setEditable(bl);
    }

    @Override
    public boolean isEditable() {
        return this.fPrimaryPane.isEditable();
    }

    @Override
    public void addCaretListener(CaretListener caretListener) {
        this.fCaretListeners.add(caretListener);
        this.fPrimaryPane.addCaretListener(caretListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addCaretListener(caretListener);
        }
    }

    @Override
    public void removeCaretListener(CaretListener caretListener) {
        this.fCaretListeners.remove(caretListener);
        this.fPrimaryPane.removeCaretListener(caretListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeCaretListener(caretListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.fKeyListeners.add(keyListener);
        this.fPrimaryPane.addKeyListener(keyListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.fKeyListeners.remove(keyListener);
        this.fPrimaryPane.removeKeyListener(keyListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addOverwriteListener(PropertyChangeListener propertyChangeListener) {
        this.fOverwriteListeners.add(propertyChangeListener);
        this.fPrimaryPane.addOverwriteListener(propertyChangeListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addOverwriteListener(propertyChangeListener);
        }
    }

    @Override
    public void removeOverwriteListener(PropertyChangeListener propertyChangeListener) {
        this.fOverwriteListeners.remove(propertyChangeListener);
        this.fPrimaryPane.removeOverwriteListener(propertyChangeListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeOverwriteListener(propertyChangeListener);
        }
    }

    @Override
    public void addIncSearchObserver(Observer observer) {
        this.fIncSearchListeners.add(observer);
        this.fPrimaryPane.addIncSearchObserver(observer);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addIncSearchObserver(observer);
        }
    }

    @Override
    public void removeIncSearchObserver(Observer observer) {
        this.fIncSearchListeners.remove(observer);
        this.fPrimaryPane.removeIncSearchObserver(observer);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeIncSearchObserver(observer);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.fMouseListeners.add(mouseListener);
        this.fPrimaryPane.addMouseListener(mouseListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.fMouseListeners.remove(mouseListener);
        this.fPrimaryPane.removeMouseListener(mouseListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.fMouseWheelListeners.add(mouseWheelListener);
        this.fPrimaryPane.addMouseWheelListener(mouseWheelListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.fMouseWheelListeners.remove(mouseWheelListener);
        this.fPrimaryPane.removeMouseWheelListener(mouseWheelListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.fFocusListeners.add(focusListener);
        this.fPrimaryPane.addFocusListener(focusListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.fFocusListeners.remove(focusListener);
        this.fPrimaryPane.removeFocusListener(focusListener);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.removeFocusListener(focusListener);
        }
    }

    @Override
    public Component getComponentForDialog() {
        return this.fDisplayPanel;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.getActiveSTP().isSelectionEmpty();
    }

    @Override
    public int getCaretPosition() {
        return this.getActiveSTP().getCaretPosition();
    }

    @Override
    public void setCaretPosition(int n) {
        this.getActiveSTP().setCaretPosition(n);
    }

    @Override
    public boolean isComposing() {
        return this.getActiveSTP().isComposing();
    }

    @Override
    public JTextComponent getActiveTextComponent() {
        return this.getActiveSTP().getActiveTextComponent();
    }

    @Override
    public int getSelectionStart() {
        return this.getActiveSTP().getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.getActiveSTP().getSelectionEnd();
    }

    @Override
    public int getSelectionDot() {
        return this.getActiveSTP().getSelectionDot();
    }

    @Override
    public int getSelectionMark() {
        return this.getActiveSTP().getSelectionMark();
    }

    @Override
    public void setSelectionStart(int n) {
        this.getActiveSTP().setSelectionStart(n);
    }

    @Override
    public void setSelectionEnd(int n) {
        this.getActiveSTP().setSelectionEnd(n);
    }

    @Override
    public void select(int n, int n2) {
        this.getActiveSTP().select(n, n2);
    }

    @Override
    public void setCursorPercentFromTop(int n) {
        this.getActiveSTP().setCursorPercentFromTop(n);
    }

    @Override
    public String getSelectedText() {
        return this.getActiveSTP().getSelectedText();
    }

    @Override
    public Caret getCaret() {
        return this.getActiveSTP().getCaret();
    }

    @Override
    public EditorUI getEditorUI() {
        return this.getActiveSTP().getEditorUI();
    }

    @Override
    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getActiveSTP().modelToView(n);
    }

    @Override
    public Rectangle getExtentBounds() {
        return this.getActiveSTP().getExtentBounds();
    }

    @Override
    public Rectangle getExtentBounds(Rectangle rectangle) {
        return this.getActiveSTP().getExtentBounds(rectangle);
    }

    @Override
    public Rectangle getBounds() {
        return this.getActiveSTP().getBounds();
    }

    @Override
    public Point getLocationOnScreen() {
        return this.getActiveSTP().getLocationOnScreen();
    }

    @Override
    public void requestFocus() {
        this.getActiveSTP().requestFocus();
    }

    @Override
    public void endIncSearch() {
        this.getActiveSTP().endIncSearch();
    }

    @Override
    public void startIncSearch(boolean bl) {
        this.getActiveSTP().startIncSearch(bl);
    }

    @Override
    public boolean isInsertMode() {
        return this.getActiveSTP().isInsertMode();
    }

    @Override
    public void selectAndCenterIfNotVisible(int n, int n2) {
        this.getActiveSTP().selectAndCenterIfNotVisible(n, n2);
    }

    @Override
    public int getLineFromY(int n) throws BadLocationException {
        return this.getActiveSTP().getLineFromY(n);
    }

    @Override
    public void paste() {
        this.getActiveSTP().paste();
    }

    @Override
    public void replaceSelection(String string) {
        this.getActiveSTP().replaceSelection(string);
    }

    @Override
    public Point getPointFromPos(int n) throws BadLocationException {
        return this.getActiveSTP().getPointFromPos(n);
    }

    @Override
    public int getPosFromPoint(Point point) throws BadLocationException {
        return this.getActiveSTP().getPosFromPoint(point);
    }

    @Override
    public void setSelFocusOverride(boolean bl) {
        this.getActiveSTP().setSelFocusOverride(bl);
    }

    @Override
    public void cleanup() {
        this.cloneCleanup();
        Set<String> set = this.fLeftPanelViewProviders.keySet();
        for (String string : set) {
            Component component = this.fLeftPanelViewProviders.get(string).clearView((ViewProviderKey)this.fPrimaryPane);
            if (component == null) continue;
            this.fPrimaryLeftPanel.remove(component);
        }
        this.fLeftPanelViewProviders.clear();
        this.removeFocusListener(this.fLastActiveFocusListener);
        this.fPrimaryPane.cleanup();
    }

    protected void cloneCleanup() {
        if (this.fSecondaryPane != null) {
            for (CaretListener iterator2 : this.fCaretListeners) {
                this.fSecondaryPane.removeCaretListener(iterator2);
            }
            for (KeyListener keyListener : this.fKeyListeners) {
                this.fSecondaryPane.removeKeyListener(keyListener);
            }
            for (MouseListener mouseListener : this.fMouseListeners) {
                this.fSecondaryPane.removeMouseListener(mouseListener);
            }
            for (MouseWheelListener mouseWheelListener : this.fMouseWheelListeners) {
                this.fSecondaryPane.removeMouseWheelListener(mouseWheelListener);
            }
            for (FocusListener focusListener : this.fFocusListeners) {
                this.fSecondaryPane.removeFocusListener(focusListener);
            }
            for (PropertyChangeListener propertyChangeListener : this.fOverwriteListeners) {
                this.fSecondaryPane.removeOverwriteListener(propertyChangeListener);
            }
            for (Observer observer : this.fIncSearchListeners) {
                this.fSecondaryPane.removeIncSearchObserver(observer);
            }
            this.fPrimaryPane.removeClonedView(this.fSecondaryPane);
            Set<String> set = this.fLeftPanelViewProviders.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Component component = this.fLeftPanelViewProviders.get(string).clearView((ViewProviderKey)this.fSecondaryPane);
                if (component == null) continue;
                this.fSecondaryLeftPanel.remove(component);
            }
            this.fSecondaryPane = null;
            this.fSecondaryLeftPanel = null;
        }
    }

    @Override
    public Component getDisplayComponent() {
        this.splitScreen(this.getSplitScreenMode());
        return this.fDisplayPanel;
    }

    public void addToLeftPanel(ViewProvider viewProvider, String string) throws IllegalArgumentException {
        if (!(string.equals("East") || string.equals("West") || string.equals("South") || string.equals("North"))) {
            throw new IllegalArgumentException("location must be one of the BorderLayout types");
        }
        this.fLeftPanelViewProviders.put(string, viewProvider);
        this.fPrimaryLeftPanel.add(viewProvider.getView((ViewProviderKey)this.fPrimaryPane), (Object)string);
        this.fPrimaryPane.setLeftPanel((JPanel)this.fPrimaryLeftPanel);
        if (this.fSecondaryPane != null) {
            this.fSecondaryLeftPanel.add(viewProvider.getView((ViewProviderKey)this.fSecondaryPane), (Object)string);
            this.fSecondaryPane.setLeftPanel((JPanel)this.fSecondaryLeftPanel);
        }
    }

    public void removeFromLeftPanel(ViewProvider viewProvider) {
        Set<String> set;
        this.fPrimaryLeftPanel.remove(viewProvider.getView((ViewProviderKey)this.fPrimaryPane));
        viewProvider.clearView((ViewProviderKey)this.fPrimaryPane);
        if (this.fSecondaryLeftPanel != null) {
            this.fSecondaryLeftPanel.remove(viewProvider.getView((ViewProviderKey)this.fSecondaryPane));
            viewProvider.clearView((ViewProviderKey)this.fSecondaryPane);
        }
        if (!(set = this.fLeftPanelViewProviders.keySet()).isEmpty()) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!this.fLeftPanelViewProviders.get(string).equals(viewProvider)) continue;
                iterator.remove();
                break;
            }
        }
    }

    public int getSplitScreenMode() {
        return this.fSplitScreenMode;
    }

    public SplitScreenActions getSplitScreenActions() {
        return this.fSplitScreenActions;
    }

    private static void registerActionWithKeybindingRegistry(MJAbstractAction mJAbstractAction, String string) {
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)mJAbstractAction);
    }

    private void updateSecondaryPaneContentType(String string) {
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.setContentType(string);
            this.fSecondaryPane.setDocument(this.fPrimaryPane.getDocument());
        }
    }

    private void triggerSplitScreenAction(int n) {
        if (n == 0) {
            this.fSplitScreenOffAction.setSelected(true);
            this.fSplitScreenOffAction.actionPerformed(new ActionEvent(this, 0, null));
        } else if (n == 1) {
            this.fTopBottomAction.setSelected(true);
            this.fTopBottomAction.actionPerformed(new ActionEvent(this, 0, null));
        } else {
            this.fLeftRightAction.setSelected(true);
            this.fLeftRightAction.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    private int getSplitOrientation() {
        Component[] componentArray = this.fDisplayPanel.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof MJSplitPane)) continue;
            return ((JSplitPane)componentArray[i]).getOrientation();
        }
        return -1;
    }

    private boolean isSplitScreenAlmostClosed() {
        int n = ALMOST_CLOSED_AMOUNT;
        return this.fSplitPane.getDividerLocation() <= this.fSplitPane.getMinimumDividerLocation() + n || this.fSplitPane.getDividerLocation() >= this.fSplitPane.getMaximumDividerLocation() - n;
    }

    protected void splitAndSetDividerLocation(int n, double d) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Not acceptable type " + n);
        }
        if (d < 0.0 || d > 1.0) {
            d = 0.5;
        }
        this.fDividerLocation = d;
        this.triggerSplitScreenAction(n);
        this.fDividerLocation = 0.5;
    }

    protected double getSplitDividerLocation() {
        if (this.getSplitScreenMode() == 0) {
            return this.fDividerLocation;
        }
        assert (this.fSplitPane != null) : "The split pane should not be null if we are in split screen mode";
        if (this.getSplitScreenMode() == 1) {
            return (double)this.fSplitPane.getDividerLocation() / (double)(this.fSplitPane.getHeight() - this.fSplitPane.getDividerSize());
        }
        return (double)this.fSplitPane.getDividerLocation() / (double)(this.fSplitPane.getWidth() - this.fSplitPane.getDividerSize());
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getActiveSTP().processKeyEvent(keyEvent);
    }

    public void setAccessibleName(String string) {
        this.fPrimaryPane.getAccessibleContext().setAccessibleName(string);
        if (this.fSecondaryPane != null) {
            this.fSecondaryPane.getAccessibleContext().setAccessibleName(string);
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                SyntaxTextPaneMultiView.this.triggerSplitScreenAction(0);
            }
        }
    }

    private class DragButtonMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    WindowFocusListener {
        private Robot iRobot;
        private final boolean iVertical;
        private Window iWindow;

        DragButtonMouseListener(boolean bl) {
            this.iVertical = bl;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getSource() instanceof DragButton) {
                SyntaxTextPaneMultiView.this.splitAndSetDividerLocation(((DragButton)((Object)mouseEvent.getSource())).iVertical ? 1 : 2, 0.5);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SyntaxTextPaneMultiView.this.getSplitScreenMode() == 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                block11: {
                    if (this.iRobot == null && this.isRobotSupportedForSplitScreen()) {
                        try {
                            this.iRobot = RobotUtils.createRobot();
                        }
                        catch (AWTException aWTException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block11;
                            aWTException.printStackTrace();
                        }
                    }
                }
                if (this.iRobot != null) {
                    Cursor cursor = Cursor.getPredefinedCursor(this.iVertical ? 9 : 11);
                    this.iWindow = SwingUtilities.windowForComponent(SyntaxTextPaneMultiView.this.fPrimaryPane);
                    assert (this.iWindow != null) : "Window for text component should not be null when entering splitscreen";
                    GlobalCursor.set((Window)this.iWindow, (Cursor)cursor);
                    this.iRobot.mouseRelease(16);
                    SyntaxTextPaneMultiView.this.splitAndSetDividerLocation(((DragButton)((Object)mouseEvent.getSource())).iVertical ? 1 : 2, 0.0);
                    Point point = ((BasicSplitPaneUI)SyntaxTextPaneMultiView.this.fSplitPane.getUI()).getDivider().getLocationOnScreen();
                    Point point2 = ((Component)mouseEvent.getSource()).getLocationOnScreen();
                    if (this.iVertical) {
                        this.iRobot.mouseMove(point2.x, point.y + SyntaxTextPaneMultiView.this.fSplitPane.getDividerSize() / 2);
                    } else {
                        this.iRobot.mouseMove(point.x + SyntaxTextPaneMultiView.this.fSplitPane.getDividerSize() / 2, point2.y);
                    }
                    this.iRobot.mousePress(16);
                    MouseListener[] mouseListenerArray = ((BasicSplitPaneUI)SyntaxTextPaneMultiView.this.fSplitPane.getUI()).getDivider().getMouseListeners();
                    boolean bl = true;
                    for (int i = 0; i != mouseListenerArray.length; ++i) {
                        if (mouseListenerArray[i] != this) continue;
                        bl = false;
                    }
                    if (bl) {
                        ((BasicSplitPaneUI)SyntaxTextPaneMultiView.this.fSplitPane.getUI()).getDivider().addMouseListener(this);
                        this.iWindow.addWindowFocusListener(this);
                    }
                } else {
                    this.mouseClicked(mouseEvent);
                }
            }
        }

        private boolean isRobotSupportedForSplitScreen() {
            return RobotUtils.isSupportedRobotPlatform() && !PlatformInfo.isLinux();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!(mouseEvent.getSource() instanceof DragButton)) {
                this.endInitialDragOperation();
            }
        }

        private void endInitialDragOperation() {
            assert (SyntaxTextPaneMultiView.this.fSplitPane != null) : "Split pane should not be null when ending the drag";
            ((BasicSplitPaneUI)SyntaxTextPaneMultiView.this.fSplitPane.getUI()).getDivider().removeMouseListener(this);
            if (this.iWindow != null) {
                GlobalCursor.clear((Window)this.iWindow);
                this.iWindow.removeWindowFocusListener(this);
                this.iWindow = null;
            }
            if (SyntaxTextPaneMultiView.this.getSplitScreenMode() != 0 && SyntaxTextPaneMultiView.this.isSplitScreenAlmostClosed()) {
                SyntaxTextPaneMultiView.this.triggerSplitScreenAction(0);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            this.endInitialDragOperation();
        }
    }

    private class DragButton
    extends MJPanel {
        private final boolean iVertical;

        private DragButton(boolean bl) {
            this.iVertical = bl;
            int n = Math.max(4, ALMOST_CLOSED_AMOUNT / 3);
            if (this.iVertical) {
                this.setPreferredSize(new Dimension(1, n));
                this.setMinimumSize(new Dimension(1, n));
                this.setName("VerticalSplitWidget");
                this.setToolTipText(SyntaxTextPaneUtilities.intlString("top-bottom-tooltip"));
            } else {
                this.setPreferredSize(new Dimension(n, 1));
                this.setMinimumSize(new Dimension(n, 1));
                this.setName("HorizontalSplitWidget");
                this.setToolTipText(SyntaxTextPaneUtilities.intlString("left-right-tooltip"));
            }
            this.setBackground(Color.DARK_GRAY.brighter());
            if (this.iVertical) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
            DragButtonMouseListener dragButtonMouseListener = new DragButtonMouseListener(this.iVertical);
            this.addMouseListener(dragButtonMouseListener);
            this.addMouseMotionListener(dragButtonMouseListener);
        }
    }

    private class LastActiveFocusListener
    implements FocusListener {
        private LastActiveFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SyntaxTextPaneMultiView.this.fLastActivePane = (SyntaxTextPaneBase)focusEvent.getSource();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class SwitchFocusAction
    extends MJAbstractAction {
        private SwitchFocusAction(String string) {
            SyntaxTextPaneMultiView.registerActionWithKeybindingRegistry(this, string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SyntaxTextPaneMultiView.this.getSplitScreenMode() != 0) {
                SyntaxTextPaneBase syntaxTextPaneBase = SyntaxTextPaneMultiView.this.getActiveSTP();
                if (syntaxTextPaneBase.equals(SyntaxTextPaneMultiView.this.fPrimaryPane)) {
                    SyntaxTextPaneMultiView.this.fSecondaryPane.requestFocusInWindow();
                } else {
                    SyntaxTextPaneMultiView.this.fPrimaryPane.requestFocusInWindow();
                }
            }
        }
    }

    private class SplitScreenAction
    extends MJAbstractAction {
        private int iMode;

        private SplitScreenAction(int n, String string) {
            if (n == 0) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.iMode = n;
            SyntaxTextPaneMultiView.registerActionWithKeybindingRegistry(this, string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextPaneMultiView.this.splitScreen(this.iMode);
            if (!this.isSelected()) {
                this.setSelected(true);
            }
        }

        public int getType() {
            return this.iMode;
        }
    }
}

