/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.datatransfer;

import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.widgets.datatransfer.MATFileVariableReference;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MLDataFlavor
extends MJDataFlavor {
    public static final DataFlavor serializedVariableListFlavor = MLDataFlavor.createConstant((String)"application/x-matlab-serialized-variable-list;class=java.util.List", null);
    public static final DataFlavor simpleVariableListFlavor = MLDataFlavor.createConstant((String)"application/x-matlab-variable-list;class=java.util.List", null);
    public static final DataFlavor matReferenceListFlavor = MLDataFlavor.createConstant((String)"application/x-matlab-mat-reference-list;class=java.util.List", null);
    public static final DataFlavor cwPromptlessStringFlavor = MLDataFlavor.createConstant((String)"application/x-matlab-promptless-string;class=java.lang.String", null);

    public static SimpleVariableDefinition[] decodeSerializedVariableListFlavor(Transferable transferable) throws UnsupportedFlavorException, IOException, IllegalArgumentException {
        return MLDataFlavor.decodeList(transferable, serializedVariableListFlavor, SimpleVariableDefinition.class);
    }

    public static SimpleVariableDefinition[] decodeSimpleVariableListFlavor(Transferable transferable) throws UnsupportedFlavorException, IOException, IllegalArgumentException {
        return MLDataFlavor.decodeList(transferable, simpleVariableListFlavor, SimpleVariableDefinition.class);
    }

    public static MATFileVariableReference[] decodeMatReferenceListFlavor(Transferable transferable) throws UnsupportedFlavorException, IOException, IllegalArgumentException {
        return MLDataFlavor.decodeList(transferable, matReferenceListFlavor, MATFileVariableReference.class);
    }

    private static <C> C[] decodeList(Transferable transferable, DataFlavor dataFlavor, Class<C> clazz) throws UnsupportedFlavorException, IOException, IllegalArgumentException {
        List list;
        try {
            list = (List)transferable.getTransferData(dataFlavor);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Data of flavor " + dataFlavor.getHumanPresentableName() + " is not a List, as required by the flavor's contract.");
        }
        Iterator iterator = list.iterator();
        Object[] objectArray = (Object[])Array.newInstance(clazz, list.size());
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) {
                throw new IllegalArgumentException("List in flavor " + dataFlavor.getHumanPresentableName() + " does not contain " + clazz.getName() + "s, as required by the flavor's contract.");
            }
            objectArray[n] = e;
            ++n;
        }
        return objectArray;
    }

    public static Transferable encodeSerializedVariableListFlavor(SimpleVariableDefinition[] simpleVariableDefinitionArray) {
        return new MJTransferable(Arrays.asList(simpleVariableDefinitionArray), serializedVariableListFlavor);
    }

    public static Transferable encodeSimpleVariableListFlavor(SimpleVariableDefinition[] simpleVariableDefinitionArray) {
        return new MJTransferable(Arrays.asList(simpleVariableDefinitionArray), simpleVariableListFlavor);
    }

    public static Transferable encodeMatReferenceListFlavor(MATFileVariableReference[] mATFileVariableReferenceArray) {
        return new MJTransferable(Arrays.asList(mATFileVariableReferenceArray), matReferenceListFlavor);
    }

    public static String getSimpleVariableStringRepresentation(Transferable transferable) throws UnsupportedFlavorException, IOException {
        AbstractList abstractList = (AbstractList)transferable.getTransferData(simpleVariableListFlavor);
        StringBuffer stringBuffer = new StringBuffer(((SimpleVariableDefinition)abstractList.get(0)).getLiteral());
        for (int i = 1; i < abstractList.size(); ++i) {
            stringBuffer.append(",");
            stringBuffer.append(((SimpleVariableDefinition)abstractList.get(i)).getLiteral());
        }
        return stringBuffer.toString();
    }
}

