/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MouseInputLatch;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTComponentBar;
import com.mathworks.widgets.desk.DTComponentResizer;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocuments;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTEdgeButton;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNestingContainer;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTBorderContainer
extends MJPanel
implements DTContainer,
PropertyChangeListener,
DTDropTarget,
DTComponentBar.DragOffListener {
    private final Desktop fDesktop;
    private DTMultipleClientFrame fFrame;
    private DTGroup fGroup;
    private boolean fAccommodateHeavyweights;
    private Container fCenterContainer;
    private DTComponentBar[] fEdgeBars = new DTComponentBar[MAX_EDGE_VALUE + 1];
    private Container fUnfurledPanel;
    private Component fCenterComponent;
    private HashMap<DTOccupant, EdgeOccupant> fEdgeOccupantMap = new HashMap();
    private DTOccupant fMaximizedOccupant;
    private Timer fFurlUnfurlTimer;
    private long fUnfurlStartTime;
    private long fFurlStartTime;
    private DTOccupant fOccupantWaitingToUnfurl;
    private DTOccupant fUnfurledOccupant;
    private boolean fIsUnfurling;
    private boolean fIsFurling;
    private boolean fFurlUponMouseExit;
    private MouseInputListener fEdgeListener = new MouseInputLatch((MouseInputListener)new EdgeResizer());
    private MouseListener fButtonListener = new ButtonListener();
    private AWTEventListener fMouseExitListener;
    private boolean fBlockUnfurledLayout;
    private WindowListener fFrameListener;
    private static final int UNFURLED_MARGIN = 50;
    private static final int UNFURL_UPDATE_INTERVAL = 50;
    private static final int UNFURL_DURATION = 400;
    private static final int FURL_DURATION = 250;
    private static final int HOVER_UNFURL_DELAY = 750;
    private static final float DEFAULT_UNFURLED_WIDTH_FRACTION = 0.333f;
    private static final float DEFAULT_UNFURLED_HEIGHT_FRACTION = 0.5f;
    private static final Dimension DROP_OUTLINE_SIZE = new Dimension(75, 20);
    private static final int[] EDGES = new int[]{1, 5, 3, 7};
    private static final int MAX_EDGE_VALUE = Math.max(1, Math.max(5, Math.max(3, 7)));
    static final String BORDERS_TAG = "Borders";
    private static final String GROUP_TAG = "Group";
    private static final String DOCUMENTS_TAG = "Documents";
    private static final String VIEW_TAG = "View";
    private static final String NAME_ATTRIBUTE = "Name";
    private static final String TITLE_ATTRIBUTE = "Title";
    private static final String[] EDGE_TAG = new String[]{"Top", "Bottom", "Right", "Left"};
    private static final String CENTER_TAG = "Center";

    DTBorderContainer(Desktop desktop, DTMultipleClientFrame dTMultipleClientFrame) {
        this(desktop, dTMultipleClientFrame, null);
    }

    DTBorderContainer(Desktop desktop, DTMultipleClientFrame dTMultipleClientFrame, DTGroup dTGroup) {
        this.fDesktop = desktop;
        this.fGroup = dTGroup;
        this.setFrame(dTMultipleClientFrame);
        this.setName("DesktopBorderContainer");
        this.setLayout(new BorderLayout());
        this.fAccommodateHeavyweights = this.fGroup == null ? this.fDesktop.accommodateHeavyweightClients() : this.fGroup.mayHaveHeavyContent();
        this.addComponents();
        this.fFurlUnfurlTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTBorderContainer.this.fUnfurledOccupant != null) {
                    if (DTBorderContainer.this.fIsUnfurling) {
                        DTBorderContainer.this.continueUnfurl();
                    } else {
                        DTBorderContainer.this.continueFurl();
                    }
                }
            }
        });
        this.fFurlUnfurlTimer.setInitialDelay(0);
    }

    private void addComponents() {
        if (this.fAccommodateHeavyweights) {
            if (this.fGroup == null) {
                for (int n : EDGES) {
                    HeavyPanel heavyPanel = new HeavyPanel();
                    heavyPanel.setVisible(false);
                    heavyPanel.setLayout(new BorderLayout());
                    this.add(heavyPanel, DTBorderContainer.getConstraintsForEdge(n));
                    if (this.fEdgeBars[n] == null) continue;
                    heavyPanel.add((Component)((Object)this.fEdgeBars[n]), CENTER_TAG);
                }
                if (!(this.fCenterContainer instanceof LightCenterContainer)) {
                    this.fCenterContainer = new LightCenterContainer();
                }
            } else if (!(this.fCenterContainer instanceof HeavyCenterContainer)) {
                this.fCenterContainer = new HeavyCenterContainer();
            }
            if (!(this.fUnfurledPanel instanceof HeavyPanel)) {
                this.fUnfurledPanel = new HeavyPanel();
            }
        } else {
            if (!(this.fCenterContainer instanceof LightCenterContainer)) {
                this.fCenterContainer = new LightCenterContainer();
            }
            if (!(this.fUnfurledPanel instanceof MJPanel)) {
                this.fUnfurledPanel = new MJPanel();
            }
        }
        for (int n : EDGES) {
            if (this.fEdgeBars[n] == null || this.fEdgeBars[n].getParent() != null) continue;
            this.add((Component)((Object)this.fEdgeBars[n]), DTBorderContainer.getConstraintsForEdge(n));
        }
        this.fUnfurledPanel.setLayout(new BorderLayout());
        this.fUnfurledPanel.addComponentListener(new UnfurledComponentListener());
        this.fUnfurledPanel.setVisible(false);
        this.fCenterContainer.add(this.fUnfurledPanel);
        if (this.fCenterComponent != null) {
            this.fCenterContainer.add(this.fCenterComponent);
        }
        this.add(this.fCenterContainer, CENTER_TAG);
    }

    DTFrame getFrame() {
        return this.fFrame;
    }

    void setFrame(DTFrame dTFrame) {
        assert (dTFrame == null || dTFrame instanceof DTMultipleClientFrame);
        if (this.fFrame != null) {
            this.fFrame.removeWindowListener(this.fFrameListener);
        }
        this.fFrame = (DTMultipleClientFrame)dTFrame;
        if (this.fFrame != null) {
            if (this.fFrameListener == null) {
                this.fFrameListener = new WindowAdapter(){

                    @Override
                    public void windowDeactivated(WindowEvent windowEvent) {
                        if (DTBorderContainer.this.fUnfurledOccupant != null && !DTBorderContainer.this.fUnfurledOccupant.isSelected()) {
                            DTBorderContainer.this.furlUnfurledOccupant();
                        }
                    }
                };
            }
            this.fFrame.addWindowListener(this.fFrameListener);
        }
    }

    void setCenterComponent(Component component) {
        if (component == this.fCenterComponent) {
            return;
        }
        if (this.fCenterComponent != null) {
            this.fCenterContainer.remove(this.fCenterComponent);
        }
        if (component != null) {
            this.fCenterContainer.add(component);
        }
        this.fCenterComponent = component;
    }

    Component getCenterComponent() {
        return this.fCenterComponent;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        if (!(dTLocation instanceof DTBorderLocation)) {
            dTLocation = new DTBorderLocation(7);
        }
        this.addOccupant(dTOccupant, dTLocation);
        if (dTOccupant.isMinimizing()) {
            this.beginMinimize(dTOccupant);
        }
    }

    private void beginMinimize(DTOccupant dTOccupant) {
        if (!(this.fUnfurledOccupant != null || this.fIsFurling || this.fIsUnfurling || this.fFurlUnfurlTimer.isRunning() || dTOccupant instanceof DTClient && ((DTClient)dTOccupant).hasSurrogateComponent())) {
            this.configureUnfurl(dTOccupant, System.currentTimeMillis() - 400L);
            this.continueUnfurl();
            this.beginFurl();
        }
    }

    private void addOccupant(DTOccupant dTOccupant, DTLocation dTLocation) {
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        this.configureInternalFrame(dTInternalFrame, dTLocation.getEdge());
        if (dTLocation.getEdge() == 0) {
            assert (this.fMaximizedOccupant == null);
            if (this.fCenterComponent != null) {
                this.fCenterComponent.setVisible(false);
            }
            this.fMaximizedOccupant = dTOccupant;
            this.fCenterContainer.add((Component)((Object)dTInternalFrame));
        } else {
            int n = dTLocation.getEdge();
            EdgeOccupant edgeOccupant = new EdgeOccupant(dTOccupant, n);
            this.fEdgeOccupantMap.put(dTOccupant, edgeOccupant);
            this.addToEdge(edgeOccupant);
            if (this.fMouseExitListener == null) {
                this.fMouseExitListener = new MouseExitListener();
                Toolkit.getDefaultToolkit().addAWTEventListener(this.fMouseExitListener, 32L);
            }
        }
        dTOccupant.addPropertyListener(this);
        this.revalidate();
        this.repaint();
        dTLocation.setFrame(this.fFrame);
        dTLocation.setContainer(this);
        dTOccupant.setLocation(dTLocation);
        if (dTOccupant.isSelected() && dTLocation.getEdge() != 0) {
            EdgeOccupant edgeOccupant = this.fEdgeOccupantMap.get(dTOccupant);
            if (edgeOccupant != null) {
                edgeOccupant.iAction.setSelected(true);
            }
            this.initiateUnfurl(dTOccupant);
        }
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        if (!(dTOccupant.getLocation() instanceof DTBorderLocation)) {
            return;
        }
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        DTBorderContainer.restoreInternalFrame(dTInternalFrame);
        int n = dTOccupant.getLocation().getEdge();
        if (n == 0) {
            if (dTOccupant == this.fMaximizedOccupant) {
                this.fCenterContainer.remove((Component)((Object)dTInternalFrame));
                if (this.fCenterComponent != null) {
                    this.fCenterComponent.setVisible(true);
                }
                this.fMaximizedOccupant = null;
            }
        } else {
            EdgeOccupant edgeOccupant = this.fEdgeOccupantMap.remove(dTOccupant);
            if (edgeOccupant == null) {
                return;
            }
            this.removeFromEdge(edgeOccupant);
            if (dTOccupant == this.fUnfurledOccupant) {
                this.fFurlUnfurlTimer.stop();
                this.completeFurl();
                this.setWaitingToUnfurl(null);
            } else if (dTOccupant == this.fOccupantWaitingToUnfurl) {
                this.setWaitingToUnfurl(null);
            }
            if (this.fEdgeOccupantMap.size() == 0) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fMouseExitListener);
                this.fMouseExitListener = null;
            }
        }
        dTOccupant.removePropertyListener(this);
        this.revalidate();
        this.repaint();
        dTOccupant.getLocation().setContainer(null);
        dTOccupant.setLocation(null);
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        if (dTOccupant != this.fMaximizedOccupant && dTOccupant != this.fUnfurledOccupant) {
            this.initiateUnfurl(dTOccupant);
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return dTOccupant.getLocation().getEdge() != 0;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new KeyControlledResizer().activate(dTOccupant, (Container)((Object)this));
    }

    public void revealCenterComponent() {
        this.furlUnfurledOccupant();
        if (this.fMaximizedOccupant != null) {
            this.fDesktop.setOccupantMaximized(this.fMaximizedOccupant, false);
        }
    }

    DTOccupant getUnfurledOccupant() {
        return this.fUnfurledOccupant;
    }

    void furlUnfurledOccupant() {
        if (this.fUnfurledOccupant != null && (!this.fFurlUnfurlTimer.isRunning() || this.fIsUnfurling)) {
            this.beginFurl();
        }
    }

    private boolean unfurlFurlInstantly() {
        return this.fDesktop.unfurlFurlInstantly() || this.fAccommodateHeavyweights && (PlatformInfo.isMacintosh() || this.fUnfurledOccupant != null && this.fUnfurledOccupant.getLocation().getEdge() == 1);
    }

    private void initiateUnfurl(DTOccupant dTOccupant) {
        if (dTOccupant == this.fUnfurledOccupant || dTOccupant == this.fOccupantWaitingToUnfurl) {
            return;
        }
        if (this.fFurlUnfurlTimer.isRunning()) {
            this.setWaitingToUnfurl(dTOccupant);
            this.fIsUnfurling = false;
            EdgeOccupant edgeOccupant = this.fEdgeOccupantMap.get(this.fUnfurledOccupant);
            if (edgeOccupant != null) {
                edgeOccupant.iAction.setSelected(false);
            }
        } else if (this.fUnfurledOccupant != null) {
            this.setWaitingToUnfurl(dTOccupant);
            this.beginFurl();
        } else {
            this.beginUnfurl(dTOccupant);
        }
    }

    private void beginUnfurl(DTOccupant dTOccupant) {
        assert (this.fUnfurledOccupant == null);
        assert (!this.fFurlUnfurlTimer.isRunning());
        this.fUnfurledOccupant = dTOccupant;
        dTOccupant.prepareToShow();
        this.configureUnfurl(dTOccupant, System.currentTimeMillis() - 50L);
        if (this.unfurlFurlInstantly()) {
            this.continueUnfurl();
        } else {
            this.fFurlUnfurlTimer.start();
        }
    }

    private void configureUnfurl(DTOccupant dTOccupant, long l) {
        this.fUnfurledOccupant = dTOccupant;
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        dTInternalFrame.addMouseListener(this.fEdgeListener);
        dTInternalFrame.addMouseMotionListener(this.fEdgeListener);
        Dimension dimension = this.fCenterComponent != null ? this.fCenterComponent.getSize() : this.getSize();
        DTLocation dTLocation = dTOccupant.getLocation();
        Dimension dimension2 = dTLocation.getFrameSize();
        int n = dTLocation.getEdge();
        if (n == 1 || n == 5) {
            if (dimension2.height == Integer.MIN_VALUE && dTOccupant.getLastNestedLocation() != null) {
                dimension2.height = dTOccupant.getLastNestedLocation().getFrameHeight();
            }
            if (dimension2.height == Integer.MIN_VALUE) {
                dimension2.height = (int)((float)dimension.height * 0.5f);
            } else if (dimension2.height > dimension.height - 50) {
                dimension2.height = dimension.height - 50;
            }
        } else if (n == 3 || n == 7) {
            if (dimension2.width == Integer.MIN_VALUE && dTOccupant.getLastNestedLocation() != null) {
                dimension2.width = dTOccupant.getLastNestedLocation().getFrameWidth();
            }
            if (dimension2.width == Integer.MIN_VALUE) {
                dimension2.width = (int)((float)dimension.width * 0.333f);
            } else if (dimension2.width > dimension.width - 50) {
                dimension2.width = dimension.width - 50;
            }
        }
        dTLocation.setFrameSize(dimension2);
        dTOccupant.locationChanged();
        this.fUnfurledPanel.setSize(dimension2);
        this.fUnfurledPanel.add((Component)((Object)dTInternalFrame), CENTER_TAG);
        this.fUnfurlStartTime = l;
        this.fIsUnfurling = true;
    }

    private void continueUnfurl() {
        assert (this.fUnfurledOccupant != null);
        long l = System.currentTimeMillis() - this.fUnfurlStartTime;
        float f = this.computeUnfurlFraction(l);
        if (f > 1.0f) {
            f = 1.0f;
        }
        DTLocation dTLocation = this.fUnfurledOccupant.getLocation();
        Rectangle rectangle = this.getUnfurledBounds(this.fCenterContainer.getSize(), dTLocation.getFrameSize(), dTLocation.getEdge(), f);
        this.fUnfurledPanel.setBounds(rectangle);
        if (!this.fUnfurledPanel.isVisible()) {
            this.fUnfurledOccupant.getInternalFrame().revalidate();
            this.fUnfurledOccupant.getInternalFrame().repaint();
            this.fUnfurledPanel.setVisible(true);
        }
        if (f == 1.0f) {
            this.completeUnfurl();
        }
    }

    private float computeUnfurlFraction(long l) {
        if (this.unfurlFurlInstantly()) {
            return 1.0f;
        }
        return (float)Math.pow((double)l / 400.0, 0.333);
    }

    private float computeFurlFraction(long l) {
        if (this.unfurlFurlInstantly()) {
            return 0.0f;
        }
        float f = 1.0f - (float)l / 250.0f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f;
    }

    private void completeUnfurl() {
        this.fFurlUnfurlTimer.stop();
        if (this.fUnfurledOccupant instanceof DTGroup) {
            ((DTGroup)this.fUnfurledOccupant).setOnTopSingletonsVisible(true);
        }
        this.fIsUnfurling = false;
    }

    private void beginFurl() {
        Object object;
        assert (this.fUnfurledOccupant != null);
        if (this.fIsFurling || this.fFurlUnfurlTimer.isRunning() && !this.fIsUnfurling) {
            return;
        }
        this.fFurlStartTime = System.currentTimeMillis();
        this.fIsFurling = true;
        this.fIsUnfurling = false;
        if (this.fUnfurledOccupant instanceof DTGroup) {
            ((DTGroup)this.fUnfurledOccupant).setOnTopSingletonsVisible(false);
        }
        if (this.fUnfurledOccupant.isSelected()) {
            if (this.fOccupantWaitingToUnfurl == null || this.fFurlUponMouseExit) {
                object = this.fDesktop.getSelectionManager().getPreviousSelectedInFrame(this.fFrame);
                this.fUnfurledOccupant.setSelected(false);
                if (!(object == null || ((DTOccupant)object).getLocation() instanceof DTBorderLocation || ((DTClient)object).getGroup() != null && ((DTClient)object).getGroup().getLocation() instanceof DTBorderLocation)) {
                    ((DTOccupant)object).setSelected(true);
                }
            }
            this.fUnfurledOccupant.setSelected(false);
        }
        if ((object = this.fEdgeOccupantMap.get(this.fUnfurledOccupant)) != null) {
            ((EdgeOccupant)object).iAction.setSelected(false);
        }
        if (this.unfurlFurlInstantly()) {
            this.continueFurl();
        } else if (!this.fFurlUnfurlTimer.isRunning()) {
            this.fFurlUnfurlTimer.start();
        }
    }

    private void continueFurl() {
        assert (this.fUnfurledOccupant != null);
        long l = System.currentTimeMillis();
        long l2 = l - this.fUnfurlStartTime;
        float f = l2 >= 400L ? 1.0f : this.computeUnfurlFraction(l2);
        long l3 = System.currentTimeMillis() - this.fFurlStartTime;
        float f2 = f * this.computeFurlFraction(l3);
        DTLocation dTLocation = this.fUnfurledOccupant.getLocation();
        Rectangle rectangle = this.getUnfurledBounds(this.fCenterContainer.getSize(), dTLocation.getFrameSize(), dTLocation.getEdge(), f2);
        this.fUnfurledPanel.setBounds(rectangle);
        if (f2 == 0.0f) {
            this.fFurlUnfurlTimer.stop();
            this.completeFurl();
            if (this.fOccupantWaitingToUnfurl != null) {
                this.beginUnfurl(this.fOccupantWaitingToUnfurl);
                this.fOccupantWaitingToUnfurl = null;
            }
        }
    }

    private void completeFurl() {
        assert (this.fUnfurledOccupant != null);
        DTOccupant dTOccupant = this.fUnfurledOccupant;
        this.fUnfurledOccupant = null;
        this.fIsFurling = false;
        this.fUnfurledPanel.setVisible(false);
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        this.fUnfurledPanel.remove((Component)((Object)dTInternalFrame));
        dTInternalFrame.removeMouseListener(this.fEdgeListener);
        dTInternalFrame.removeMouseMotionListener(this.fEdgeListener);
        dTOccupant.forwardPropertyChange(new PropertyChangeEvent(dTOccupant, "Occupant In Front", true, false));
        this.revalidate();
        this.repaint();
    }

    private void setWaitingToUnfurl(DTOccupant dTOccupant) {
        EdgeOccupant edgeOccupant;
        if (this.fOccupantWaitingToUnfurl != null && (edgeOccupant = this.fEdgeOccupantMap.get(this.fOccupantWaitingToUnfurl)) != null) {
            edgeOccupant.iAction.setSelected(false);
        }
        this.fOccupantWaitingToUnfurl = dTOccupant;
    }

    private Rectangle getUnfurledBounds(Dimension dimension, Dimension dimension2, int n, float f) {
        Rectangle rectangle = new Rectangle(0, 0, dimension2.width, dimension2.height);
        switch (n) {
            case 1: {
                rectangle.width = dimension.width;
                rectangle.y = (int)((float)rectangle.height * (f - 1.0f));
                break;
            }
            case 5: {
                rectangle.width = dimension.width;
                rectangle.y = (int)((float)dimension.height - f * (float)rectangle.height);
                break;
            }
            case 3: {
                rectangle.height = dimension.height;
                rectangle.x = (int)((float)dimension.width - f * (float)rectangle.width);
                break;
            }
            case 7: {
                rectangle.height = dimension.height;
                rectangle.x = (int)((float)rectangle.width * (f - 1.0f));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid edge = " + n);
            }
        }
        return rectangle;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        EdgeOccupant edgeOccupant;
        DTOccupant dTOccupant = (DTOccupant)propertyChangeEvent.getSource();
        if (dTOccupant == this.fMaximizedOccupant) {
            if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
                this.furlUnfurledOccupant();
            }
        } else if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                if (dTOccupant == this.fUnfurledOccupant) {
                    this.fFurlUponMouseExit = false;
                } else {
                    EdgeOccupant edgeOccupant2 = this.fEdgeOccupantMap.get(dTOccupant);
                    if (edgeOccupant2 != null) {
                        edgeOccupant2.iAction.setSelected(true);
                    }
                    this.initiateUnfurl(dTOccupant);
                }
            } else if (dTOccupant == this.fUnfurledOccupant && dTOccupant instanceof DTClient) {
                DTGroup dTGroup = ((DTClient)dTOccupant).getGroup();
                DTClient dTClient = this.fDesktop.getSelectionManager().getSelectedClient();
                if (dTOccupant == this.fUnfurledOccupant && dTGroup != null && dTGroup.isSelected() && this.fFrame != null && this.fFrame.isActive() && (dTClient == null || dTClient.getGroup() == dTGroup)) {
                    this.furlUnfurledOccupant();
                }
            }
        } else if ((DTClientProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) && (edgeOccupant = this.fEdgeOccupantMap.get(dTOccupant)) != null) {
            edgeOccupant.iAction.setName(dTOccupant.getConstrainedTitle());
        }
    }

    private void configureInternalFrame(DTInternalFrame dTInternalFrame, int n) {
        dTInternalFrame.setTitleBarVisible(true);
        dTInternalFrame.setBorderVisible(true);
        dTInternalFrame.setTitleBarDragAllowed(false);
        if (n != 0) {
            if (!this.fDesktop.condenseTitleActions()) {
                dTInternalFrame.setTitleBarCloseAllowed(false);
            }
            dTInternalFrame.setTitleBarMaximizeAllowed(false);
            dTInternalFrame.getTitleBar().setFurlAction((Action)((Object)new FurlAction(dTInternalFrame.getOccupant(), n)));
        }
    }

    private static void restoreInternalFrame(DTInternalFrame dTInternalFrame) {
        dTInternalFrame.setTitleBarDragAllowed(true);
        dTInternalFrame.setTitleBarCloseAllowed(true);
        dTInternalFrame.setTitleBarMaximizeAllowed(true);
        dTInternalFrame.getTitleBar().setFurlAction(null);
    }

    private DTOccupant[] getEdgeOccupants(int n) {
        DTComponentBar dTComponentBar = this.fEdgeBars[n];
        if (dTComponentBar == null) {
            return new DTOccupant[0];
        }
        DTOccupant[] dTOccupantArray = new DTOccupant[dTComponentBar.getComponentCount()];
        int n2 = 0;
        for (Component component : dTComponentBar) {
            dTOccupantArray[n2++] = ((UnfurlFurlAction)((Object)((DTEdgeButton)((Object)component)).getAction())).iOccupant;
        }
        return dTOccupantArray;
    }

    private boolean isEdgeBarVisible(int n) {
        DTComponentBar dTComponentBar = this.fEdgeBars[n];
        return dTComponentBar != null && dTComponentBar.isVisible();
    }

    private DTComponentBar getEdgeBar(int n) {
        DTComponentBar dTComponentBar = this.fEdgeBars[n];
        if (dTComponentBar == null) {
            this.fEdgeBars[n] = dTComponentBar = new DTComponentBar(n == 1 || n == 5 ? 0 : 1);
            dTComponentBar.setDragOffListener(this);
            dTComponentBar.addMouseMotionListener(new MouseInputAdapter(){});
            if (n == 1) {
                dTComponentBar.setBorder(DTBorderFactory.createTopSeparatorBorder());
            } else if (n == 5) {
                dTComponentBar.setBorder(DTBorderFactory.createBottomSeparatorBorder());
            }
            Object object = DTBorderContainer.getConstraintsForEdge(n);
            Container container = (Container)this.getComponentFromConstraints(object);
            if (container != null) {
                container.add((Component)((Object)dTComponentBar), CENTER_TAG);
            } else {
                this.add((Component)((Object)dTComponentBar), object);
            }
        }
        return dTComponentBar;
    }

    private Component getComponentFromConstraints(Object object) {
        BorderLayout borderLayout = (BorderLayout)this.getLayout();
        return borderLayout.getLayoutComponent(object);
    }

    private void addToEdge(EdgeOccupant edgeOccupant) {
        DTComponentBar dTComponentBar = this.getEdgeBar(edgeOccupant.iEdge);
        dTComponentBar.add((Component)((Object)edgeOccupant.iButton));
        edgeOccupant.iButton.addMouseListener(this.fButtonListener);
        if (dTComponentBar.getParent() instanceof HeavyPanel) {
            dTComponentBar.getParent().setVisible(true);
        }
        dTComponentBar.setVisible(true);
    }

    private void removeFromEdge(EdgeOccupant edgeOccupant) {
        DTComponentBar dTComponentBar = this.getEdgeBar(edgeOccupant.iEdge);
        dTComponentBar.remove((Component)((Object)edgeOccupant.iButton));
        edgeOccupant.iButton.removeMouseListener(this.fButtonListener);
        if (dTComponentBar.getComponentCount() == 0) {
            dTComponentBar.setVisible(false);
            if (dTComponentBar.getParent() instanceof HeavyPanel) {
                dTComponentBar.getParent().setVisible(false);
            }
        } else if (dTComponentBar.getParent() instanceof HeavyPanel) {
            dTComponentBar.invalidate();
            dTComponentBar.validate();
            dTComponentBar.repaint();
        }
    }

    private void move(DTOccupant dTOccupant, int n) {
        int n2 = dTOccupant.getLocation().getEdge();
        if (n != n2) {
            EdgeOccupant edgeOccupant = this.fEdgeOccupantMap.get(dTOccupant);
            if (edgeOccupant == null) {
                return;
            }
            this.removeFromEdge(edgeOccupant);
            edgeOccupant.iButton.setEdge(n);
            edgeOccupant.iEdge = n;
            this.addToEdge(edgeOccupant);
            ((DTBorderLocation)dTOccupant.getLocation()).setEdge(n);
            if (n2 == 1 || n2 == 5) {
                if (n == 3 || n == 7) {
                    int n3 = dTOccupant == this.fUnfurledOccupant ? (int)((float)this.fCenterComponent.getWidth() * 0.333f) : Integer.MIN_VALUE;
                    dTOccupant.getLocation().setFrameSize(n3, Integer.MIN_VALUE);
                }
            } else if (n == 1 || n == 5) {
                int n4 = dTOccupant == this.fUnfurledOccupant ? (int)((float)this.fCenterComponent.getHeight() * 0.5f) : Integer.MIN_VALUE;
                dTOccupant.getLocation().setFrameSize(Integer.MIN_VALUE, n4);
            }
            dTOccupant.locationChanged();
            this.revalidate();
            this.repaint();
            this.fCenterContainer.invalidate();
            this.fCenterContainer.validate();
            this.fCenterContainer.repaint();
        }
    }

    private static Object getConstraintsForEdge(int n) {
        switch (n) {
            case 1: {
                return "North";
            }
            case 5: {
                return "South";
            }
            case 3: {
                return "East";
            }
            case 7: {
                return "West";
            }
        }
        return CENTER_TAG;
    }

    private void layoutCenterContainer() {
        Dimension dimension = this.fCenterContainer.getSize();
        if (this.fCenterComponent != null) {
            this.fCenterComponent.setBounds(0, 0, dimension.width, dimension.height);
        }
        if (this.fMaximizedOccupant != null) {
            this.fMaximizedOccupant.getInternalFrame().setBounds(0, 0, dimension.width, dimension.height);
        }
        if (this.fUnfurledOccupant != null && !this.fFurlUnfurlTimer.isRunning() && !this.fBlockUnfurledLayout) {
            DTLocation dTLocation = this.fUnfurledOccupant.getLocation();
            Rectangle rectangle = this.getUnfurledBounds(dimension, dTLocation.getFrameSize(), dTLocation.getEdge(), 1.0f);
            this.fUnfurledPanel.setBounds(rectangle);
        }
    }

    @Override
    public String getDragHint(DTComponentBar dTComponentBar, Component component) {
        DTEdgeButton dTEdgeButton = (DTEdgeButton)((Object)component);
        UnfurlFurlAction unfurlFurlAction = (UnfurlFurlAction)((Object)dTEdgeButton.getAction());
        DTOccupant dTOccupant = unfurlFurlAction.iOccupant;
        Object[] objectArray = new Object[]{dTOccupant.getShortTitle()};
        return MessageFormat.format(this.fDesktop.getString("status.ToMoveThisOrButton"), objectArray);
    }

    @Override
    public void startDragOff(DTComponentBar dTComponentBar, Component component) {
        if (this.fCenterComponent instanceof DTNestingContainer) {
            DTEdgeButton dTEdgeButton = (DTEdgeButton)((Object)component);
            UnfurlFurlAction unfurlFurlAction = (UnfurlFurlAction)((Object)dTEdgeButton.getAction());
            DTOccupant dTOccupant = unfurlFurlAction.iOccupant;
            ((DTNestingContainer)((Object)this.fCenterComponent)).startDrag(dTOccupant, (Component)((Object)dTEdgeButton));
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        int n3;
        boolean bl = this.isEdgeBarVisible(7);
        int n4 = n3 = bl ? this.getEdgeBar(7).getWidth() : 10;
        if (n <= n3) {
            return DTLocation.createAtEdge(7);
        }
        if (n >= this.getWidth() - (n3 += (bl = this.isEdgeBarVisible(3)) ? this.getEdgeBar(3).getWidth() : 10)) {
            return DTLocation.createAtEdge(3);
        }
        bl = this.isEdgeBarVisible(1);
        int n5 = n3 = bl ? this.getEdgeBar(1).getHeight() : 6;
        if (n2 <= n3) {
            return DTLocation.createAtEdge(1);
        }
        if (n2 >= this.getHeight() - (n3 += (bl = this.isEdgeBarVisible(5)) ? this.getEdgeBar(5).getHeight() : 10)) {
            return DTLocation.createAtEdge(5);
        }
        return null;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        if (dTLocation == null || dTLocation.getEdge() == Integer.MIN_VALUE) {
            return null;
        }
        switch (dTLocation.getEdge()) {
            case 1: {
                return DTDragUtilities.getMinimizeToNorth(object);
            }
            case 5: {
                return DTDragUtilities.getMinimizeToSouth(object);
            }
            case 3: {
                return DTDragUtilities.getMinimizeToEast(object);
            }
            case 7: {
                return DTDragUtilities.getMinimizeToWest(object);
            }
        }
        return null;
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        if (dTLocation == null || dTLocation.getEdge() == Integer.MIN_VALUE) {
            return;
        }
        int n = dTLocation.getEdge();
        DTDropOutlinePainter dTDropOutlinePainter = DTDragUtilities.getDropOutlinePainter();
        if (this.isEdgeBarVisible(n)) {
            DTComponentBar dTComponentBar = this.getEdgeBar(n);
            if (n == 1 || n == 5) {
                dTDropOutlinePainter.show((Component)((Object)dTComponentBar), dTComponentBar.getNextComponentLocation(DTBorderContainer.DROP_OUTLINE_SIZE.width), 1, DTBorderContainer.DROP_OUTLINE_SIZE.width, dTComponentBar.getHeight() - 2, DTDropOutlinePainter.OutlineType.RECTANGLE);
            } else {
                dTDropOutlinePainter.show((Component)((Object)dTComponentBar), 1, dTComponentBar.getNextComponentLocation(DTBorderContainer.DROP_OUTLINE_SIZE.width), dTComponentBar.getWidth() - 2, DTBorderContainer.DROP_OUTLINE_SIZE.width, DTDropOutlinePainter.OutlineType.RECTANGLE);
            }
        } else {
            Rectangle rectangle = null;
            int n2 = this.isEdgeBarVisible(1) ? this.getEdgeBar(1).getHeight() + 3 : 1;
            switch (n) {
                case 1: {
                    rectangle = new Rectangle(1, 1, DTBorderContainer.DROP_OUTLINE_SIZE.width, DTBorderContainer.DROP_OUTLINE_SIZE.height);
                    break;
                }
                case 5: {
                    rectangle = new Rectangle(1, this.getHeight() - DTBorderContainer.DROP_OUTLINE_SIZE.height - 1, DTBorderContainer.DROP_OUTLINE_SIZE.width, DTBorderContainer.DROP_OUTLINE_SIZE.height);
                    break;
                }
                case 3: {
                    rectangle = new Rectangle(this.getWidth() - DTBorderContainer.DROP_OUTLINE_SIZE.height - 1, n2, DTBorderContainer.DROP_OUTLINE_SIZE.height, DTBorderContainer.DROP_OUTLINE_SIZE.width);
                    break;
                }
                case 7: {
                    rectangle = new Rectangle(1, n2, DTBorderContainer.DROP_OUTLINE_SIZE.height, DTBorderContainer.DROP_OUTLINE_SIZE.width);
                }
            }
            if (rectangle != null && this.fCenterComponent != null) {
                rectangle = SwingUtilities.convertRectangle((Component)((Object)this), rectangle, this.fCenterComponent);
                dTDropOutlinePainter.show(this.fCenterComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height, DTDropOutlinePainter.OutlineType.RECTANGLE);
            }
        }
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        if (dTLocation == null || dTLocation.getEdge() == Integer.MIN_VALUE) {
            return;
        }
        if (!(object instanceof DTOccupant)) {
            return;
        }
        DTOccupant dTOccupant = (DTOccupant)object;
        int n = dTLocation.getEdge();
        if (dTOccupant.getLocation() != null && dTOccupant.getLocation().isMinimized()) {
            this.move(dTOccupant, n);
        } else {
            this.fDesktop.setOccupantMinimized(dTOccupant, true, n);
        }
    }

    Object getState() {
        return new State(this);
    }

    void restoreState(Object object) {
        ((State)object).restore(this);
    }

    static Element stateToXML(Object object, Document document) {
        return ((State)object).toXML(document);
    }

    static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new State(simpleElement);
    }

    static /* synthetic */ int access$2000() {
        return MAX_EDGE_VALUE;
    }

    private static class ViewState
    extends OccupantState {
        ViewState(DTClient dTClient) {
            super(dTClient, DTBorderContainer.VIEW_TAG);
        }

        ViewState(SimpleElement simpleElement) {
            super(simpleElement);
        }

        @Override
        DTOccupant getOccupant(DTBorderContainer dTBorderContainer, boolean bl) {
            String string;
            Desktop desktop = dTBorderContainer.fDesktop;
            DTClient dTClient = desktop.getSingleton(this.fName, string = dTBorderContainer.fGroup == null ? null : dTBorderContainer.fGroup.getName());
            if (dTClient == null) {
                if (!desktop.hadClient(this.fName, string)) {
                    Object[] objectArray = new Object[]{this.fName};
                    String string2 = MessageFormat.format(dTBorderContainer.fDesktop.getString("error.ClassNotSpecified"), objectArray);
                    desktop.getErrorReportingStream().println(string2);
                }
                return null;
            }
            if (!bl) {
                dTClient.createSurrogateComponent();
            } else {
                dTClient.prepareToShow();
            }
            return dTClient;
        }
    }

    private static class DocumentsState
    extends OccupantState {
        DocumentsState(DTDocuments dTDocuments) {
            super(dTDocuments, DTBorderContainer.DOCUMENTS_TAG);
        }

        DocumentsState(SimpleElement simpleElement) {
            super(simpleElement);
        }

        @Override
        Element toXML(Document document) {
            return document.createElement(DTBorderContainer.DOCUMENTS_TAG);
        }

        @Override
        DTOccupant getOccupant(DTBorderContainer dTBorderContainer, boolean bl) {
            return dTBorderContainer.fFrame.getSharedDocuments();
        }
    }

    private static class GroupState
    extends OccupantState {
        GroupState(DTGroup dTGroup) {
            super(dTGroup, DTBorderContainer.GROUP_TAG);
        }

        GroupState(SimpleElement simpleElement) {
            super(simpleElement);
        }

        @Override
        DTOccupant getOccupant(DTBorderContainer dTBorderContainer, boolean bl) {
            Desktop desktop = dTBorderContainer.fDesktop;
            return desktop.getGroup(this.fName);
        }
    }

    private static abstract class OccupantState {
        String fTag;
        String fName;
        String fTitle;

        OccupantState() {
        }

        OccupantState(DTOccupant dTOccupant, String string) {
            this.fTag = string;
            this.fName = dTOccupant.getName();
            this.fTitle = dTOccupant.getShortTitle();
        }

        OccupantState(SimpleElement simpleElement) {
            this.fTag = simpleElement.getTagName();
            if (simpleElement.hasAttribute(DTBorderContainer.TITLE_ATTRIBUTE)) {
                this.fTitle = simpleElement.getAttribute(DTBorderContainer.TITLE_ATTRIBUTE);
            }
            this.fName = simpleElement.hasAttribute(DTBorderContainer.NAME_ATTRIBUTE) ? simpleElement.getAttribute(DTBorderContainer.NAME_ATTRIBUTE) : this.fTitle;
        }

        Element toXML(Document document) {
            Element element = document.createElement(this.fTag);
            element.setAttribute(DTBorderContainer.NAME_ATTRIBUTE, this.fName);
            element.setAttribute(DTBorderContainer.TITLE_ATTRIBUTE, this.fTitle);
            return element;
        }

        abstract DTOccupant getOccupant(DTBorderContainer var1, boolean var2);

        static OccupantState create(DTOccupant dTOccupant) {
            if (dTOccupant instanceof DTGroup) {
                return new GroupState((DTGroup)dTOccupant);
            }
            if (dTOccupant instanceof DTDocuments) {
                return new DocumentsState((DTDocuments)dTOccupant);
            }
            if (dTOccupant instanceof DTClient) {
                return new ViewState((DTClient)dTOccupant);
            }
            return null;
        }

        private static OccupantState create(SimpleElement simpleElement) throws DataFormatException {
            if (simpleElement == null) {
                return null;
            }
            String string = simpleElement.getTagName();
            if (string.equals(DTBorderContainer.GROUP_TAG)) {
                return new GroupState(simpleElement);
            }
            if (string.equals(DTBorderContainer.DOCUMENTS_TAG)) {
                return new DocumentsState(simpleElement);
            }
            if (string.equals(DTBorderContainer.VIEW_TAG)) {
                return new ViewState(simpleElement);
            }
            return null;
        }
    }

    private static class State {
        OccupantState[][] iEdgeOccupants = new OccupantState[DTBorderContainer.access$2000() + 1][];
        OccupantState iCenterOccupant;

        State(DTBorderContainer dTBorderContainer) {
            for (int n : EDGES) {
                DTOccupant[] dTOccupantArray = dTBorderContainer.getEdgeOccupants(n);
                this.iEdgeOccupants[n] = new OccupantState[dTOccupantArray.length];
                for (int i = 0; i < dTOccupantArray.length; ++i) {
                    this.iEdgeOccupants[n][i] = OccupantState.create(dTOccupantArray[i]);
                }
            }
            if (dTBorderContainer.fMaximizedOccupant != null) {
                this.iCenterOccupant = OccupantState.create(dTBorderContainer.fMaximizedOccupant);
            }
        }

        State(SimpleElement simpleElement) throws DataFormatException {
            assert (DTBorderContainer.BORDERS_TAG.equals(simpleElement.getTagName()));
            SimpleNodeList simpleNodeList = simpleElement.getChildElements();
            for (int i = 0; i < simpleNodeList.getLength(); ++i) {
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
                String string = simpleElement2.getNodeName();
                for (int j = 0; j < EDGE_TAG.length; ++j) {
                    if (!EDGE_TAG[j].equals(string)) continue;
                    int n = EDGES[j];
                    SimpleNodeList simpleNodeList2 = simpleElement2.getChildElements();
                    this.iEdgeOccupants[n] = new OccupantState[simpleNodeList2.getLength()];
                    for (int k = 0; k < simpleNodeList2.getLength(); ++k) {
                        SimpleElement simpleElement3 = (SimpleElement)simpleNodeList2.item(k);
                        this.iEdgeOccupants[n][k] = OccupantState.create(simpleElement3);
                    }
                    break;
                }
                if (!DTBorderContainer.CENTER_TAG.equals(string)) continue;
                SimpleElement simpleElement4 = (SimpleElement)simpleElement2.getFirstChild();
                this.iCenterOccupant = OccupantState.create(simpleElement4);
            }
        }

        public Element toXML(Document document) {
            boolean bl = true;
            Element element = document.createElement(DTBorderContainer.BORDERS_TAG);
            for (int i = 0; i < EDGES.length; ++i) {
                int n = EDGES[i];
                if (this.iEdgeOccupants[n] == null || this.iEdgeOccupants[n].length <= 0) continue;
                Element element2 = document.createElement(EDGE_TAG[i]);
                for (int j = 0; j < this.iEdgeOccupants[n].length; ++j) {
                    Element element3 = this.iEdgeOccupants[n][j].toXML(document);
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
                bl = false;
            }
            if (this.iCenterOccupant != null) {
                Element element4 = document.createElement(DTBorderContainer.CENTER_TAG);
                Element element5 = this.iCenterOccupant.toXML(document);
                element4.appendChild(element5);
                element.appendChild(element4);
                bl = false;
            }
            return bl ? null : element;
        }

        void restore(DTBorderContainer dTBorderContainer) {
            for (int n : EDGES) {
                if (this.iEdgeOccupants[n] == null) continue;
                for (int i = 0; i < this.iEdgeOccupants[n].length; ++i) {
                    DTOccupant dTOccupant = this.iEdgeOccupants[n][i].getOccupant(dTBorderContainer, false);
                    if (dTOccupant == null) continue;
                    DTLocation dTLocation = dTOccupant.getLastDockedLocation();
                    if (!(dTLocation instanceof DTBorderLocation)) {
                        dTLocation = new DTBorderLocation(n);
                    }
                    if (dTOccupant instanceof DTClient) {
                        dTBorderContainer.fFrame.addClient((DTClient)dTOccupant, dTLocation);
                        continue;
                    }
                    if (dTOccupant instanceof DTGroup) {
                        dTBorderContainer.fFrame.addGroup((DTGroup)dTOccupant, dTLocation);
                        continue;
                    }
                    if (!(dTOccupant instanceof DTDocuments)) continue;
                    dTBorderContainer.fFrame.addDocuments((DTDocuments)dTOccupant, dTLocation);
                }
            }
            if (this.iCenterOccupant != null) {
                DTOccupant dTOccupant = this.iCenterOccupant.getOccupant(dTBorderContainer, true);
                if (dTOccupant instanceof DTClient) {
                    dTBorderContainer.fDesktop.setClientShowing((DTClient)dTOccupant, true, new DTBorderLocation(0), false);
                } else if (dTOccupant instanceof DTGroup) {
                    dTBorderContainer.fFrame.addGroup((DTGroup)dTOccupant, new DTBorderLocation(0));
                } else if (dTOccupant instanceof DTDocuments) {
                    dTBorderContainer.fFrame.addDocuments((DTDocuments)dTOccupant, new DTBorderLocation(0));
                }
            }
        }
    }

    private class KeyControlledResizer
    extends DTKeyControlledResizer {
        private KeyControlledResizer() {
        }

        @Override
        protected Point getDragStartPoint() {
            assert (this.fInvoker == DTBorderContainer.this.fUnfurledOccupant.getInternalFrame());
            Insets insets = DTBorderContainer.this.fUnfurledOccupant.getInternalFrame().getInsets();
            Point point = new Point(DTBorderContainer.this.getWidth() / 2, DTBorderContainer.this.getHeight() / 2);
            int n = DTBorderContainer.this.fUnfurledOccupant.getLocation().getEdge();
            switch (n) {
                case 1: {
                    point.y = this.fInvoker.getHeight() - insets.bottom / 2;
                    break;
                }
                case 5: {
                    point.y = insets.top / 2;
                    break;
                }
                case 3: {
                    point.x = insets.left / 2;
                    break;
                }
                case 7: {
                    point.x = this.fInvoker.getWidth() - insets.right / 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid edge = " + n);
                }
            }
            SwingUtilities.convertPointToScreen(point, this.fInvoker);
            return point;
        }

        @Override
        public void activate(DTOccupant dTOccupant, Container container) {
            DTBorderContainer.this.fBlockUnfurledLayout = true;
            super.activate(dTOccupant, container);
        }

        @Override
        public void deactivate(boolean bl) {
            super.deactivate(bl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTBorderContainer.this.fBlockUnfurledLayout = false;
                }
            });
        }
    }

    private class EdgeResizer
    extends DTComponentResizer {
        private EdgeResizer() {
        }

        @Override
        protected Component getComponentToResize() {
            return DTBorderContainer.this.fUnfurledPanel;
        }

        @Override
        protected Insets getResizeInsets() {
            if (DTBorderContainer.this.fUnfurledOccupant == null) {
                return new Insets(0, 0, 0, 0);
            }
            Insets insets = DTBorderContainer.this.fUnfurledOccupant.getInternalFrame().getInsets();
            switch (DTBorderContainer.this.fUnfurledOccupant.getLocation().getEdge()) {
                case 1: {
                    insets.right = 0;
                    insets.left = 0;
                    insets.top = 0;
                    break;
                }
                case 5: {
                    insets.right = 0;
                    insets.left = 0;
                    insets.bottom = 0;
                    break;
                }
                case 3: {
                    insets.right = 0;
                    insets.bottom = 0;
                    insets.top = 0;
                    break;
                }
                case 7: {
                    insets.left = 0;
                    insets.bottom = 0;
                    insets.top = 0;
                }
            }
            return insets;
        }

        @Override
        int getCursorType(Point point) {
            int n = super.getCursorType(point);
            if (DTBorderContainer.this.fUnfurledOccupant != null && n != 0) {
                switch (DTBorderContainer.this.fUnfurledOccupant.getLocation().getEdge()) {
                    case 1: {
                        n = 9;
                        break;
                    }
                    case 5: {
                        n = 8;
                        break;
                    }
                    case 3: {
                        n = 10;
                        break;
                    }
                    case 7: {
                        n = 11;
                    }
                }
            }
            return n;
        }

        @Override
        protected Dimension getMinimumSize() {
            return DTBorderContainer.this.fUnfurledOccupant == null ? new Dimension(0, 0) : DTBorderContainer.this.fUnfurledOccupant.getInternalFrame().getMinimumSize();
        }

        @Override
        protected Dimension getMaximumSize() {
            return DTBorderContainer.this.fCenterContainer.getSize();
        }
    }

    private class UnfurledComponentListener
    extends ComponentAdapter {
        private UnfurledComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (DTBorderContainer.this.fUnfurledOccupant != null && DTBorderContainer.this.fUnfurledOccupant.getLocation() != null && DTBorderContainer.this.fUnfurledPanel.getWidth() > 0 && DTBorderContainer.this.fUnfurledPanel.getHeight() > 0) {
                DTBorderContainer.this.fUnfurledOccupant.getLocation().setFrameSize(DTBorderContainer.this.fUnfurledPanel.getWidth(), DTBorderContainer.this.fUnfurledPanel.getHeight());
                DTBorderContainer.this.fUnfurledOccupant.locationChanged();
            }
        }
    }

    private class MouseExitListener
    implements AWTEventListener {
        private MouseExitListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (DTBorderContainer.this.fUnfurledOccupant == null || !DTBorderContainer.this.fFurlUponMouseExit || DTBorderContainer.this.fUnfurledOccupant.isSelected() || aWTEvent.getID() != 503) {
                return;
            }
            Component component = (Component)aWTEvent.getSource();
            int n = DTBorderContainer.this.fUnfurledOccupant.getLocation().getEdge();
            DTComponentBar dTComponentBar = DTBorderContainer.this.fEdgeBars[n];
            if (component == dTComponentBar || SwingUtilities.isDescendingFrom(component, (Component)((Object)dTComponentBar))) {
                return;
            }
            if (component == DTBorderContainer.this.fUnfurledPanel || SwingUtilities.isDescendingFrom(component, DTBorderContainer.this.fUnfurledPanel)) {
                return;
            }
            if (component instanceof JPopupMenu || component instanceof JMenuItem) {
                return;
            }
            if (DTBorderContainer.this.fUnfurledPanel.getBounds().contains(SwingUtilities.convertPoint(component, ((MouseEvent)aWTEvent).getPoint(), DTBorderContainer.this.fCenterContainer))) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null && menuElementArray.length > 0) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            DTBorderContainer.this.furlUnfurledOccupant();
        }
    }

    private class ButtonListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        Timer iTimer = new Timer(750, this);
        DTOccupant iCandidate;
        boolean iIsPopupShowing;
        DTOccupant iMenuOccupant;

        ButtonListener() {
            this.iTimer.setRepeats(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.iIsPopupShowing) {
                return;
            }
            if (!DTBorderContainer.this.fFrame.isActive()) {
                return;
            }
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x400) != 0 || (n & 0x800) != 0) {
                return;
            }
            DTOccupant dTOccupant = this.getOccupantFromEvent(mouseEvent);
            if (this.iCandidate == null && dTOccupant != null) {
                this.iCandidate = dTOccupant;
                this.iTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.iTimer.isRunning()) {
                this.iTimer.stop();
            }
            this.iCandidate = null;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.iTimer.isRunning()) {
                this.iTimer.stop();
            }
            this.iCandidate = null;
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                if (this.iTimer.isRunning()) {
                    this.iTimer.stop();
                }
                this.iCandidate = null;
                DTOccupant dTOccupant = this.getOccupantFromEvent(mouseEvent);
                if (dTOccupant != null) {
                    DTBorderContainer.this.fDesktop.setOccupantMinimized(dTOccupant, false, 0);
                    if (dTOccupant instanceof DTClient) {
                        DTBorderContainer.this.fDesktop.setClientSelected((DTClient)dTOccupant, true);
                    } else if (dTOccupant instanceof DTGroup) {
                        ((DTGroup)dTOccupant).select();
                    }
                }
            }
        }

        private DTOccupant getOccupantFromEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() instanceof DTEdgeButton) {
                return ((UnfurlFurlAction)((Object)((DTEdgeButton)((Object)mouseEvent.getComponent())).getAction())).iOccupant;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iCandidate != null && this.iCandidate != DTBorderContainer.this.fUnfurledOccupant && this.iCandidate.getLocation() instanceof DTBorderLocation) {
                DTBorderContainer.this.fFurlUponMouseExit = true;
                EdgeOccupant edgeOccupant = (EdgeOccupant)DTBorderContainer.this.fEdgeOccupantMap.get(this.iCandidate);
                if (edgeOccupant != null) {
                    edgeOccupant.iAction.setSelected(true);
                }
                DTBorderContainer.this.initiateUnfurl(this.iCandidate);
                this.iCandidate = null;
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            this.iMenuOccupant = this.getOccupantFromEvent(mouseEvent);
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.addPopupMenuListener((PopupMenuListener)this);
            this.iIsPopupShowing = true;
            mJPopupMenu.setCleanupUponClose(true);
            mJPopupMenu.add((Action)this.iMenuOccupant.getMinimizeAction());
            if (this.iMenuOccupant.permitUserUndock()) {
                mJPopupMenu.add((Action)this.iMenuOccupant.getUndockAction());
            }
            if (this.iMenuOccupant.permitUserClose()) {
                mJPopupMenu.add((Action)this.iMenuOccupant.getCloseAction());
            }
            mJPopupMenu.addSeparator();
            mJPopupMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)((Object)new MoveButtonAction(this.iMenuOccupant, 1))));
            mJPopupMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)((Object)new MoveButtonAction(this.iMenuOccupant, 5))));
            mJPopupMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)((Object)new MoveButtonAction(this.iMenuOccupant, 7))));
            mJPopupMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)((Object)new MoveButtonAction(this.iMenuOccupant, 3))));
            mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.iIsPopupShowing = false;
            EdgeOccupant edgeOccupant = (EdgeOccupant)DTBorderContainer.this.fEdgeOccupantMap.get(this.iMenuOccupant);
            edgeOccupant.iButton.repaint();
            this.iMenuOccupant = null;
            ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        }
    }

    private class MoveButtonAction
    extends MJAbstractAction {
        DTOccupant iOccupant;
        int iToEdge;

        MoveButtonAction(DTOccupant dTOccupant, int n) {
            this.iOccupant = dTOccupant;
            this.iToEdge = n;
            String string = null;
            switch (n) {
                case 1: {
                    string = "action.MoveToTopEdge";
                    break;
                }
                case 5: {
                    string = "action.MoveToBottomEdge";
                    break;
                }
                case 3: {
                    string = "action.MoveToRightEdge";
                    break;
                }
                case 7: {
                    string = "action.MoveToLeftEdge";
                }
            }
            this.setName(DTBorderContainer.this.fDesktop.getString(string));
            this.setSelected(n == dTOccupant.getLocation().getEdge());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTBorderContainer.this.move(this.iOccupant, this.iToEdge);
        }
    }

    private class FurlAction
    extends MJAbstractAction {
        FurlAction(DTOccupant dTOccupant, int n) {
            Object[] objectArray = new Object[]{dTOccupant.getConstrainedTitle()};
            this.setName(MessageFormat.format(DTBorderContainer.this.fDesktop.getString("menuitem.MinimizeThis"), objectArray));
            this.setComponentName("Furl" + dTOccupant.getName());
            Icon icon = null;
            switch (n) {
                case 1: {
                    icon = Desktop.MINIMIZE_TO_NORTH_ICON;
                    break;
                }
                case 5: {
                    icon = Desktop.MINIMIZE_TO_SOUTH_ICON;
                    break;
                }
                case 3: {
                    icon = Desktop.MINIMIZE_TO_EAST_ICON;
                    break;
                }
                case 7: {
                    icon = Desktop.MINIMIZE_TO_WEST_ICON;
                }
            }
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTBorderContainer.this.furlUnfurledOccupant();
        }
    }

    private class UnfurlFurlAction
    extends MJAbstractAction {
        private DTOccupant iOccupant;

        public UnfurlFurlAction(DTOccupant dTOccupant) {
            super(dTOccupant.getConstrainedTitle());
            this.setComponentName("UnfurlFurl" + dTOccupant.getName());
            this.setTip(null);
            this.iOccupant = dTOccupant;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                DTBorderContainer.this.fFurlUponMouseExit = false;
                if (DTBorderContainer.this.fUnfurledOccupant != this.iOccupant) {
                    this.iOccupant.setSelected(true);
                }
            } else if (this.iOccupant == DTBorderContainer.this.fUnfurledOccupant) {
                if (!this.iOccupant.isSelected()) {
                    DTBorderContainer.this.fFurlUponMouseExit = false;
                    this.iOccupant.setSelected(true);
                    this.setSelected(true);
                } else {
                    DTBorderContainer.this.furlUnfurledOccupant();
                }
            }
        }
    }

    private class LightCenterContainer
    extends MJPanel {
        LightCenterContainer() {
            this.setLayout(null);
        }

        public void doLayout() {
            DTBorderContainer.this.layoutCenterContainer();
        }
    }

    private class HeavyCenterContainer
    extends Panel {
        HeavyCenterContainer() {
            this.setFocusable(false);
            this.setLayout(null);
        }

        @Override
        public void doLayout() {
            DTBorderContainer.this.layoutCenterContainer();
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    private static class HeavyPanel
    extends Panel {
        HeavyPanel() {
            this.setFocusable(false);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    private class EdgeOccupant {
        DTOccupant iOccupant;
        int iEdge;
        UnfurlFurlAction iAction;
        DTEdgeButton iButton;

        EdgeOccupant(DTOccupant dTOccupant, int n) {
            this.iOccupant = dTOccupant;
            this.iEdge = n;
            this.iAction = new UnfurlFurlAction(dTOccupant);
            this.iButton = new DTEdgeButton(n, (Action)((Object)this.iAction));
        }
    }
}

