/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.Serializable;

class DTExternalTarget
implements DTDropTarget {
    private Desktop fDesktop;
    private int fWidth;
    private int fHeight;
    private static final int TITLE_HEIGHT = 20;
    private static final int MENU_HEIGHT = 22;
    private static final int STATUS_HEIGHT = 21;
    private static final int BORDER_THICKNESS = 6;

    DTExternalTarget(Desktop desktop, DTClient dTClient) {
        this(desktop, dTClient.getInternalFrame(), dTClient.getLocation(), dTClient.getLastUndockedLocation());
    }

    DTExternalTarget(Desktop desktop, DTGroup dTGroup) {
        this(desktop, dTGroup.getDocumentContainer(), dTGroup.getLocation(), dTGroup.getLastUndockedLocation());
    }

    DTExternalTarget(Desktop desktop, DTContainer dTContainer, DTLocation dTLocation, DTFloatingLocation dTFloatingLocation) {
        Serializable serializable;
        this.fDesktop = desktop;
        if (dTFloatingLocation != null) {
            this.fWidth = dTFloatingLocation.getFrameWidth();
            this.fHeight = dTFloatingLocation.getFrameHeight();
        } else if (dTLocation != null && ((Component)(serializable = (Component)((Object)dTContainer))).getParent() != null && ((Component)serializable).isVisible()) {
            this.fWidth = ((Component)serializable).getWidth() + 6;
            this.fHeight = ((Component)serializable).getHeight() + 22 + 21 + 6;
            if (serializable instanceof DTInternalFrame && !((DTInternalFrame)((Object)serializable)).isTitleBarVisible()) {
                this.fHeight += 20;
            }
        }
        if (this.fWidth <= 0 || this.fHeight <= 0) {
            serializable = Toolkit.getDefaultToolkit().getScreenSize();
            this.fWidth = ((Dimension)serializable).width >> 2;
            this.fHeight = ((Dimension)serializable).height >> 2;
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        DTFloatingLocation dTFloatingLocation = dTLocation instanceof DTFloatingLocation && dTLocation.isExternal() ? (DTFloatingLocation)dTLocation : new DTFloatingLocation(true);
        dTFloatingLocation.setFrameBounds(n - (this.fWidth >> 1), n2 + 10, this.fWidth, this.fHeight);
        return dTFloatingLocation;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        return DTDragUtilities.getToOutsideHint(object);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTLocation;
        DTDragUtilities.getDropOutlinePainter().show(null, dTFloatingLocation.getFrameX(), dTFloatingLocation.getFrameY(), dTFloatingLocation.getFrameWidth(), dTFloatingLocation.getFrameHeight(), DTDropOutlinePainter.OutlineType.RECTANGLE);
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        DTGroup dTGroup;
        if (object instanceof DTClient) {
            this.fDesktop.setClientLocation((DTClient)object, dTLocation);
        } else if (object instanceof DTGroup) {
            this.fDesktop.setGroupLocation((DTGroup)object, dTLocation);
        } else if (object instanceof DTDocumentContainer && (dTGroup = ((DTDocumentContainer)object).getGroup()) != null) {
            this.fDesktop.setGroupLocation(dTGroup, dTLocation);
        }
    }
}

