/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTMenuContributor;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTToolBarContainer
extends MJLayeredPane {
    private List<ToolBarData> fToolBars = new ArrayList<ToolBarData>();
    private final List<ToggleAction> fToggleActions = new ArrayList<ToggleAction>();
    private final ToolBarData fTargetData = new ToolBarData();
    private List<Listener> fListeners;
    private List<JComponent> fLeftCorners = new ArrayList<JComponent>();
    private List<JComponent> fRightCorners = new ArrayList<JComponent>();
    private boolean fOfferToggles = true;
    private boolean fAllowRearrangement = true;
    private ContextListener fContextListener = new ContextListener();
    private DragHandler fDragHandler = new DragHandler();
    private JComponent fAlternativeComponent;
    private JComponent fControlsBox;
    private static ToolBarData sRowBreakData = new ToolBarData();
    static final String TOOLBARS_TAG = "ToolBars";
    private static final String TOOLBAR_TAG = "ToolBar";
    private static final String ROW_BREAK_TAG = "RowBreak";
    private static final String KEY_ATTRIBUTE = "Name";
    private static final String LABEL_ATTRIBUTE = "Label";
    private static final String LABEL_RESOURCE_ATTRIBUTE = "LabelResource";
    private static final String SHOWING_ATTRIBUTE = "Showing";
    private static final String WIDTH_ATTRIBUTE = "Width";
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    private static final String ROW_BREAK_KEY = "RowBreak";

    public DTToolBarContainer() {
        this.setName("ToolBarContainer");
        this.setLayout(null);
        this.setBorder(DTBorderFactory.createToolBarContainerBorder());
        this.addMouseListener(this.fContextListener);
    }

    public void addToolBar(JComponent jComponent, String string, String string2, boolean bl) {
        jComponent.setBorder(DTBorderFactory.createToolBarBorder());
        if (jComponent instanceof JToolBar) {
            ((JToolBar)jComponent).setFloatable(false);
        }
        this.add(jComponent);
        if (this.fOfferToggles) {
            this.fContextListener.addTo(jComponent);
        }
        jComponent.addMouseListener(this.fDragHandler);
        jComponent.addMouseMotionListener(this.fDragHandler);
        if (!this.fToolBars.isEmpty() && this.fToolBars.get(this.fToolBars.size() - 1) != sRowBreakData && !bl) {
            this.fToolBars.add(sRowBreakData);
        }
        ToolBarData toolBarData = new ToolBarData(jComponent, string, string2);
        this.fToolBars.add(toolBarData);
        toolBarData.fToggleAction = new ToggleAction(toolBarData);
        this.fToggleActions.add(toolBarData.fToggleAction);
        this.updateBorders();
        for (ToolBarData toolBarData2 : this.fToolBars) {
            if (toolBarData2.fToolBar == null) continue;
            toolBarData2.fToolBar.revalidate();
            toolBarData2.fToolBar.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    private static boolean shouldAppendToolbar(JComponent jComponent) {
        Boolean bl = (Boolean)jComponent.getClientProperty("ToolBarAppend");
        return bl != null ? bl : false;
    }

    public void addToolBar(JComponent jComponent, String string, String string2) {
        this.addToolBar(jComponent, string, string2, DTToolBarContainer.shouldAppendToolbar(jComponent));
    }

    public void addToolBar(Component component, String string) {
        this.addToolBar((JComponent)component, null, string);
    }

    public void removeToolBar(String string, String string2) {
        this.fTargetData.fKey = string;
        this.fTargetData.fLabel = string2;
        int n = this.fToolBars.indexOf(this.fTargetData);
        if (n != -1) {
            ToolBarData toolBarData = this.fToolBars.remove(n);
            this.fToggleActions.remove((Object)toolBarData.fToggleAction);
            this.remove(toolBarData.fToolBar);
            this.fContextListener.removeFrom(toolBarData.fToolBar);
            toolBarData.fToolBar.removeMouseListener(this.fDragHandler);
            toolBarData.fToolBar.removeMouseMotionListener(this.fDragHandler);
            toolBarData.fToolBar.setBorder(null);
            if (!this.fToolBars.isEmpty() && this.fToolBars.get(0) == sRowBreakData) {
                this.fToolBars.remove(0);
            }
            this.updateBorders();
            this.revalidate();
            this.repaint();
        }
    }

    public void removeAllToolBars() {
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData.fToolBar == null) continue;
            this.remove(toolBarData.fToolBar);
            this.fContextListener.removeFrom(toolBarData.fToolBar);
            toolBarData.fToolBar.removeMouseListener(this.fDragHandler);
            toolBarData.fToolBar.removeMouseMotionListener(this.fDragHandler);
        }
        this.fToolBars.clear();
        this.fToggleActions.clear();
        this.revalidate();
        this.repaint();
    }

    public void setToolBarAlternative(JComponent jComponent) {
        if (this.fAlternativeComponent != null) {
            this.remove(this.fAlternativeComponent);
            this.fAlternativeComponent.putClientProperty("DesktopControls", null);
            if (DTToolBarContainer.handlesControlsLayout(this.fAlternativeComponent) && !DTToolBarContainer.handlesControlsLayout(jComponent)) {
                for (JComponent jComponent2 : this.fRightCorners) {
                    this.fControlsBox.remove(jComponent2);
                    this.add(jComponent2);
                }
                for (JComponent jComponent2 : this.fLeftCorners) {
                    this.fControlsBox.remove(jComponent2);
                    this.add(jComponent2);
                }
                this.fControlsBox = null;
            }
        }
        if (jComponent != null) {
            this.add(jComponent);
            if (DTToolBarContainer.handlesControlsLayout(jComponent) && !DTToolBarContainer.handlesControlsLayout(this.fAlternativeComponent)) {
                this.fControlsBox = Box.createHorizontalBox();
                for (JComponent jComponent2 : this.fRightCorners) {
                    this.remove(jComponent2);
                    this.fControlsBox.add(jComponent2);
                }
                for (JComponent jComponent2 : this.fLeftCorners) {
                    this.remove(jComponent2);
                    this.fControlsBox.add(jComponent2);
                }
            }
            jComponent.putClientProperty("DesktopControls", this.fControlsBox);
        }
        this.fAlternativeComponent = jComponent;
        this.revalidate();
        this.repaint();
    }

    private static boolean handlesControlsLayout(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        Boolean bl = (Boolean)jComponent.getClientProperty("HandlesDesktopControls");
        return bl != null && bl != false;
    }

    public boolean hasToolBarAlternative() {
        return this.fAlternativeComponent != null;
    }

    public int getToolBarCount() {
        int n = this.getComponentCount();
        n -= this.fLeftCorners.size();
        return n -= this.fRightCorners.size();
    }

    List<JComponent> getToolBars() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.fToolBars.size());
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData.fToolBar == null) continue;
            arrayList.add(toolBarData.fToolBar);
        }
        return arrayList;
    }

    boolean isAnyToolBarVisible() {
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData.fToolBar == null || !toolBarData.fToolBar.isVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isAnyToolBarCustomizable() {
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData.fToolBar == null || toolBarData.fKey == null) continue;
            return true;
        }
        return false;
    }

    void addRightCorner(JComponent jComponent) {
        this.addRightCorner(jComponent, this.fRightCorners.size());
    }

    void addRightCorner(JComponent jComponent, int n) {
        this.fRightCorners.add(n, jComponent);
        if (this.fControlsBox != null) {
            this.fControlsBox.add(jComponent);
        } else {
            this.add(jComponent);
            if (this.fAlternativeComponent != null) {
                this.setComponentZOrder(jComponent, 0);
            }
        }
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    void addLeftCorner(JComponent jComponent) {
        this.fLeftCorners.add(jComponent);
        if (this.fControlsBox != null) {
            this.fControlsBox.add(jComponent);
        } else {
            this.add(jComponent);
            if (this.fAlternativeComponent != null) {
                this.setComponentZOrder(jComponent, 0);
            }
        }
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    void removeRightCorner(JComponent jComponent) {
        this.fRightCorners.remove(jComponent);
        if (this.fControlsBox != null) {
            this.fControlsBox.remove(jComponent);
        } else {
            this.remove(jComponent);
        }
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    void removeLeftCorner(JComponent jComponent) {
        this.fLeftCorners.remove(jComponent);
        if (this.fControlsBox != null) {
            this.fControlsBox.remove(jComponent);
        } else {
            this.remove(jComponent);
        }
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    public void setToolBarVisible(String string, String string2, boolean bl) {
        this.fTargetData.fKey = string;
        this.fTargetData.fLabel = string2;
        int n = this.fToolBars.indexOf(this.fTargetData);
        if (n != -1) {
            this.setToolBarVisible(this.fToolBars.get(n), bl);
        }
    }

    private void setToolBarVisible(ToolBarData toolBarData, boolean bl) {
        toolBarData.fToolBar.setVisible(bl);
        if (toolBarData.fToggleAction != null) {
            toolBarData.fToggleAction.setSelected(bl);
        }
        this.fireStateChange();
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    void setOfferToggles(boolean bl) {
        this.fOfferToggles = bl;
    }

    boolean offerToggles() {
        return this.fOfferToggles;
    }

    void setAllowRearrangement(boolean bl) {
        this.fAllowRearrangement = bl;
    }

    boolean allowRearrangement() {
        return this.fAllowRearrangement;
    }

    void refreshAll() {
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    public void addListener(Listener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<Listener>();
        }
        this.fListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
        }
    }

    private void updateBorders() {
        int n = 0;
        int n2 = 0;
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData == sRowBreakData) {
                if (n <= 0) continue;
                ++n2;
                continue;
            }
            if (!toolBarData.fToolBar.isVisible()) continue;
            ++n;
            DTBorderFactory.BasicToolBarBorder.setWantSeparator(toolBarData.fToolBar, n2 > 0);
            DTBorderFactory.BasicToolBarBorder.setWantGrip(toolBarData.fToolBar, this.allowRearrangement());
        }
        if (n == 1) {
            for (ToolBarData toolBarData : this.fToolBars) {
                if (toolBarData.fToolBar == null || !toolBarData.fToolBar.isVisible()) continue;
                DTBorderFactory.BasicToolBarBorder.setWantGrip(toolBarData.fToolBar, false);
                break;
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.fAlternativeComponent != null) {
            return this.fAlternativeComponent.getPreferredSize();
        }
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = this.getPreferredCornerHeight();
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData == sRowBreakData) {
                if (n <= 0) continue;
                dimension.height += n2;
                n2 = 0;
                continue;
            }
            if (!toolBarData.fToolBar.isVisible()) continue;
            ++n;
            int n3 = toolBarData.fToolBar.getPreferredSize().height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (n > 0) {
            dimension.height += n2;
        }
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private int getPreferredCornerHeight() {
        int n;
        int n2 = 0;
        for (JComponent jComponent : this.fLeftCorners) {
            n = jComponent.getPreferredSize().height;
            if (n <= n2) continue;
            n2 = n;
        }
        for (JComponent jComponent : this.fRightCorners) {
            n = jComponent.getPreferredSize().height;
            if (n <= n2) continue;
            n2 = n;
        }
        return n2;
    }

    private static int getPreferredCornerWidth(List<JComponent> list) {
        int n = 0;
        for (JComponent jComponent : list) {
            if (!jComponent.isVisible()) continue;
            n += jComponent.getPreferredSize().width;
        }
        return n;
    }

    private static int getMinimumCornerWidth(List<JComponent> list) {
        int n = 0;
        for (JComponent jComponent : list) {
            if (!jComponent.isVisible()) continue;
            n += jComponent.getMinimumSize().width;
        }
        return n;
    }

    private static int getActualCornerWidth(List<JComponent> list) {
        int n = 0;
        for (JComponent jComponent : list) {
            if (!jComponent.isVisible()) continue;
            n += jComponent.getWidth();
        }
        return n;
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        if (this.fAlternativeComponent != null) {
            int n;
            this.fAlternativeComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
            if (this.fControlsBox == null && (n = DTToolBarContainer.getMinimumCornerWidth(this.fLeftCorners) + DTToolBarContainer.getMinimumCornerWidth(this.fRightCorners)) > 0) {
                Dimension dimension;
                int n2 = this.getWidth() - n;
                for (JComponent jComponent : this.fRightCorners) {
                    dimension = jComponent.getMinimumSize();
                    jComponent.setBounds(n2, 0, dimension.width, dimension.height);
                    n2 += dimension.width;
                }
                for (JComponent jComponent : this.fLeftCorners) {
                    dimension = jComponent.getMinimumSize();
                    jComponent.setBounds(n2, 0, dimension.width, dimension.height);
                    n2 += dimension.width;
                }
            }
            return;
        }
        int n = this.getWidth() - insets.left - insets.right;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getPreferredCornerHeight();
        int n6 = 0;
        int n7 = insets.top;
        JComponent[] jComponentArray = new JComponent[this.fToolBars.size()];
        Dimension[] dimensionArray = new Dimension[this.fToolBars.size()];
        for (int i = 0; i < this.fToolBars.size(); ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            ToolBarData toolBarData = this.fToolBars.get(i);
            if (toolBarData != sRowBreakData && toolBarData.fToolBar.isVisible()) {
                Dimension dimension = toolBarData.fToolBar.getPreferredSize();
                jComponentArray[n4] = toolBarData.fToolBar;
                dimensionArray[n4] = dimension;
                ++n4;
                n6 += dimension.width;
                if (dimension.height > n5) {
                    n5 = dimension.height;
                }
            }
            if (toolBarData != sRowBreakData && i != this.fToolBars.size() - 1 || n4 <= 0) continue;
            int n12 = insets.left;
            int n13 = n;
            if (!(n3 != 0 || this.fLeftCorners.isEmpty() && this.fRightCorners.isEmpty())) {
                n11 = DTToolBarContainer.getPreferredCornerWidth(this.fLeftCorners);
                n10 = DTToolBarContainer.getPreferredCornerWidth(this.fRightCorners);
                n9 = 0;
                n8 = 0;
                if (n6 + n11 + n10 > n) {
                    n11 = DTToolBarContainer.getMinimumCornerWidth(this.fLeftCorners);
                    n9 = 1;
                }
                if (n6 + n11 + n10 > n) {
                    n10 = DTToolBarContainer.getMinimumCornerWidth(this.fRightCorners);
                    n8 = 1;
                }
                n13 -= n11 + n10;
                for (JComponent jComponent : this.fLeftCorners) {
                    int n2 = (n9 != 0 ? jComponent.getMinimumSize() : jComponent.getPreferredSize()).width;
                    jComponent.setBounds(n12, n7, n2, n5);
                    n12 += n2;
                }
                int n15 = this.getWidth() - insets.right - n10;
                for (JComponent jComponent : this.fRightCorners) {
                    int n14 = (n8 != 0 ? jComponent.getMinimumSize() : jComponent.getPreferredSize()).width;
                    jComponent.setBounds(n15, n7, n14, n5);
                    n15 += n14;
                }
            }
            if (n13 > n6) {
                dimensionArray[n4 - 1].width += n13 - n6;
            } else {
                for (n11 = n4 - 1; n11 >= 0 && n6 > n13; n6 -= dimensionArray[n11].width - n8, --n11) {
                    n10 = n6 - n13;
                    n8 = dimensionArray[n11].width - n10;
                    n9 = jComponentArray[n11].getMinimumSize().width;
                    if (n8 < n9) {
                        n8 = n9;
                    }
                    dimensionArray[n11].width = n8;
                }
                for (n11 = n4 - 1; n11 >= 0 && n6 > n13; n6 -= dimensionArray[n11].width - n9, --n11) {
                    n10 = n6 - n13;
                    n9 = dimensionArray[n11].width - n10;
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    dimensionArray[n11].width = n9;
                }
            }
            for (n11 = 0; n11 < n4; ++n11) {
                if (jComponentArray[n11] != this.fDragHandler.iToolBar) {
                    jComponentArray[n11].setBounds(n12, n7, dimensionArray[n11].width, n5);
                } else {
                    jComponentArray[n11].setBounds(this.fDragHandler.iToolBar.getX(), n7, this.fDragHandler.iToolBar.getWidth(), n5);
                }
                n12 += dimensionArray[n11].width;
            }
            n7 += n5;
            ++n3;
            n4 = 0;
            n6 = 0;
            n5 = 0;
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.fDragHandler.iToolBar != null) {
            Insets insets = this.getInsets();
            int n = this.getWidth();
            int n2 = this.fDragHandler.iToolBar.getY();
            if (n2 > insets.top) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(insets.left, n2, n - insets.right - 1, n2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(insets.left, n2 + 1, n - insets.right - 1, n2 + 1);
                graphics.setColor(color);
            }
        }
    }

    private void fireStateChange() {
        if (this.fListeners == null) {
            return;
        }
        Object object = this.getState();
        for (Listener listener : this.fListeners) {
            listener.toolBarStateChanged(object);
        }
    }

    List<Action> getToggleActions() {
        return new ArrayList<ToggleAction>(this.fToggleActions);
    }

    List<Action> getContextToggleActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>(this.fToggleActions.size());
        for (ToggleAction toggleAction : this.fToggleActions) {
            if (toggleAction.getName() == null) continue;
            arrayList.add((Action)((Object)new ContextAction(toggleAction)));
        }
        return arrayList;
    }

    String addTheWordToolBar(String string) {
        String string2 = Desktop.getString((Component)((Object)this), "label.Toolbar");
        if (string.indexOf(string2) == -1) {
            Object[] objectArray = new Object[]{string};
            string = MessageFormat.format(Desktop.getString((Component)((Object)this), "menuitem.ThisToolBar"), objectArray);
        }
        return string;
    }

    Object getState() {
        return this.getToolBarCount() == 0 ? null : new ContainerState(this);
    }

    void restoreState(Object object) {
        assert (object != null);
        ContainerState containerState = (ContainerState)object;
        ArrayList<ToolBarData> arrayList = new ArrayList<ToolBarData>(containerState.fBarStates.size());
        for (BarState object2 : containerState.fBarStates) {
            if ("RowBreak".equals(object2.fKey)) {
                arrayList.add(sRowBreakData);
                continue;
            }
            this.fTargetData.fKey = object2.fKey;
            this.fTargetData.fLabel = object2.fLabel;
            int toolBarData = this.fToolBars.indexOf(this.fTargetData);
            if (toolBarData == -1) continue;
            ToolBarData toolBarData2 = this.fToolBars.remove(toolBarData);
            arrayList.add(toolBarData2);
            toolBarData2.fToolBar.setVisible(object2.fIsVisible);
            if (toolBarData2.fToggleAction == null) continue;
            toolBarData2.fToggleAction.setSelected(object2.fIsVisible);
        }
        boolean bl = false;
        for (ToolBarData toolBarData : this.fToolBars) {
            if (toolBarData != sRowBreakData) {
                if (!bl && !DTToolBarContainer.shouldAppendToolbar(toolBarData.fToolBar)) {
                    arrayList.add(sRowBreakData);
                }
                arrayList.add(toolBarData);
                bl = true;
                continue;
            }
            if (!bl) continue;
            arrayList.add(sRowBreakData);
        }
        this.fToolBars = arrayList;
        this.updateBorders();
        this.revalidate();
        this.repaint();
    }

    static Element stateToXML(Object object, Document document) {
        return ((ContainerState)object).toXML(document);
    }

    static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new ContainerState(simpleElement);
    }

    static List<String> keysFromState(Object object) {
        ContainerState containerState = (ContainerState)object;
        ArrayList<String> arrayList = new ArrayList<String>(containerState.fBarStates.size());
        for (BarState barState : containerState.fBarStates) {
            if ("RowBreak".equals(barState.fKey)) continue;
            arrayList.add(barState.fKey);
        }
        return arrayList;
    }

    static List<String> labelsFromState(Object object) {
        ContainerState containerState = (ContainerState)object;
        ArrayList<String> arrayList = new ArrayList<String>(containerState.fBarStates.size());
        for (BarState barState : containerState.fBarStates) {
            if ("RowBreak".equals(barState.fKey)) continue;
            arrayList.add(barState.fLabel);
        }
        return arrayList;
    }

    private static class ContainerState {
        List<BarState> fBarStates;

        ContainerState(DTToolBarContainer dTToolBarContainer) {
            this.fBarStates = new ArrayList<BarState>(dTToolBarContainer.fToolBars.size());
            for (ToolBarData toolBarData : dTToolBarContainer.fToolBars) {
                this.fBarStates.add(new BarState(toolBarData));
            }
        }

        ContainerState(SimpleElement simpleElement) throws DataFormatException {
            assert (DTToolBarContainer.TOOLBARS_TAG.equals(simpleElement.getTagName()));
            this.fBarStates = new ArrayList<BarState>();
            SimpleNodeList simpleNodeList = simpleElement.getChildElements();
            for (int i = 0; i < simpleNodeList.getLength(); ++i) {
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
                this.fBarStates.add(new BarState(simpleElement2));
            }
        }

        Element toXML(Document document) {
            Element element = document.createElement(DTToolBarContainer.TOOLBARS_TAG);
            for (BarState barState : this.fBarStates) {
                element.appendChild(barState.toXML(document));
            }
            return element;
        }
    }

    private static class BarState {
        String fKey;
        String fLabel;
        boolean fIsVisible;
        int fWidth = -1;

        BarState(ToolBarData toolBarData) {
            if (toolBarData.fToolBar == null) {
                this.fKey = "RowBreak";
            } else {
                this.fKey = toolBarData.fKey;
                this.fLabel = toolBarData.fLabel;
                this.fIsVisible = toolBarData.fToolBar.isVisible();
            }
        }

        BarState(SimpleElement simpleElement) throws DataFormatException {
            if ("RowBreak".equals(simpleElement.getTagName())) {
                this.fKey = "RowBreak";
            } else if (DTToolBarContainer.TOOLBAR_TAG.equals(simpleElement.getTagName())) {
                String string;
                if (simpleElement.hasAttribute(DTToolBarContainer.KEY_ATTRIBUTE)) {
                    this.fKey = simpleElement.getAttribute(DTToolBarContainer.KEY_ATTRIBUTE);
                }
                if (simpleElement.hasAttribute(DTToolBarContainer.LABEL_RESOURCE_ATTRIBUTE)) {
                    string = simpleElement.getAttribute(DTToolBarContainer.LABEL_RESOURCE_ATTRIBUTE);
                    int n = string.indexOf(58);
                    if (n == -1) {
                        throw new DataFormatException("Invalid LabelResource: " + string);
                    }
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this.fLabel = ResourceBundle.getBundle(string2).getString(string3);
                } else if (simpleElement.hasAttribute(DTToolBarContainer.LABEL_ATTRIBUTE)) {
                    this.fLabel = simpleElement.getAttribute(DTToolBarContainer.LABEL_ATTRIBUTE);
                }
                string = simpleElement.getAttribute(DTToolBarContainer.SHOWING_ATTRIBUTE);
                this.fIsVisible = DTToolBarContainer.YES_VALUE.equalsIgnoreCase(string);
                if (simpleElement.hasAttribute(DTToolBarContainer.WIDTH_ATTRIBUTE)) {
                    this.fWidth = this.getIntegerAttribute(simpleElement, DTToolBarContainer.WIDTH_ATTRIBUTE);
                }
            }
        }

        int getIntegerAttribute(SimpleElement simpleElement, String string) throws DataFormatException {
            int n = -1;
            String string2 = simpleElement.getAttribute(string);
            if (string2 != null && string2.length() > 0) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid " + string + ": " + string2);
                }
            }
            return n;
        }

        Element toXML(Document document) {
            if ("RowBreak".equals(this.fKey)) {
                return document.createElement("RowBreak");
            }
            Element element = document.createElement(DTToolBarContainer.TOOLBAR_TAG);
            if (this.fKey != null) {
                element.setAttribute(DTToolBarContainer.KEY_ATTRIBUTE, this.fKey);
            }
            if (this.fLabel != null) {
                element.setAttribute(DTToolBarContainer.LABEL_ATTRIBUTE, MJUtilities.exciseAmpersand((String)this.fLabel));
            }
            element.setAttribute(DTToolBarContainer.SHOWING_ATTRIBUTE, this.fIsVisible ? DTToolBarContainer.YES_VALUE : DTToolBarContainer.NO_VALUE);
            if (this.fWidth != -1) {
                element.setAttribute(DTToolBarContainer.WIDTH_ATTRIBUTE, Integer.toString(this.fWidth));
            }
            return element;
        }
    }

    class ContextAction
    extends MJAbstractAction {
        ToggleAction iToggleAction;

        ContextAction(ToggleAction toggleAction) {
            this.iToggleAction = toggleAction;
            this.setComponentName(toggleAction.getComponentName());
            this.setName(DTToolBarContainer.this.addTheWordToolBar(toggleAction.getName()));
            this.setSelected(toggleAction.isSelected());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iToggleAction.actionPerformed(actionEvent);
        }
    }

    class ToggleAction
    extends MJAbstractAction {
        ToolBarData iData;

        public ToggleAction(ToolBarData toolBarData) {
            super(toolBarData.fLabel);
            this.setComponentName("Toggle" + MJUtilities.exciseAmpersand((String)toolBarData.fLabel));
            this.iData = toolBarData;
            this.setSelected(toolBarData.fToolBar.isVisible());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (DTToolBarContainer.this.fToolBars.contains(this.iData)) {
                DTToolBarContainer.this.setToolBarVisible(this.iData, abstractButton.isSelected());
            }
        }
    }

    private class DragHandler
    extends MouseInputAdapter {
        int iCursor = 0;
        JComponent iToolBar;
        Point iToolBarStartLoc;
        Point iDragStartLoc;

        private DragHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.iCursor == 13) {
                this.iToolBar = this.getDraggableToolBar(mouseEvent);
                if (this.iToolBar != null) {
                    DTToolBarContainer.this.setLayer(this.iToolBar, JLayeredPane.DRAG_LAYER);
                    this.iToolBar.setSize(this.iToolBar.getPreferredSize().width, this.iToolBar.getHeight());
                    this.iToolBar.revalidate();
                    this.iToolBar.repaint();
                    this.iToolBarStartLoc = this.iToolBar.getLocation();
                    this.iDragStartLoc = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)DTToolBarContainer.this));
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.iToolBar != null) {
                DTToolBarContainer.this.setLayer(this.iToolBar, JLayeredPane.DEFAULT_LAYER);
                this.iToolBar = null;
                DTToolBarContainer.this.updateBorders();
                DTToolBarContainer.this.revalidate();
                DTToolBarContainer.this.repaint();
            }
            this.updateCursor(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iToolBar != null) {
                int n;
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)DTToolBarContainer.this));
                int n2 = point.x - this.iDragStartLoc.x;
                int n3 = point.y - this.iDragStartLoc.y;
                int n4 = this.iToolBarStartLoc.x + n2;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > DTToolBarContainer.this.getWidth() - 20) {
                    n4 = DTToolBarContainer.this.getWidth() - 20;
                }
                int n5 = this.iToolBarStartLoc.y + n3;
                int n6 = n5 + this.iToolBar.getHeight() / 2;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                int n10 = 0;
                int n11 = 0;
                for (n = 0; n < DTToolBarContainer.this.fToolBars.size(); ++n) {
                    ToolBarData toolBarData = (ToolBarData)DTToolBarContainer.this.fToolBars.get(n);
                    if (toolBarData.fToolBar == this.iToolBar) {
                        n7 = n;
                    }
                    if (n8 != -1) continue;
                    if (n6 < 0) {
                        n8 = 0;
                        n9 = 0;
                        continue;
                    }
                    if (toolBarData.fToolBar != null) {
                        if (!toolBarData.fToolBar.isVisible() || n9 != n11 && n6 > toolBarData.fToolBar.getY() + toolBarData.fToolBar.getHeight()) continue;
                        if (n9 == -1) {
                            n9 = n11;
                            n10 = n4 - (n9 == 0 ? DTToolBarContainer.getActualCornerWidth(DTToolBarContainer.this.fLeftCorners) : 0);
                        }
                        if (n == n7 || n4 > toolBarData.fToolBar.getX() + toolBarData.fToolBar.getWidth() / 2 || (n10 -= toolBarData.fToolBar.getWidth()) > 0) continue;
                        n8 = n;
                        continue;
                    }
                    ++n11;
                    if (n9 == -1) continue;
                    n8 = n;
                }
                if (n7 != n8) {
                    n = DTToolBarContainer.this.getPreferredSize().height;
                    if (n9 == -1) {
                        DTToolBarContainer.this.fToolBars.add(sRowBreakData);
                    }
                    if (n8 == -1) {
                        n8 = DTToolBarContainer.this.fToolBars.size();
                    }
                    ToolBarData toolBarData = (ToolBarData)DTToolBarContainer.this.fToolBars.remove(n7);
                    if (n7 <= n8) {
                        --n8;
                    }
                    DTToolBarContainer.this.fToolBars.add(n8, toolBarData);
                    if (n6 < 0) {
                        DTToolBarContainer.this.fToolBars.add(1, sRowBreakData);
                    }
                    int n12 = 0;
                    Iterator iterator = DTToolBarContainer.this.fToolBars.iterator();
                    while (iterator.hasNext()) {
                        ToolBarData toolBarData2 = (ToolBarData)iterator.next();
                        if (toolBarData2 == sRowBreakData) {
                            if (n12 == 0 || !iterator.hasNext()) {
                                iterator.remove();
                                continue;
                            }
                            n12 = 0;
                            continue;
                        }
                        if (toolBarData2.fToolBar == null || !toolBarData2.fToolBar.isVisible()) continue;
                        ++n12;
                    }
                    this.iToolBar.setLocation(n4, this.iToolBar.getY());
                    DTToolBarContainer.this.updateBorders();
                    DTToolBarContainer.this.revalidate();
                    DTToolBarContainer.this.repaint();
                    if (n != DTToolBarContainer.this.getPreferredSize().height) {
                        ((JComponent)DTToolBarContainer.this.getParent()).revalidate();
                        DTToolBarContainer.this.getParent().repaint();
                        DTToolBarContainer.this.revalidate();
                        DTToolBarContainer.this.repaint();
                    }
                }
            }
        }

        private JComponent getDraggableToolBar(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component.getParent() == DTToolBarContainer.this && component instanceof JComponent && !DTToolBarContainer.this.fLeftCorners.contains(component) && !DTToolBarContainer.this.fRightCorners.contains(component) && DTBorderFactory.BasicToolBarBorder.wantGrip(component)) {
                return (JComponent)component;
            }
            return null;
        }

        private void updateCursor(MouseEvent mouseEvent) {
            JComponent jComponent;
            int n = 0;
            if (mouseEvent.getID() != 505 && (jComponent = this.getDraggableToolBar(mouseEvent)) != null) {
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (n2 >= 2 && n2 <= 7 && n3 >= 3 && n3 <= jComponent.getHeight() - 3) {
                    n = 13;
                }
            }
            if (n != this.iCursor) {
                DTToolBarContainer.this.setCursor(Cursor.getPredefinedCursor(n));
                this.iCursor = n;
            }
        }
    }

    private class ContextListener
    extends MouseAdapter
    implements ContainerListener {
        private ContextListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
        }

        private void addTo(Component component) {
            if (!(component instanceof JTextField)) {
                component.addMouseListener(this);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.addTo(container.getComponent(i));
                }
            }
        }

        private void removeFrom(Component component) {
            if (!(component instanceof JTextField)) {
                component.removeMouseListener(this);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.removeFrom(container.getComponent(i));
                }
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            this.addTo(containerEvent.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            this.removeFrom(containerEvent.getChild());
        }

        void checkContextTrigger(MouseEvent mouseEvent) {
            Component component;
            Point point;
            if (mouseEvent.isPopupTrigger() && DTToolBarContainer.this.fAlternativeComponent == null && DTToolBarContainer.this.contains(point = SwingUtilities.convertPoint(component = mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)DTToolBarContainer.this)))) {
                this.showContextMenu(mouseEvent);
                mouseEvent.consume();
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            Desktop desktop;
            Object object;
            Object object2;
            Object object3 = (Component)mouseEvent.getSource();
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setCleanupUponClose(true);
            if (DTToolBarContainer.this.fOfferToggles) {
                object2 = DTToolBarContainer.this.getContextToggleActions().iterator();
                while (object2.hasNext()) {
                    object = (Action)object2.next();
                    mJPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)object));
                }
            }
            if ((object2 = object3 instanceof JToolBar ? (JToolBar)object3 : (JToolBar)SwingUtilities.getAncestorOfClass(JToolBar.class, (Component)object3)) != null && (object = (String)((JComponent)object2).getClientProperty("ToolBarKey")) != null && (desktop = Desktop.getDesktop((Component)object2)) != null) {
                MJMenuItem mJMenuItem = new MJMenuItem(desktop.getString("menuitem.Customize"));
                mJMenuItem.addActionListener(new ActionListener((String)object){
                    final /* synthetic */ String val$barKey;
                    {
                        this.val$barKey = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        desktop.showToolBarCustomizationPanel(this.val$barKey);
                    }
                });
                mJPopupMenu.addSeparator();
                mJPopupMenu.add((JMenuItem)mJMenuItem);
            }
            for (object = object3; object != DTToolBarContainer.this && object != null; object = ((Component)object).getParent()) {
                if (!(object instanceof DTMenuContributor)) continue;
                ((DTMenuContributor)object).contributeToMenu((JPopupMenu)mJPopupMenu, mouseEvent);
            }
            if (mJPopupMenu.getComponentCount() > 0) {
                object = mouseEvent.getPoint();
                if (object2 != null && object3 != object2) {
                    object = SwingUtilities.convertPoint((Component)object3, (Point)object, (Component)object2);
                    object3 = object2;
                }
                mJPopupMenu.show((Component)object3, ((Point)object).x, ((Point)object).y);
            }
        }
    }

    private static class ToolBarData {
        JComponent fToolBar;
        String fKey;
        String fLabel;
        ToggleAction fToggleAction;

        ToolBarData() {
        }

        ToolBarData(JComponent jComponent, String string, String string2) {
            this.fToolBar = jComponent;
            this.fKey = string;
            this.fLabel = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ToolBarData)) {
                return false;
            }
            ToolBarData toolBarData = (ToolBarData)object;
            return this.fKey != null && this.fKey.equals(toolBarData.fKey) || this.fLabel != null && toolBarData.fLabel != null && MJUtilities.exciseAmpersand((String)this.fLabel).equals(MJUtilities.exciseAmpersand((String)toolBarData.fLabel));
        }
    }

    public static interface Listener {
        public void toolBarStateChanged(Object var1);
    }
}

