/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.google.common.base.Preconditions;
import com.mathworks.mwswing.SimpleElement;
import java.util.Locale;
import java.util.zip.DataFormatException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTToolBarLocation {
    public static final int UNSPECIFIED_COORDINATE = Integer.MAX_VALUE;
    private final Region fRegion;
    private int fX = Integer.MAX_VALUE;
    private int fY = Integer.MAX_VALUE;
    private static final String REGION_ATTRIBUTE = "Region";
    private static final String X_ATTRIBUTE = "X";
    private static final String Y_ATTRIBUTE = "Y";

    public DTToolBarLocation(@NotNull Region region) {
        this.fRegion = region;
    }

    public static DTToolBarLocation createFloating(int n, int n2) {
        DTToolBarLocation dTToolBarLocation = new DTToolBarLocation(Region.FLOATING);
        dTToolBarLocation.fX = n;
        dTToolBarLocation.fY = n2;
        return dTToolBarLocation;
    }

    public Region getRegion() {
        return this.fRegion;
    }

    public void setLocation(int n, int n2) {
        Preconditions.checkState((this.fRegion == Region.FLOATING ? 1 : 0) != 0, (Object)"x and y values only apply to floating locations");
        this.fX = n;
        this.fY = n2;
    }

    public int getX() {
        return this.fX;
    }

    public int getY() {
        return this.fY;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DTToolBarLocation)) {
            return false;
        }
        DTToolBarLocation dTToolBarLocation = (DTToolBarLocation)object;
        return this.fRegion == dTToolBarLocation.fRegion && this.fX == dTToolBarLocation.fX && this.fY == dTToolBarLocation.fY;
    }

    public int hashCode() {
        int n = this.fRegion.hashCode();
        n = 17 * n + this.fX;
        n = 17 * n + this.fY;
        return n;
    }

    public Element toXML(Document document, String string) {
        Element element = document.createElement(string);
        element.setAttribute(REGION_ATTRIBUTE, this.fRegion.toString().toLowerCase(Locale.ENGLISH));
        if (this.fRegion == Region.FLOATING) {
            element.setAttribute(X_ATTRIBUTE, Integer.toString(this.fX));
            element.setAttribute(Y_ATTRIBUTE, Integer.toString(this.fY));
        }
        return element;
    }

    public static DTToolBarLocation fromXML(SimpleElement simpleElement) throws DataFormatException {
        String string = simpleElement.getAttribute(REGION_ATTRIBUTE);
        Region region = null;
        if (string != null) {
            try {
                region = Region.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataFormatException("Invalid attibute Region = " + string);
            }
        }
        if (region == Region.FLOATING) {
            int n = 0;
            String string2 = simpleElement.getAttribute(X_ATTRIBUTE);
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid addtibute X = " + string2);
                }
            }
            int n2 = 0;
            String string3 = simpleElement.getAttribute(Y_ATTRIBUTE);
            if (string3 != null) {
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid addtibute Y = " + string3);
                }
            }
            return DTToolBarLocation.createFloating(n, n2);
        }
        return new DTToolBarLocation(region);
    }

    public static enum Region {
        RIGHT_OF_TABS,
        LEFT_OF_TABS,
        ON_TITLE_BAR,
        BELOW_TOOLSTRIP,
        FLOATING;

    }
}

