/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.toolstrip.ToolstripSectionLayout;
import com.mathworks.toolstrip.ToolstripSectionLayoutPolicy;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.sections.DefaultToolstripSection;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

class LegacyToolstripSection
extends DefaultToolstripSection {
    private final JFrame fFrame;
    private final JMenuBar fMenuBar;
    private final JToolBar[] fToolBars;
    private final ToolstripSectionLayoutPolicy fLayoutPolicy;
    private JComponent fBarContainer;
    private static final int MINIMUM_WIDTH = 80;
    private static final int WIDTH_DECREMENT = 10;

    LegacyToolstripSection(JFrame jFrame, String string, String string2, JMenuBar jMenuBar, JToolBar[] jToolBarArray) {
        super(string, string2);
        this.fFrame = jFrame;
        this.fMenuBar = jMenuBar;
        this.fToolBars = Arrays.copyOf(jToolBarArray, jToolBarArray.length);
        this.fLayoutPolicy = new ToolstripSectionLayoutPolicy(){

            public Iterator<ToolstripSectionLayout> iterator() {
                return new LegacyLayoutIterator();
            }
        };
    }

    protected JComponent createComponent() {
        if (this.fBarContainer == null) {
            this.fBarContainer = new BarContainer();
            if (this.fMenuBar != null) {
                this.fBarContainer.add(this.fMenuBar);
            }
            if (this.fToolBars != null) {
                for (JToolBar jToolBar : this.fToolBars) {
                    this.fBarContainer.add(jToolBar);
                }
            }
        }
        return this.fBarContainer;
    }

    public ToolstripSectionLayoutPolicy getLayoutPolicy() {
        return this.fLayoutPolicy;
    }

    private class FixedLayout
    implements ToolstripSectionLayout {
        private final int iWidth;

        private FixedLayout(int n) {
            this.iWidth = n;
        }

        public int getPreferredWidth(ToolstripTab toolstripTab, int n, int n2) {
            return this.iWidth;
        }

        public JComponent layout(ToolstripTab toolstripTab, int n, int n2) {
            return LegacyToolstripSection.this.createComponent();
        }
    }

    private class LegacyLayoutIterator
    implements Iterator<ToolstripSectionLayout> {
        private int iLastWidth = -1;

        private LegacyLayoutIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iLastWidth < 0 || this.iLastWidth > 80;
        }

        @Override
        public ToolstripSectionLayout next() {
            if (this.iLastWidth < 0) {
                this.iLastWidth = LegacyToolstripSection.this.createComponent().getPreferredSize().width;
            } else if (this.iLastWidth > LegacyToolstripSection.this.fFrame.getWidth()) {
                this.iLastWidth = LegacyToolstripSection.this.fFrame.getWidth();
            } else if (this.iLastWidth > 80) {
                this.iLastWidth -= 10;
                if (this.iLastWidth < 80) {
                    this.iLastWidth = 80;
                }
            } else {
                throw new NoSuchElementException("Can't go below minimum width");
            }
            return new FixedLayout(this.iLastWidth);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    private class BarContainer
    extends JComponent {
        private Dimension fMenuBarSize;
        private Dimension[] fToolBarSizes;

        private BarContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            int n = insets.top + insets.bottom;
            int n2 = 0;
            int n3 = 0;
            if (LegacyToolstripSection.this.fMenuBar != null) {
                this.fMenuBarSize = LegacyToolstripSection.this.fMenuBar.getPreferredSize();
                this.fMenuBarSize.width += LegacyToolstripSection.this.fMenuBar.getMenuCount() * 20;
                n += this.fMenuBarSize.height;
                n2 = this.fMenuBarSize.width;
                ++n3;
            }
            if (LegacyToolstripSection.this.fToolBars != null) {
                int n4;
                this.fToolBarSizes = new Dimension[LegacyToolstripSection.this.fToolBars.length];
                for (n4 = 0; n4 < LegacyToolstripSection.this.fToolBars.length && n3 < 2; ++n4, ++n3) {
                    this.fToolBarSizes[n4] = LegacyToolstripSection.this.fToolBars[n4].getPreferredSize();
                    n += this.fToolBarSizes[n4].height;
                    if (this.fToolBarSizes[n4].width <= n2) continue;
                    n2 = this.fToolBarSizes[n4].width;
                }
                int n5 = 0;
                int n6 = 0;
                while (n4 < LegacyToolstripSection.this.fToolBars.length) {
                    this.fToolBarSizes[n4] = LegacyToolstripSection.this.fToolBars[n4].getPreferredSize();
                    if (this.fToolBarSizes[n4].height > n5) {
                        n5 = this.fToolBarSizes[n4].height;
                    }
                    n6 += this.fToolBarSizes[n4].width;
                    ++n4;
                }
                n += n5;
                if (n6 > n2) {
                    n2 = n6;
                }
            }
            return new Dimension(n2 += insets.left + insets.right, n);
        }

        @Override
        public void doLayout() {
            int n;
            int n2;
            int n3 = n2 = LegacyToolstripSection.this.fMenuBar == null ? 0 : 1;
            if (LegacyToolstripSection.this.fToolBars != null) {
                n2 = Math.min(3, n2 + LegacyToolstripSection.this.fToolBars.length);
            }
            Dimension dimension = this.getPreferredSize();
            Insets insets = this.getInsets();
            int n4 = this.getHeight() - dimension.height;
            int n5 = n4 / (n2 + 1);
            int n6 = insets.top + n5;
            int n7 = insets.left;
            int n8 = this.getWidth() - insets.left - insets.right;
            int n9 = 0;
            if (LegacyToolstripSection.this.fMenuBar != null) {
                n = Math.min(this.fMenuBarSize.width, n8);
                LegacyToolstripSection.this.fMenuBar.setBounds(n7, n6, n, this.fMenuBarSize.height);
                n6 += this.fMenuBarSize.height + n5;
                ++n9;
            }
            if (LegacyToolstripSection.this.fToolBars != null) {
                int n10;
                int n11;
                int n12;
                n = n9 + LegacyToolstripSection.this.fToolBars.length - 2;
                for (n12 = 0; n12 < LegacyToolstripSection.this.fToolBars.length - (n > 1 ? n : 0); ++n12) {
                    n11 = Math.min(this.fToolBarSizes[n12].width, n8);
                    n10 = this.fToolBarSizes[n12].height;
                    LegacyToolstripSection.this.fToolBars[n12].setBounds(n7, n6, n11, n10);
                    n6 += n10 + n5;
                }
                if (n > 1) {
                    int n13;
                    n11 = 0;
                    for (n10 = n12; n10 < LegacyToolstripSection.this.fToolBars.length; ++n10) {
                        n11 += this.fToolBarSizes[n10].width;
                    }
                    n10 = n11 - n8;
                    int n14 = n13 = n10 > 0 ? n10 / n : 0;
                    while (n12 < LegacyToolstripSection.this.fToolBars.length) {
                        int n15 = this.fToolBarSizes[n12].width - n13;
                        int n16 = this.fToolBarSizes[n12].height;
                        LegacyToolstripSection.this.fToolBars[n12].setBounds(n7, n6, n15, n16);
                        n7 += n15;
                        ++n12;
                    }
                }
            }
        }
    }
}

