/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor;

import com.mathworks.matlab.api.editor.EditorRegion;
import com.mathworks.util.Log;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Utilities;

public class EditorRegionImpl
implements EditorRegion {
    private final Mark fStart;
    private final Mark fEnd;

    public static EditorRegion createEditorRegion(BaseDocument baseDocument, int n, int n2) {
        return new EditorRegionImpl(baseDocument, n, n2);
    }

    private EditorRegionImpl(BaseDocument baseDocument, int n, int n2) {
        Validate.notNull((Object)baseDocument, (String)"The Document should not be null");
        this.fStart = new Mark(false);
        this.fEnd = new Mark(false);
        try {
            Utilities.insertMark((BaseDocument)baseDocument, (Mark)this.fStart, (int)n);
            Utilities.insertMark((BaseDocument)baseDocument, (Mark)this.fEnd, (int)n2);
        }
        catch (InvalidMarkException invalidMarkException) {
            throw new RuntimeException(invalidMarkException);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    public int getStart() {
        try {
            return this.fStart.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            Log.logException((Exception)((Object)invalidMarkException));
            return -1;
        }
    }

    public int getEnd() {
        try {
            return this.fEnd.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            Log.logException((Exception)((Object)invalidMarkException));
            return -1;
        }
    }

    public void dispose() {
        this.fStart.dispose();
        this.fEnd.dispose();
    }

    public boolean isValid() {
        return this.fStart.isValid() && this.fEnd.isValid() && this.getStart() < this.getEnd();
    }
}

