/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.fonts;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.FontSize;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.fonts.FontSamplePanel;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.apache.commons.lang.Validate;

public class FontPicker
implements ItemSelectable,
ComponentBuilder {
    public static final String FONT_PICKER_COMPONENT_NAME = "FontPicker";
    public static final String FONT_NAME_COMBOBOX_NAME = "NameChoice";
    public static final String FONT_STYLE_COMBOBOX_NAME = "StyleChoice";
    public static final String FONT_SIZE_COMBOBOX_NAME = "SizeChoice";
    public static final String FONT_SAMPLE_PANEL_NAME = "SampleText";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.fonts.resources.RES_Fonts");
    private final MJPanel fPanel;
    private final MJComboBox fNameCombo;
    private final MJComboBox fStyleCombo;
    private final MJComboBox fSizeCombo;
    private final FontSamplePanel fSample;
    private Font fSelectedFont;
    private ItemListener fItemListener;

    public FontPicker(Font font, Layout layout) {
        Validate.notNull((Object)font, (String)"'initialFont' cannot be null");
        Validate.notNull((Object)((Object)layout), (String)"'layout' cannot be null");
        this.fPanel = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = this.getFontMetrics(this.getFont()).charWidth('M') * 35;
                if (dimension.width > n) {
                    dimension.width = n;
                }
                return dimension;
            }
        };
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fSelectedFont = font;
        this.fNameCombo = new MJComboBox(FontUtils.getFontNames());
        this.fStyleCombo = new MJComboBox(FontUtils.getFontStyles());
        this.fSizeCombo = new MJComboBox(FontUtils.getStandardSizes());
        this.fSizeCombo.setEditorColumnCount(4);
        this.fSizeCombo.setEditable(true);
        this.fSample = layout == Layout.WIDE_WITH_SAMPLE ? new FontSamplePanel() : null;
        this.setNamesWithPrefix("");
        this.fStyleCombo.getAccessibleContext().setAccessibleName(BUNDLE.getString("font.acc.style"));
        this.fSizeCombo.getAccessibleContext().setAccessibleName(BUNDLE.getString("font.acc.size"));
        this.fNameCombo.getAccessibleContext().setAccessibleName(BUNDLE.getString("font.acc.name"));
        this.createLayout(layout);
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    public Font getSelectedFont() {
        return this.fSelectedFont;
    }

    public void setSelectedFont(Font font) {
        Validate.notNull((Object)font, (String)"'font' cannot be null");
        this.fSelectedFont = font;
        this.updateControls();
    }

    public void setSampleAntialiased(boolean bl) {
        if (this.fSample == null) {
            throw new IllegalArgumentException("Can only be called for layout WIDE_WITH_SAMPLE");
        }
        this.fSample.setAntialiased(bl);
    }

    public void setEnabled(boolean bl) {
        this.fPanel.setEnabled(bl);
        this.updateControls();
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedFont()};
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public void setNamesWithPrefix(String string) {
        this.fPanel.setName(string + FONT_PICKER_COMPONENT_NAME);
        this.fNameCombo.setName(string + FONT_NAME_COMBOBOX_NAME);
        this.fStyleCombo.setName(string + FONT_STYLE_COMBOBOX_NAME);
        this.fSizeCombo.setName(string + FONT_SIZE_COMBOBOX_NAME);
        if (this.fSample != null) {
            this.fSample.setLabelName(string + FONT_SAMPLE_PANEL_NAME);
        }
    }

    private void createLayout(Layout layout) {
        Object object;
        this.fPanel.setLayout((LayoutManager)new BorderLayout());
        if (layout == Layout.WIDE || layout == Layout.WIDE_WITH_SAMPLE) {
            object = new MJPanel((LayoutManager)new FlowLayout(1, 4, 0));
            object.add((Component)this.fStyleCombo);
            object.add((Component)this.fSizeCombo);
            this.fPanel.add((Component)this.fNameCombo, (Object)"Center");
            this.fPanel.add((Component)object, (Object)"East");
            if (layout == Layout.WIDE_WITH_SAMPLE) {
                this.fPanel.add((Component)this.fSample.getPanel(), (Object)"South");
            }
        } else {
            object = new PanelBuilder(new FormLayout("p:grow, 2dlu, p", "p, 2dlu, p"));
            CellConstraints cellConstraints = new CellConstraints();
            object.add((Component)this.fNameCombo, cellConstraints.xywh(1, 1, 3, 1));
            object.add((Component)this.fStyleCombo, cellConstraints.xy(1, 3));
            object.add((Component)this.fSizeCombo, cellConstraints.xy(3, 3));
            this.fPanel.add((Component)object.getPanel(), (Object)"Center");
        }
        this.updateControls();
        object = new ChoiceHandler();
        this.fNameCombo.addItemListener((ItemListener)object);
        this.fStyleCombo.addItemListener((ItemListener)object);
        this.fSizeCombo.addItemListener((ItemListener)object);
        this.fSizeCombo.addActionListener((ActionListener)object);
    }

    private void updateControls() {
        Font font = this.getSelectedFont();
        String string = font.getName();
        int n = font.getStyle();
        for (int i = 0; i < this.fNameCombo.getItemCount(); ++i) {
            String string2 = (String)this.fNameCombo.getItemAt(i);
            if (!string.equals(string2)) continue;
            this.fNameCombo.setSelectedIndex(i);
            break;
        }
        this.fStyleCombo.setSelectedIndex(n);
        this.fSizeCombo.setSelectedItem((Object)FontSize.createFromJavaFont((Font)font));
        this.fNameCombo.setEnabled(this.fPanel.isEnabled());
        this.fStyleCombo.setEnabled(this.fPanel.isEnabled());
        this.fSizeCombo.setEnabled(this.fPanel.isEnabled());
        if (this.fSample != null) {
            this.fSample.setSampleFont(this.getSelectedFont());
        }
    }

    private void fireItemEvent() {
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedFont(), 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    private boolean updateSelectedFont() {
        String string = (String)this.fNameCombo.getSelectedItem();
        int n = this.fStyleCombo.getSelectedIndex();
        FontSize fontSize = this.fSizeCombo.getSelectedItem() instanceof FontSize ? (FontSize)this.fSizeCombo.getSelectedItem() : FontSize.createFromPointSize((String)((String)this.fSizeCombo.getSelectedItem()));
        boolean bl = false;
        if (fontSize != null) {
            Font font = new Font(string, n, fontSize.getJavaSize());
            if (!this.getSelectedFont().equals(font)) {
                this.setSelectedFont(font);
                bl = true;
            }
        }
        return bl;
    }

    private class ChoiceHandler
    implements ItemListener,
    ActionListener {
        private ChoiceHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FontPicker.this.updateSelectedFont()) {
                FontPicker.this.fireItemEvent();
            } else {
                FontPicker.this.updateControls();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (FontPicker.this.updateSelectedFont()) {
                FontPicker.this.fireItemEvent();
            }
        }
    }

    public static enum Layout {
        COMPACT,
        WIDE,
        WIDE_WITH_SAMPLE;

    }
}

