/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.AsyncReceiverUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

final class CombinedExpansionContext<T>
implements ExpansionContext<T> {
    private final T fItem;
    private final GroupingTableConfiguration<T> fConfiguration;
    private final List<ExpansionChangeListener<T>> fListeners;
    private final PropertyChangeListener fConfigurationListener;
    private final ExpansionChangeListener<T> fHasChildrenListener;
    private volatile Boolean fHasChildren;
    private Map<ExpansionProvider<T>, ExpansionContext<T>> fProviderContexts;

    CombinedExpansionContext(T t, GroupingTableConfiguration<T> groupingTableConfiguration) {
        this.fItem = t;
        this.fListeners = new LinkedList<ExpansionChangeListener<T>>();
        this.fProviderContexts = null;
        this.fHasChildren = null;
        this.fConfiguration = groupingTableConfiguration;
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("expansion-providers")) {
                    CombinedExpansionContext.this.configureProviders();
                }
            }
        };
        this.fHasChildrenListener = new ExpansionChangeListener<T>(){

            @Override
            public void childrenChanged(GroupingTableTransaction<T> groupingTableTransaction) {
            }

            @Override
            public void hasChildrenChanged() {
                CombinedExpansionContext.this.fHasChildren = null;
            }
        };
        this.fListeners.add(this.fHasChildrenListener);
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.configureProviders();
    }

    private synchronized void configureProviders() {
        List<ExpansionProvider<T>> list = this.fConfiguration.getExpansionProviders();
        HashMap<ExpansionProvider<T>, ExpansionContext<T>> hashMap = new HashMap<ExpansionProvider<T>, ExpansionContext<T>>(1);
        boolean bl = false;
        for (ExpansionProvider iterator : list) {
            ExpansionContext<T> expansionContext;
            ExpansionContext<T> expansionContext2 = expansionContext = this.fProviderContexts == null ? null : this.fProviderContexts.get(iterator);
            if (expansionContext == null && (expansionContext = iterator.openContext(this.fItem)) != null) {
                for (ExpansionChangeListener<T> expansionChangeListener : this.fListeners) {
                    expansionContext.addListener(expansionChangeListener);
                }
                boolean bl2 = bl = this.fHasChildren != null && this.fHasChildren == false && (bl || expansionContext.hasChildren());
            }
            if (expansionContext == null) continue;
            hashMap.put(iterator, expansionContext);
        }
        boolean bl3 = false;
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                if (hashMap.containsValue(expansionContext)) continue;
                bl3 = true;
                expansionContext.close();
            }
        }
        Map<ExpansionProvider<T>, ExpansionContext<T>> map = this.fProviderContexts = hashMap.isEmpty() ? null : hashMap;
        if (bl) {
            this.setHasChildren(true);
        } else if (this.fHasChildren != null && this.fHasChildren.booleanValue() && bl3) {
            if (this.fProviderContexts != null) {
                for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                    if (!expansionContext.hasChildren()) continue;
                    return;
                }
            }
            this.setHasChildren(false);
        }
    }

    @Override
    public T getItem() {
        return this.fItem;
    }

    @Override
    public synchronized T createChildPlaceholder() {
        Iterator<ExpansionContext<T>> iterator;
        if (this.fProviderContexts != null && (iterator = this.fProviderContexts.values().iterator()).hasNext()) {
            ExpansionContext<T> expansionContext = iterator.next();
            return expansionContext.createChildPlaceholder();
        }
        return null;
    }

    @Override
    public synchronized Icon getOpenIcon(T t) {
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                Icon icon = expansionContext.getOpenIcon(t);
                if (icon == null) continue;
                return icon;
            }
        }
        return null;
    }

    private synchronized void setHasChildren(boolean bl) {
        if (this.fHasChildren == null || this.fHasChildren != bl) {
            this.fHasChildren = bl;
            for (ExpansionChangeListener<T> expansionChangeListener : this.fListeners) {
                if (expansionChangeListener == this.fHasChildrenListener) continue;
                expansionChangeListener.hasChildrenChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        Object object = this;
        synchronized (object) {
            if (this.fHasChildren != null) {
                return this.fHasChildren;
            }
        }
        while (true) {
            CombinedExpansionContext combinedExpansionContext = this;
            synchronized (combinedExpansionContext) {
                object = this.fProviderContexts;
            }
            boolean bl = false;
            if (object != null) {
                for (ExpansionContext expansionContext : object.values()) {
                    if (!expansionContext.hasChildren()) continue;
                    bl = true;
                    break;
                }
            }
            CombinedExpansionContext combinedExpansionContext2 = this;
            synchronized (combinedExpansionContext2) {
                if (this.fHasChildren != null) {
                    return this.fHasChildren;
                }
                if (object == this.fProviderContexts) {
                    this.setHasChildren(bl);
                    return bl;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getChildrenAsynchronously(final AsyncReceiver<T> asyncReceiver) {
        final HashSet hashSet = new HashSet();
        ArrayList<3> arrayList = new ArrayList<3>();
        CombinedExpansionContext combinedExpansionContext = this;
        synchronized (combinedExpansionContext) {
            if (this.fProviderContexts != null) {
                for (final ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                    arrayList.add(new ParameterRunnable<AsyncReceiver<T>>(){

                        public void run(AsyncReceiver<T> asyncReceiver) {
                            expansionContext.getChildrenAsynchronously(asyncReceiver);
                        }
                    });
                }
            }
        }
        AsyncReceiverUtils.chainInvoke(arrayList.iterator(), (AsyncReceiver)new AsyncReceiver<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean receive(T t) {
                Set set = hashSet;
                synchronized (set) {
                    if (!hashSet.add(t)) {
                        return true;
                    }
                }
                if (CombinedExpansionContext.this.fHasChildren == null || !CombinedExpansionContext.this.fHasChildren.booleanValue()) {
                    CombinedExpansionContext.this.setHasChildren(true);
                }
                return asyncReceiver.receive(t);
            }

            public void finished() {
                asyncReceiver.finished();
            }
        });
    }

    @Override
    public synchronized void addListener(ExpansionChangeListener<T> expansionChangeListener) {
        this.fListeners.add(expansionChangeListener);
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                expansionContext.addListener(expansionChangeListener);
            }
        }
    }

    @Override
    public synchronized void removeListener(ExpansionChangeListener<T> expansionChangeListener) {
        this.fListeners.remove(expansionChangeListener);
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                expansionContext.addListener(expansionChangeListener);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                expansionContext.close();
            }
        }
        this.fListeners.clear();
        this.fProviderContexts = null;
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    @Override
    public synchronized void refresh() {
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                expansionContext.refresh();
            }
        }
    }

    public synchronized String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("{" + this.fItem + "}\t");
        if (this.fProviderContexts != null) {
            for (ExpansionContext<T> expansionContext : this.fProviderContexts.values()) {
                printWriter.print("[" + expansionContext + "] ");
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }
}

