/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.internal.mwaws.client.v5.ActivationServiceAxis2ClientImpl;
import com.mathworks.internal.mwaws.client.v5.ActivationServiceClient;
import com.mathworks.internal.mwaws.client.v5.ArrayOfMWMessage;
import com.mathworks.internal.mwaws.client.v5.MWAAssociateResponse;
import com.mathworks.internal.mwaws.client.v5.MWMessage;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.widgets.login.ActivationResultWrapper;
import com.mathworks.widgets.login.LoginUtils;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.WebServiceError;
import com.mathworks.widgets.login.logging.Log;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;

public class ActivationServiceWrapper {
    private static ActivationServiceWrapper sInstance;

    static synchronized ActivationServiceWrapper getInstance() {
        if (sInstance == null) {
            sInstance = new ActivationServiceWrapper();
        }
        return sInstance;
    }

    private ActivationServiceWrapper() {
    }

    private static ActivationServiceClient getDefaultActivationService(String string, String string2) {
        try {
            return new ActivationServiceAxis2ClientImpl(string);
        }
        catch (AxisFault axisFault) {
            Log.getInstance().getLogger().fine(string2 + ": " + ((Object)((Object)axisFault)).getClass().getName() + " creating web service client " + axisFault.getMessage());
            return null;
        }
    }

    public ActivationResultWrapper associateUser(String string, String string2, String string3, String string4, String string5) {
        ActivationServiceClient activationServiceClient = ActivationServiceWrapper.getDefaultActivationService(WSEndPoints.getActivationServiceEndPoint(), string5);
        try {
            MWMessage[] mWMessageArray;
            MWAAssociateResponse mWAAssociateResponse = activationServiceClient.associateUser(string, string2, string3, string4, string5);
            int n = mWAAssociateResponse.getResult();
            if (n == 0) {
                return new ActivationResultWrapper(n);
            }
            ArrayList<WebServiceError> arrayList = new ArrayList<WebServiceError>();
            ArrayOfMWMessage arrayOfMWMessage = mWAAssociateResponse.getMessages();
            if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                for (MWMessage mWMessage : mWMessageArray) {
                    WebServiceError webServiceError = new WebServiceError();
                    webServiceError.setCode(mWMessage.getCode());
                    webServiceError.setDescription(mWMessage.getDescription());
                    webServiceError.setName(mWMessage.getName());
                    webServiceError.setSeverity(mWMessage.getSeverity());
                    arrayList.add(webServiceError);
                }
            }
            return new ActivationResultWrapper(arrayList);
        }
        catch (Exception exception) {
            Log.getInstance().getLogger().fine(LoginUtils.getClientVersion(UniversalLoginComponent.DEFAULT_CLIENT_STRING) + ": " + exception.getClass().getName() + " accessing web service client " + exception.getMessage());
            return new ActivationResultWrapper(ActivationServiceWrapper.getGeneralExceptionError(exception));
        }
    }

    private static List<WebServiceError> getGeneralExceptionError(Exception exception) {
        ArrayList<WebServiceError> arrayList = new ArrayList<WebServiceError>();
        WebServiceError webServiceError = new WebServiceError();
        webServiceError.setDescription(exception.getLocalizedMessage());
        arrayList.add(webServiceError);
        return arrayList;
    }
}

