/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.jidesoft.navigation.NavigationTree;
import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.widgets.prefs.AbstractPrefsNavigator;
import com.mathworks.widgets.prefs.PrefsModel;
import com.mathworks.widgets.prefs.PrefsModelEvent;
import com.mathworks.widgets.prefs.PrefsModelListener;
import com.mathworks.widgets.prefs.PrefsNavigator;
import com.mathworks.widgets.prefs.PrefsNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PrefsNavigationTree
extends NavigationTree {
    private final DefaultTreeCellRenderer fRenderer;
    private final PrefsTreeModel fModel;
    private final AbstractPrefsNavigator fNavigator;
    private final Semaphore fChangeLock;
    private final ColorListener fColorListener;
    private final PrefsModelListener fModelListener;
    private final PrefsModel fPrefsModel;
    private PrefsTreeNode fActiveNode;

    public PrefsNavigationTree(PrefsModel prefsModel) {
        super((TreeModel)new PrefsTreeModel(prefsModel.getRoot()));
        this.fPrefsModel = prefsModel;
        this.fChangeLock = new Semaphore(1);
        this.fColorListener = new ColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this.fColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this.fColorListener);
        this.fNavigator = new AbstractPrefsNavigator(){

            @Override
            public JComponent getComponent() {
                return PrefsNavigationTree.this;
            }

            @Override
            public PrefsNode getSelectedNode() {
                if (PrefsNavigationTree.this.fActiveNode == null) {
                    return null;
                }
                return PrefsNavigationTree.this.fActiveNode.getNode();
            }

            @Override
            public void refresh() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.refresh();
                        }
                    });
                } else {
                    PrefsNavigationTree.this.fModel.refresh();
                    if (PrefsNavigationTree.this.getRowCount() > 0) {
                        PrefsNavigationTree.this.setSelectionRow(0);
                    }
                }
            }

            @Override
            public void show(PrefsNode prefsNode) {
                PrefsNavigationTree.this.changeNode(PrefsNavigationTree.getTreeNode((PrefsTreeNode)PrefsNavigationTree.this.fModel.getRoot(), prefsNode), true);
            }

            @Override
            public void dispose() {
                ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)PrefsNavigationTree.this.fColorListener);
                ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)PrefsNavigationTree.this.fColorListener);
                PrefsNavigationTree.this.fPrefsModel.removePrefsModelListener(PrefsNavigationTree.this.fModelListener);
            }
        };
        this.fModel = (PrefsTreeModel)this.getModel();
        this.fModel.setNavigator(this.fNavigator);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.fRenderer = new DefaultTreeCellRenderer();
        this.setBackgroundColor();
        this.setTextColor();
        this.fRenderer.setLeafIcon(null);
        this.fRenderer.setOpenIcon(null);
        this.fRenderer.setClosedIcon(null);
        this.fRenderer.setBorderSelectionColor(null);
        this.setCellRenderer(this.fRenderer);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(fontMetrics.getHeight() + 2);
        this.fModelListener = new PrefsModelListener(){

            private void refresh(final PrefsNode prefsNode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrefsNavigationTree.this.clearSelection();
                        PrefsNode prefsNode2 = PrefsNavigationTree.this.getNavigator().getSelectedNode();
                        PrefsNavigationTree.this.fModel.refresh(prefsNode);
                        if (prefsNode2 != null) {
                            PrefsNavigationTree.this.getNavigator().show(prefsNode2);
                            PrefsNavigationTree.this.setSelectionPath(PrefsNavigationTree.getPath(PrefsNavigationTree.getTreeNode((PrefsTreeNode)PrefsNavigationTree.this.fModel.getRoot(), prefsNode2)));
                        }
                        PrefsNavigationTree.this.revalidate();
                        PrefsNavigationTree.this.repaint();
                    }
                });
            }

            @Override
            public void nodeTurnedOn(PrefsModelEvent prefsModelEvent) {
                this.refresh(prefsModelEvent.getNode());
            }

            @Override
            public void nodeTurnedOff(PrefsModelEvent prefsModelEvent) {
                this.refresh(prefsModelEvent.getNode());
            }
        };
        prefsModel.addPrefsModelListener(this.fModelListener);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                PrefsTreeNode prefsTreeNode = (PrefsTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!(PrefsNavigationTree.this.fActiveNode == prefsTreeNode || PrefsNavigationTree.this.fActiveNode == null || PrefsNavigationTree.this.fActiveNode.isLeaf() && PrefsNavigationTree.this.fActiveNode.getParent() == prefsTreeNode)) {
                    PrefsNavigationTree.this.changeNode(prefsTreeNode, true);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                PrefsTreeNode prefsTreeNode = (PrefsTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (PrefsNavigationTree.this.fActiveNode != null && PrefsNavigationTree.this.fActiveNode.isLeaf() && PrefsNavigationTree.this.fActiveNode.getParent() == prefsTreeNode) {
                    PrefsNavigationTree.this.changeNode(prefsTreeNode, true);
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PrefsTreeNode prefsTreeNode = (PrefsTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                PrefsNavigationTree.this.changeNode(prefsTreeNode, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrefsNavigationTree.this.requestFocus();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeNode(final PrefsTreeNode prefsTreeNode, final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrefsNavigationTree.this.changeNode(prefsTreeNode, bl);
                }
            });
            return;
        }
        if (this.fChangeLock.tryAcquire()) {
            try {
                if (this.fActiveNode != prefsTreeNode) {
                    if (this.fActiveNode != null && !this.fActiveNode.getNode().validateChanges()) {
                        this.clearSelection();
                        this.setSelectionPath(PrefsNavigationTree.getPath(this.fActiveNode));
                        return;
                    }
                    PrefsTreeNode prefsTreeNode2 = this.fActiveNode;
                    this.fActiveNode = prefsTreeNode;
                    Cursor cursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    TreePath treePath = PrefsNavigationTree.getPath(prefsTreeNode);
                    if (bl) {
                        this.setSelectionPath(treePath);
                    }
                    this.expandPath(treePath);
                    this.fNavigator.fireNodeDisplayed(prefsTreeNode.getNode());
                    if (prefsTreeNode2 != this.fModel.getRoot()) {
                        prefsTreeNode.getNode().notifyEditorDisplayed();
                    }
                    this.setCursor(cursor);
                    this.repaint();
                }
            }
            finally {
                this.fChangeLock.release();
            }
        }
    }

    private static PrefsTreeNode getTreeNode(PrefsTreeNode prefsTreeNode, PrefsNode prefsNode) {
        if (prefsTreeNode.getNode() == prefsNode) {
            return prefsTreeNode;
        }
        for (int i = 0; i < prefsTreeNode.getChildCount(); ++i) {
            PrefsTreeNode prefsTreeNode2 = prefsTreeNode.getChild(i);
            PrefsTreeNode prefsTreeNode3 = PrefsNavigationTree.getTreeNode(prefsTreeNode2, prefsNode);
            if (prefsTreeNode3 == null) continue;
            return prefsTreeNode3;
        }
        return null;
    }

    private static TreePath getPath(PrefsTreeNode prefsTreeNode) {
        Stack<PrefsTreeNode> stack = new Stack<PrefsTreeNode>();
        while (prefsTreeNode != null) {
            stack.push(prefsTreeNode);
            prefsTreeNode = prefsTreeNode.getParent();
        }
        Object[] objectArray = new Object[stack.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = stack.pop();
        }
        return new TreePath(objectArray);
    }

    public PrefsNavigator getNavigator() {
        return this.fNavigator;
    }

    private void setBackgroundColor() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrefsNavigationTree.this.setBackgroundColor();
                }
            });
        } else {
            Color color = ColorPrefs.getBackgroundColor();
            this.setBackground(color);
            this.fRenderer.setBackgroundNonSelectionColor(color);
            this.repaint();
        }
    }

    private void setTextColor() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrefsNavigationTree.this.setTextColor();
                }
            });
        } else {
            Color color = ColorPrefs.getTextColor();
            this.setForeground(color);
            this.fRenderer.setTextNonSelectionColor(color);
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension((int)this.getPreferredSize().getWidth(), (int)super.getMinimumSize().getHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension((int)this.getPreferredSize().getWidth(), (int)super.getMaximumSize().getHeight());
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension(23 * fontMetrics.charWidth('M'), (int)super.getPreferredSize().getHeight());
    }

    private static class PrefsTreeModel
    implements TreeModel {
        private final List<TreeModelListener> fListeners;
        private PrefsTreeNode fRoot;
        private AbstractPrefsNavigator fNavigator;

        public PrefsTreeModel(PrefsNode prefsNode) {
            this.fRoot = new PrefsTreeNode(this, prefsNode);
            this.fListeners = new Vector<TreeModelListener>(4);
        }

        public void setNavigator(AbstractPrefsNavigator abstractPrefsNavigator) {
            this.fNavigator = abstractPrefsNavigator;
        }

        public AbstractPrefsNavigator getNavigator() {
            return this.fNavigator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            PrefsTreeNode prefsTreeNode = this.fRoot;
            this.fRoot = new PrefsTreeNode(this, this.fRoot.getNode());
            List<TreeModelListener> list = this.fListeners;
            synchronized (list) {
                for (TreeModelListener treeModelListener : this.fListeners) {
                    treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(new Object[]{prefsTreeNode})));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(PrefsNode prefsNode) {
            List<TreeModelListener> list = this.fListeners;
            synchronized (list) {
                for (TreeModelListener treeModelListener : this.fListeners) {
                    treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, PrefsNavigationTree.getPath(PrefsNavigationTree.getTreeNode(this.fRoot, prefsNode.getParent()))));
                }
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.fListeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.fListeners.remove(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            return ((PrefsTreeNode)object).getChild(n);
        }

        @Override
        public int getChildCount(Object object) {
            return ((PrefsTreeNode)object).getChildCount();
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return ((PrefsTreeNode)object).getIndexOfChild((PrefsTreeNode)object2);
        }

        @Override
        public Object getRoot() {
            return this.fRoot;
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((PrefsTreeNode)object).isLeaf();
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private static class SelectableNode
    extends PrefsTreeNode
    implements Selectable {
        public SelectableNode(PrefsTreeModel prefsTreeModel, PrefsTreeNode prefsTreeNode, PrefsNode prefsNode) {
            super(prefsTreeModel, prefsTreeNode, prefsNode);
        }

        public void setSelectionState(SelectionState selectionState) {
            if (selectionState == SelectionState.SELECTED) {
                this.getNode().turnOn();
            } else {
                this.getNode().turnOff();
            }
        }

        public SelectionState getSelectionState() {
            if (this.getNode().canBeToggled() && this.getNode().isOn()) {
                return SelectionState.SELECTED;
            }
            return SelectionState.NOT_SELECTED;
        }
    }

    private static class PrefsTreeNode {
        private final PrefsTreeModel fModel;
        private final PrefsTreeNode fParent;
        private final PrefsNode fNode;
        private final List<PrefsTreeNode> fChildren;

        public PrefsTreeNode(PrefsTreeModel prefsTreeModel, PrefsTreeNode prefsTreeNode, PrefsNode prefsNode) {
            this.fNode = prefsNode;
            this.fModel = prefsTreeModel;
            this.fChildren = new Vector<PrefsTreeNode>(prefsNode.getChildCount());
            for (PrefsNode prefsNode2 : prefsNode.getChildren()) {
                this.fChildren.add(this.createTreeNode(prefsTreeModel, this, prefsNode2));
            }
            this.fParent = prefsTreeNode;
        }

        protected PrefsTreeNode createTreeNode(PrefsTreeModel prefsTreeModel, PrefsTreeNode prefsTreeNode, PrefsNode prefsNode) {
            if (prefsNode.canBeToggled()) {
                return new SelectableNode(prefsTreeModel, prefsTreeNode, prefsNode);
            }
            return new PrefsTreeNode(prefsTreeModel, prefsTreeNode, prefsNode);
        }

        public PrefsTreeNode(PrefsTreeModel prefsTreeModel, PrefsNode prefsNode) {
            this(prefsTreeModel, null, prefsNode);
        }

        public PrefsNode getNode() {
            return this.fNode;
        }

        public int getChildCount() {
            return this.fChildren.size();
        }

        public PrefsTreeNode getChild(int n) {
            return this.fChildren.get(n);
        }

        public int getIndexOfChild(PrefsTreeNode prefsTreeNode) {
            return this.fChildren.indexOf(prefsTreeNode);
        }

        public PrefsTreeNode getParent() {
            return this.fParent;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public String toString() {
            return this.getNode().getName().trim();
        }

        public AbstractPrefsNavigator getNavigator() {
            return this.fModel.getNavigator();
        }
    }

    private class ColorListener
    implements PrefListener {
        private ColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                PrefsNavigationTree.this.setTextColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                PrefsNavigationTree.this.setBackgroundColor();
            }
        }
    }
}

