/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.prefs.PrefsEditorPanel;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsModel;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.prefs.VersionedPrefsEditorPanel;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;

public final class PrefsUtils {
    private PrefsUtils() {
    }

    public static Tree<PrefsNode> toTree(PrefsNode prefsNode) {
        return TreeUtils.createWithUnknownRoot((Object)prefsNode, (Tree)new Tree<PrefsNode>(){

            public PrefsNode getRoot() {
                return null;
            }

            public int getChildCount(PrefsNode prefsNode) {
                return prefsNode.getChildCount();
            }

            public PrefsNode getChild(PrefsNode prefsNode, int n) {
                return prefsNode.getChild(n);
            }

            public PrefsNode getParent(PrefsNode prefsNode) {
                return prefsNode.getParent();
            }
        });
    }

    public static PrefsEditorPanel convertToCurrentVersion(VersionedPrefsEditorPanel versionedPrefsEditorPanel) {
        if (versionedPrefsEditorPanel instanceof PrefsEditorPanel) {
            return (PrefsEditorPanel)versionedPrefsEditorPanel;
        }
        if (versionedPrefsEditorPanel instanceof PrefsEditorPanelV1) {
            final PrefsEditorPanelV1 prefsEditorPanelV1 = (PrefsEditorPanelV1)versionedPrefsEditorPanel;
            return new PrefsEditorPanel(){

                @Override
                public void commitChanges(PrefsNode prefsNode) {
                    prefsEditorPanelV1.commitChanges(prefsNode);
                }

                @Override
                public boolean validateChanges(PrefsNode prefsNode) {
                    return prefsEditorPanelV1.validateChanges(prefsNode);
                }

                @Override
                public void cancelChanges(PrefsNode prefsNode) {
                    prefsEditorPanelV1.cancelChanges(prefsNode);
                }

                @Override
                public boolean canDetectPendingEdits(PrefsNode prefsNode) {
                    return prefsEditorPanelV1.canDetectPendingEdits(prefsNode);
                }

                @Override
                public boolean hasPendingEdits(PrefsNode prefsNode) {
                    return prefsEditorPanelV1.hasPendingEdits(prefsNode);
                }

                @Override
                public JComponent getComponent(PrefsNode prefsNode) {
                    return prefsEditorPanelV1.getComponent(prefsNode);
                }

                @Override
                public PrefsHelp getHelp() {
                    return prefsEditorPanelV1.getHelp();
                }

                @Override
                public void doHelp() {
                    prefsEditorPanelV1.doHelp();
                }

                @Override
                public void dispose() {
                    prefsEditorPanelV1.dispose();
                }
            };
        }
        throw new IllegalArgumentException();
    }

    public static PrefsNode findParentByDelimitedPath(PrefsModel prefsModel, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        vector.remove(vector.size() - 1);
        return PrefsUtils.findByPath(prefsModel.getRoot(), vector);
    }

    public static PrefsNode findByDelimitedPath(PrefsModel prefsModel, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return PrefsUtils.findByPath(prefsModel.getRoot(), vector);
    }

    public static PrefsNode findByPath(PrefsNode prefsNode, List<String> list) {
        String string = list.get(0);
        for (PrefsNode prefsNode2 : prefsNode.getChildren()) {
            if (!prefsNode2.getName().equals(string)) continue;
            if (list.size() == 1) {
                return prefsNode2;
            }
            return PrefsUtils.findByPath(prefsNode2, list.subList(1, list.size()));
        }
        return null;
    }
}

