/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SpreadsheetCellBorder
extends AbstractBorder {
    protected Color fGapColor;
    protected Color fTop;
    protected Color fBottom;
    protected Color fLeft;
    protected Color fRight;
    private static final Insets sInsets = new Insets(1, 1, 1, 1);

    public SpreadsheetCellBorder(Color color, Color color2, Color color3, Color color4, Color color5) {
        this.fGapColor = color5;
        this.fTop = color;
        this.fBottom = color3;
        this.fLeft = color2;
        this.fRight = color4;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        if (this.fTop != null) {
            SpreadsheetCellBorder.paintOuterLine(graphics, this.fGapColor, this.fTop, n, n2, n + n3 - 1, n2);
        }
        if (this.fLeft != null) {
            SpreadsheetCellBorder.paintOuterLine(graphics, this.fGapColor, this.fLeft, n, n2, n, n2 + n4);
        }
        if (this.fBottom != null) {
            SpreadsheetCellBorder.paintOuterLine(graphics, this.fGapColor, this.fBottom, n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
        if (this.fRight != null) {
            SpreadsheetCellBorder.paintOuterLine(graphics, this.fGapColor, this.fRight, n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        }
        if (this.fBottom != null) {
            if (this.fLeft != null) {
                graphics.setColor(this.fLeft);
                graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
            }
            if (this.fRight != null) {
                graphics.setColor(this.fRight);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        }
        if (this.fTop != null) {
            if (this.fRight != null) {
                graphics.setColor(this.fRight);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
            }
            if (this.fLeft != null) {
                graphics.setColor(this.fLeft);
                graphics.drawLine(n, n2, n, n2);
            }
        }
        graphics.setColor(color);
    }

    private static void paintInnerLine(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        if (color != null) {
            if (!PlatformInfo.isMacintosh()) {
                graphics.setXORMode(Color.BLACK);
            }
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3, n4);
            if (!PlatformInfo.isMacintosh()) {
                graphics.setPaintMode();
            }
        }
    }

    private static void paintOuterLine(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        if (color != null && !PlatformInfo.isMacintosh()) {
            graphics.setXORMode(color);
        }
        graphics.setColor(color2);
        graphics.drawLine(n, n2, n3, n4);
        graphics.setPaintMode();
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return sInsets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.left = 1;
        insets.top = 1;
        insets.right = 1;
        insets.bottom = 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

