/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.color;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import java.awt.Color;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MultiColorTableModel
implements ColorTableModel {
    private Color[] fColorMap = null;
    private int[][] fIndexes;
    private int fRows;
    private int fColumns;
    private List<ChangeListener> fChangeListeners;

    public MultiColorTableModel(Color[] colorArray, int[][] nArray) {
        this.privateSetColors(colorArray);
        this.privateSetIndexes(nArray);
        this.fChangeListeners = new Vector<ChangeListener>();
    }

    @Override
    public Color getColorAt(int n, int n2) {
        if (n < this.fRows && n2 < this.fColumns) {
            return this.fColorMap[this.fIndexes[n][n2]];
        }
        return null;
    }

    @Override
    public void addColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void removeColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void privateSetColors(Color[] colorArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, colorArray2, 0, colorArray.length);
        this.fColorMap = colorArray2;
    }

    private void privateSetIndexes(int[][] nArray) {
        this.fIndexes = MultiColorTableModel.arrayCopy2D(nArray);
        int[] nArray2 = ArrayUtils.getLengths((int[][])nArray);
        this.fRows = nArray2[0];
        this.fColumns = nArray2[1];
    }

    public void setColormap(Color[] colorArray) {
        this.privateSetColors(colorArray);
        this.fireChangeEvent();
    }

    public void setIndexes(int[][] nArray) {
        this.privateSetIndexes(nArray);
        this.fireChangeEvent();
    }

    public void setColormapAndIndexes(Color[] colorArray, int[][] nArray) {
        this.privateSetColors(colorArray);
        this.privateSetIndexes(nArray);
        this.fireChangeEvent();
    }

    private static int[][] arrayCopy2D(int[][] nArray) {
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray[i].length);
            nArrayArray[i] = nArray3;
        }
        return nArrayArray;
    }
}

