/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.MarkPair;
import com.mathworks.widgets.text.STPBaseInterface;
import java.util.List;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;

public final class LayerMarkList {
    private final List<MarkPair> fMarks = new Vector<MarkPair>();
    private final STPBaseInterface fTextPane;

    public LayerMarkList(STPBaseInterface sTPBaseInterface) {
        Validate.notNull((Object)sTPBaseInterface);
        this.fTextPane = sTPBaseInterface;
    }

    public synchronized void clear() {
        for (MarkPair markPair : this.fMarks) {
            markPair.remove();
        }
        this.fMarks.clear();
        this.fTextPane.getEditorUI().getComponent().repaint();
    }

    public synchronized boolean isEmpty() {
        return this.fMarks.isEmpty();
    }

    public synchronized void addMark(String string, int n, int n2) {
        try {
            MarkPair markPair = new MarkPair(string, this.fTextPane.getEditorUI(), (BaseDocument)this.fTextPane.getDocument());
            this.addMark(markPair, n, n + n2);
        }
        catch (InvalidMarkException invalidMarkException) {
            Log.logException((Exception)((Object)invalidMarkException));
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private synchronized void addMark(MarkPair markPair, int n, int n2) {
        try {
            for (int i = this.fMarks.size() - 1; i >= 0; --i) {
                MarkPair markPair2 = this.fMarks.get(i);
                if (markPair2.getLayerName().equals(markPair.getLayerName()) && markPair2.getEndOffset() == n) {
                    markPair2.setEndMarkActive();
                    continue;
                }
                if (markPair2.getEndOffset() < n) break;
            }
            this.fMarks.add(markPair);
            markPair.moveAndRepaint(this.fTextPane.getEditorUI(), n, n2);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        catch (InvalidMarkException invalidMarkException) {
            Log.logException((Exception)((Object)invalidMarkException));
        }
    }

    public synchronized boolean textSelectionWithinAMark() {
        int n = this.fTextPane.getSelectionStart();
        int n2 = this.fTextPane.getSelectionEnd();
        for (MarkPair markPair : this.fMarks) {
            try {
                if (n < markPair.getStartOffset() || n2 > markPair.getEndOffset()) continue;
                return true;
            }
            catch (InvalidMarkException invalidMarkException) {
                Log.logException((Exception)((Object)invalidMarkException));
            }
        }
        return false;
    }

    public final synchronized int size() {
        return this.fMarks.size();
    }

    public synchronized MarkPair get(int n) {
        return this.fMarks.get(n);
    }
}

