/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab.comment;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.matlab.MatlabTokenUtils;
import com.mathworks.widgets.text.mcode.MTokenContext;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.apache.commons.lang.StringUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

class Line {
    private final BaseDocument fDoc;
    private final Position fStart;
    private final Position fEnd;

    Line(BaseDocument baseDocument, int n) throws BadLocationException {
        this.fDoc = baseDocument;
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        this.fStart = baseDocument.createPosition(n2);
        this.fEnd = baseDocument.createPosition(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2));
    }

    String getText() {
        try {
            return this.fDoc.getText(this.getStartPosition(), this.getEndPosition() - this.getStartPosition());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return "";
        }
    }

    int getStartPosition() {
        return this.fStart.getOffset();
    }

    int getEndPosition() {
        return this.fEnd.getOffset();
    }

    int getLength() {
        return this.getEndPosition() - this.getStartPosition();
    }

    boolean isBlockCommentStartOrEnd() throws BadLocationException {
        TokenID tokenID = MatlabTokenUtils.getTokenID(this.fDoc, this.getStartPosition());
        return tokenID == MTokenContext.BLKSTART || tokenID == MTokenContext.BLKEND;
    }

    boolean isBlockCommentEnd() throws BadLocationException {
        return MatlabTokenUtils.getTokenID(this.fDoc, this.getStartPosition()) == MTokenContext.BLKEND;
    }

    boolean isBlank() {
        return StringUtils.isBlank((String)this.getText());
    }
}

