/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.menus.DefaultMenuGroupID;
import com.mathworks.widgets.messagepanel.DefaultMessagePanelPainter;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerMessageModel;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JMenuItem;

public class CodeAnalyzerMessageBarContributor
implements EditorMessageBarContributor {
    private static final MenuGroupID ANALYZER_CONFIGURATION_GROUP = new DefaultMenuGroupID("CodeAnalyzerConfigurationGroup");
    private final CodeAnalyzerMessageModel fModel;

    public CodeAnalyzerMessageBarContributor(CodeAnalyzerMessageModel codeAnalyzerMessageModel) {
        this.fModel = codeAnalyzerMessageModel;
    }

    public void configureModel(Editor editor) {
    }

    public Object getModel() {
        return this.fModel;
    }

    public void contributeToContextMenu(MenuBuilder menuBuilder) {
        menuBuilder.insertNextGroup(ANALYZER_CONFIGURATION_GROUP);
        List<JMenuItem> list = CodeAnalyzerUtils.createConfigurationMenuItems();
        if (list.size() > 1) {
            for (JMenuItem jMenuItem : list) {
                menuBuilder.add(ANALYZER_CONFIGURATION_GROUP, (Component)jMenuItem);
            }
        }
    }

    public boolean isPaintingSummary() {
        return true;
    }

    public Paint getSummaryPaint() {
        Paint paint;
        if (this.fModel.getMessageCount() == 0) {
            paint = DefaultMessagePanelPainter.NO_MESSAGES_PAINT;
        } else {
            paint = this.createWarningPaint();
            for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
                MLint.Message message = this.fModel.getMLintMessageAt(i);
                if (!CodeAnalyzerUtils.isError(message)) continue;
                paint = this.createErrorPaint();
                break;
            }
        }
        return paint;
    }

    private Paint createErrorPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, CodeAnalyzerUtils.getErrorColor(this.fModel.getSyntaxKit().getClass()));
    }

    private Paint createWarningPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, CodeAnalyzerUtils.getWarningColor(this.fModel.getSyntaxKit().getClass()));
    }

    public EditorMessageBarContributor.Priority getPriority() {
        return EditorMessageBarContributor.Priority.ALWAYS_ON_PROVIDING_SUMMARY;
    }

    public String getSummaryText() {
        String string = MLintPrefsUtils.isDefaultConfiguration() ? MLintPrefsUtils.DEFAULT_SETTINGS : FileUtils.truncatePathname((String)MLintPrefsUtils.getActiveConfiguration().getFile().getAbsolutePath());
        return MessageFormat.format(CodeAnalyzerUtils.getBundle().getString(this.fModel.getMessageCount() == 0 ? "mlint.noWarningsFound" : "mlint.warningsFound"), string);
    }

    public boolean isValid() {
        return this.fModel.isValid();
    }
}

