/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerLayer;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerMessageModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Timer;
import org.netbeans.editor.BaseDocument;

class CodeAnalyzerThread {
    private static final int DELAY_AFTER_TYPING = 1500;
    private final STPBaseInterface fSyntaxPane;
    private final Object fLock;
    private final Timer fLintingTimer;
    private boolean fShowEMLMessages = false;
    private MLintConfiguration fConfiguration;
    private boolean fMessagesOutOfSync;
    private final CodeAnalyzerMessageModel fModel;
    private volatile boolean fEnabled = false;

    CodeAnalyzerThread(STPBaseInterface sTPBaseInterface, CodeAnalyzerMessageModel codeAnalyzerMessageModel) {
        this.fSyntaxPane = sTPBaseInterface;
        this.fModel = codeAnalyzerMessageModel;
        this.fLock = new Object();
        this.fLintingTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeAnalyzerThread.this.notifyMLintThread();
            }
        });
        this.fLintingTimer.setRepeats(false);
    }

    void showEMLMessages(boolean bl) {
        this.fShowEMLMessages = bl;
    }

    private void doMLint() {
        assert (MLint.nativeLibraryExists()) : "MLint native library wasn't loaded";
        try {
            List<MLint.Message> list;
            String string = this.fSyntaxPane.getDocument().getText(0, this.fSyntaxPane.getDocument().getLength());
            if (string.length() > 0) {
                MLintConfiguration mLintConfiguration = this.fConfiguration == null ? MLintPrefsUtils.getActiveConfiguration() : this.fConfiguration;
                list = MLint.getMessages(string, CodeAnalyzerLayer.getFilename(this.fSyntaxPane.getDocument()), mLintConfiguration, this.fShowEMLMessages);
                CodeAnalyzerUtilities.modifyMessages((BaseDocument)this.fSyntaxPane.getDocument(), list);
            } else {
                list = Collections.emptyList();
            }
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CodeAnalyzerThread.this.fMessagesOutOfSync = false;
                    CodeAnalyzerThread.this.fModel.update(list);
                }
            });
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    boolean isOutOfSync() {
        return this.fMessagesOutOfSync;
    }

    void setConfiguration(MLintConfiguration mLintConfiguration) {
        this.fConfiguration = mLintConfiguration;
    }

    void start() {
        assert (!this.fEnabled) : "Should only have one thread per Code Analyzer";
        this.fEnabled = true;
        Thread thread = new Thread((Runnable)new MLintRunnable(), "Code Analyzer updating thread");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
        this.restartTimer();
    }

    private void restartTimer() {
        this.fModel.refreshMessageValidStatePainting();
        if (this.fLintingTimer.isRunning()) {
            this.fLintingTimer.restart();
        } else {
            this.fLintingTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMLintThread() {
        Object object = this.fLock;
        synchronized (object) {
            this.fLock.notifyAll();
        }
    }

    void stop() {
        this.fEnabled = false;
        this.fLintingTimer.stop();
        this.notifyMLintThread();
    }

    void refresh() {
        this.notifyMLintThread();
    }

    void refreshSynchronously() {
        this.doMLint();
    }

    void documentModified() {
        this.fMessagesOutOfSync = true;
        this.restartTimer();
    }

    private class MLintRunnable
    implements Runnable {
        private MLintRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (CodeAnalyzerThread.this.fEnabled) {
                CodeAnalyzerThread.this.doMLint();
                Object object = CodeAnalyzerThread.this.fLock;
                synchronized (object) {
                    try {
                        CodeAnalyzerThread.this.fLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Log.logException((Exception)interruptedException);
                    }
                }
            }
        }
    }
}

