/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.transport.rmi;

import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIRegistryManagerExtended
implements RMIRegistryManagerInterface {
    private static final Logger logger = Logger.getLogger(RMIRegistryManagerExtended.class.getName());
    private final InetAddress hostAddress;
    private final int port;

    private RMIRegistryManagerExtended(InetAddress hostAddress, int port) {
        this.hostAddress = hostAddress;
        this.port = port;
    }

    public static RMIRegistryManagerExtended getRMIRegistryManagerForLocalhost(int port) {
        try {
            return new RMIRegistryManagerExtended(InetAddress.getLocalHost(), port);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static RMIRegistryManagerExtended getRMIRegistryManagerForHost(String host, int port) {
        try {
            InetAddress hostAddressLocal = InetAddress.getByName(host);
            return new RMIRegistryManagerExtended(hostAddressLocal, port);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public boolean isLocalHost() {
        try {
            return this.hostAddress.equals(InetAddress.getLocalHost()) || this.hostAddress.getHostName().equals("localhost");
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public boolean isValidRegistry() {
        boolean isValid = true;
        try {
            String[] listResult;
            Registry registry = this.getRMIRegistryHelper();
            for (String str : listResult = registry.list()) {
                logger.fine("Registry entry " + str);
            }
        }
        catch (IOException e2) {
            isValid = false;
        }
        catch (Exception e3) {
            throw new IllegalStateException(e3);
        }
        return isValid;
    }

    public boolean isValidLookup(String lookupName) {
        boolean isValid = true;
        try {
            Registry registry = this.getRMIRegistryHelper();
            registry.lookup(lookupName);
        }
        catch (Exception e2) {
            isValid = false;
        }
        return isValid;
    }

    @Override
    public Registry getRMIRegistry() {
        return this.getRMIRegistryHelper();
    }

    @Override
    public Registry getRMIRegistry(int socketTimeoutMins) {
        return this.getRMIRegistryHelper(socketTimeoutMins);
    }

    @Override
    public String getCanonicalHostName() {
        return this.hostAddress.getCanonicalHostName();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public Registry createOrGetInProcessRMIRegistry() {
        if (this.isLocalHost()) {
            Registry retval;
            Registry candidateRegistry = this.getRMIRegistryHelper();
            if (this.isValidRegistryHelper(candidateRegistry)) {
                logger.info("Found existing registry");
                retval = candidateRegistry;
            } else {
                logger.info("Creating new in process registry.");
                retval = this.createInProcessRMIRegistry();
            }
            return retval;
        }
        throw new IllegalStateException("Attempting to create an inprocess registry with a non localhost");
    }

    private Registry createInProcessRMIRegistry() {
        Registry retval = null;
        try {
            logger.info("Creating in process RMI registry.");
            retval = LocateRegistry.createRegistry(this.port);
        }
        catch (RemoteException e2) {
            logger.log(Level.SEVERE, "Error", e2);
        }
        return retval;
    }

    private Registry getRMIRegistryHelper() {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(this.hostAddress.getCanonicalHostName(), this.port);
        }
        catch (RemoteException e2) {
            logger.log(Level.SEVERE, "Error", e2);
        }
        return registry;
    }

    private Registry getRMIRegistryHelper(final int socketTimeoutMins) {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(this.hostAddress.getCanonicalHostName(), this.port, new RMIClientSocketFactory(){

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    Socket socket = new Socket(host, port);
                    socket.setSoTimeout((int)TimeUnit.MINUTES.toMillis(socketTimeoutMins));
                    return socket;
                }
            });
        }
        catch (RemoteException e2) {
            logger.log(Level.SEVERE, "Error", e2);
        }
        return registry;
    }

    private boolean isValidRegistryHelper(Registry registryIn) {
        boolean isValid = true;
        try {
            String[] listResult;
            for (String str : listResult = registryIn.list()) {
                logger.fine("Registry entry " + str);
            }
        }
        catch (IOException e2) {
            isValid = false;
        }
        catch (Exception e3) {
            throw new IllegalStateException(e3);
        }
        return isValid;
    }
}

