/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.transport.rmi.message;

import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerExtended;
import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerInterface;
import com.mathworks.matlabserver.common.transport.rmi.message.MessageServiceExtendedRemote;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.compute.ComputeTokenDO;
import com.mathworks.matlabserver.internalservices.message.MessageService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.IOException;
import java.rmi.registry.Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIClientMessageService
implements MessageService {
    private static final Logger logger = Logger.getLogger(RMIClientMessageService.class.getName());
    private MessageServiceExtendedRemote extendedRemoteProxy;
    private final RMIRegistryManagerInterface rmiManager;
    private final String lookupName;

    public RMIClientMessageService() {
        this.rmiManager = null;
        this.lookupName = null;
    }

    public RMIClientMessageService(String registryHost, int registryPort, String lookupName) {
        this.rmiManager = RMIRegistryManagerExtended.getRMIRegistryManagerForHost(registryHost, registryPort);
        this.lookupName = lookupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, MessageContainerDO messageContainer) {
        MessageContainerDO retval;
        this.ensureValidExtendedRemoteProxy();
        MessageContainerDO messageContainerResponse = null;
        try {
            messageContainerResponse = this.extendedRemoteProxy.sendMessages(userToken, messageContainer);
        }
        catch (IOException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
            this.extendedRemoteProxy = null;
        }
        finally {
            if (messageContainerResponse != null) {
                retval = messageContainerResponse;
            } else {
                logger.severe("messageContainerResponse == null");
                retval = messageContainer;
            }
        }
        return retval;
    }

    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, ComputeTokenDO computeToken, MessageContainerDO messageContainer) {
        throw new UnsupportedOperationException("This method is deprecated, please use the two argument version.");
    }

    private synchronized void ensureValidExtendedRemoteProxy() {
        if (this.extendedRemoteProxy == null) {
            Registry registry = this.rmiManager.getRMIRegistry();
            try {
                this.extendedRemoteProxy = (MessageServiceExtendedRemote)registry.lookup(this.lookupName);
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, e2.getMessage(), e2);
            }
        }
    }
}

