/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.util.concurrent;

import com.mathworks.matlabserver.common.util.concurrent.PollTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PollService {
    private static final Logger logger = Logger.getLogger(PollService.class.getName());
    private static final ScheduledExecutorService sharedSchedulerThreadSafe = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("poll service");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final PollTask pollTask;

    public static boolean tryWaitUntilTaskComplete(PollTask pollTask, long timeout, TimeUnit timeoutUnits, long taskPeriod, TimeUnit taskUnits) {
        PollService pollService = new PollService(pollTask);
        boolean isTaskComplete = false;
        try {
            isTaskComplete = pollService.tryWaitUntilTaskComplete(timeout, timeoutUnits, taskPeriod, taskUnits);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error", e2);
        }
        return isTaskComplete;
    }

    public PollService(PollTask pollTask) {
        logger.info("Creating PollService");
        this.pollTask = pollTask;
    }

    public boolean tryWaitUntilTaskComplete(long timeout, TimeUnit timeoutUnits, long taskPeriod, TimeUnit taskUnits) {
        boolean isTaskComplete = false;
        Semaphore semaphore = new Semaphore(1);
        ScheduledFuture<?> future = null;
        IsCompleteRunner runnable = new IsCompleteRunner(semaphore);
        try {
            semaphore.acquire();
            future = sharedSchedulerThreadSafe.scheduleAtFixedRate(runnable, taskPeriod, taskPeriod, taskUnits);
            if (semaphore.tryAcquire(timeout, timeoutUnits)) {
                isTaskComplete = true;
            } else {
                logger.warning("PollService task did not complete in the specified time limit: " + timeout + " " + (Object)((Object)timeoutUnits));
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error", t);
            throw new IllegalStateException(t);
        }
        finally {
            if (future != null && !future.isCancelled()) {
                future.cancel(true);
            }
            if (semaphore != null) {
                semaphore.release();
            }
        }
        return isTaskComplete;
    }

    private class IsCompleteRunner
    implements Runnable {
        private final Semaphore semaphore;

        public IsCompleteRunner(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isComplete = false;
            try {
                isComplete = PollService.this.pollTask.isComplete();
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error", e2);
                isComplete = true;
            }
            finally {
                if (isComplete && this.semaphore != null) {
                    this.semaphore.release();
                }
            }
        }
    }
}

