/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connectorcommon.fileservices.impl;

import com.mathworks.matlabserver.connectorcommon.fileservices.impl.FilenameConverterConnectorDirect;
import com.mathworks.matlabserver.connectorcommon.util.d;
import com.mathworks.matlabserver.fileservices.impl.FileServiceDirect;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FilePermissionsDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.File;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileServiceConnectorDirect
extends FileServiceDirect {
    public FileServiceConnectorDirect(String string, String string2) {
        super(new FilenameConverterConnectorDirect());
    }

    public FileServiceConnectorDirect(String string) {
        super(new FilenameConverterConnectorDirect());
    }

    public FileServiceConnectorDirect(FilenameConverter filenameConverter) {
        super(filenameConverter);
    }

    @Override
    public FileInfoDO create(UserTokenDO serializable, FileDO serializable2) {
        if ((serializable2 = ((FileInfoDO)(serializable = super.create((UserTokenDO)serializable, (FileDO)serializable2))).getFilePermissions()) == null) {
            serializable2 = new FilePermissionsDO();
            ((FileInfoDO)serializable).setFilePermissions((FilePermissionsDO)serializable2);
            ((FilePermissionsDO)serializable2).setCanWrite(true);
        }
        return serializable;
    }

    @Override
    public FileDO open(UserTokenDO userTokenDO, FileInfoDO serializable) {
        if ((serializable = super.open(userTokenDO, (FileInfoDO)serializable)) != null && ((FileDO)serializable).getFileInfo().getLocation() != null) {
            String string = this.filenameConverter.convertFilenameFromWorkerToServer(userTokenDO, ((FileDO)serializable).getFileInfo().getLocation());
            new d();
            d.a(userTokenDO, "addpath('" + string + "');");
        }
        return serializable;
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO serializable, FileInfoDO object) {
        object = this.prepareFileInfo((UserTokenDO)serializable, (FileInfoDO)object);
        serializable = new FileInfoDO(this.filenameConverter.convertFilenameFromServerToWorker((UserTokenDO)serializable, (String)object));
        if (((File)(object = new File((String)object))).exists()) {
            ((FileInfoDO)serializable).setSize(((File)object).length());
            ((FileInfoDO)serializable).setModified(new Date(((File)object).lastModified()));
            ((FileInfoDO)serializable).setType(FilenameUtils.getExtension(((File)object).getName()));
            ((FileInfoDO)serializable).setDirectory(((File)object).isDirectory());
            FilePermissionsDO filePermissionsDO = new FilePermissionsDO();
            filePermissionsDO.setCanWrite(((File)object).canWrite());
            ((FileInfoDO)serializable).setFilePermissions(filePermissionsDO);
        } else {
            ((FileInfoDO)serializable).setDeleted(true);
        }
        return serializable;
    }

    @Override
    protected void moveFile(File file, File file2) {
        if (file2.exists()) {
            throw new MLSException("FileService.IOError", "A file named: '" + file.getName() + "' already exists at the destination location: '" + file2.getAbsolutePath() + "', unable to move file(s)");
        }
        FileUtils.copyFile(file, file2);
        FileUtils.forceDelete(file);
    }

    @Override
    protected void moveDirectory(File file, File file2) {
        FileUtils.moveDirectory(file, file2);
    }

    @Override
    protected void moveDirectoryToDirectory(File file, File file2) {
        FileUtils.moveDirectoryToDirectory(file, file2, false);
    }

    @Override
    protected void moveFileToDirectory(File file, File file2) {
        File file3 = file2;
        if (file2.isDirectory()) {
            file3 = new File(file2.getPath() + File.separator + file.getName());
        }
        if (file3.exists()) {
            throw new MLSException("FileService.IOError", "A file named: '" + file3.getName() + "' already exists at the destination location: '" + file2.getAbsolutePath() + "', unable to move file(s)");
        }
        FileUtils.copyFileToDirectory(file, file2);
        FileUtils.forceDelete(file);
    }

    @Override
    protected void addMetadata(FileInfoDO fileInfoDO) {
    }

    @Override
    protected void addMetadata(FileInfoDO[] fileInfoDOArray) {
    }
}

