/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.editordataservice;

import com.mathworks.matlabserver.editordataservice.EditorNode;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerNodeAdapter;
import com.mathworks.peermodel.events.PeerNodeEvent;
import com.mathworks.peermodel.events.PeerNodeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EditorDataServiceImpl {
    private PeerModelManager PEER_MODEL_MANAGER;
    private final Map<String, List<String>> fFeaturesLibrary;
    private Observer fRootSetObserver = this.createRootSetObserver();
    private final Map<String, EditorNode> fActiveEditors = new HashMap<String, EditorNode>();
    private static boolean sLoggingErrors = true;
    public static final String SINGLETON_EDITOR_FEATURES_ID = "global.features";

    public EditorDataServiceImpl() {
        this(EditorDataServiceImpl.createFeaturesLibrary());
    }

    EditorDataServiceImpl(Map<String, List<String>> featuresLibrary) {
        this.fFeaturesLibrary = featuresLibrary;
        this.PEER_MODEL_MANAGER = PeerModelManagers.getClientInstance((String)"/editordataservice");
        this.PEER_MODEL_MANAGER.setSyncEnabled(true);
        this.PEER_MODEL_MANAGER.addEventListener("rootSet", this.fRootSetObserver);
        this.initializeRootListeners();
        this.initializeSingletonEditorFeatures();
    }

    private void initializeSingletonEditorFeatures() {
        List<String> singletonEditorFeatures = this.fFeaturesLibrary.get(SINGLETON_EDITOR_FEATURES_ID);
        if (singletonEditorFeatures != null) {
            for (String singleEditorFeature : singletonEditorFeatures) {
                try {
                    Class<?> classDefinition = Class.forName(singleEditorFeature);
                    classDefinition.newInstance();
                }
                catch (Exception e2) {
                    if (!sLoggingErrors) continue;
                    e2.printStackTrace();
                }
            }
        }
    }

    private void initializeRootListeners() {
        if (this.PEER_MODEL_MANAGER.hasRoot()) {
            this.PEER_MODEL_MANAGER.getRoot().addPeerNodeListener((PeerNodeListener)new PeerNodeAdapter(){

                public void childAdded(PeerNodeEvent peerNodeEvent) {
                    PeerNode childNode = this.getAddedChild(peerNodeEvent);
                    this.rootChildListener(childNode);
                    String nodeId = childNode.getId();
                    EditorDataServiceImpl.this.addEditorNode(childNode, nodeId);
                }

                private void rootChildListener(final PeerNode addChildNode) {
                    addChildNode.addPeerNodeListener((PeerNodeListener)new PeerNodeAdapter(){

                        public void destroyed(PeerNodeEvent event) {
                            String nodeId = addChildNode.getId();
                            EditorNode node = (EditorNode)EditorDataServiceImpl.this.fActiveEditors.remove(nodeId);
                            if (node != null) {
                                node.dispose();
                            }
                        }
                    });
                }

                private PeerNode getAddedChild(PeerNodeEvent peerNodeEvent) {
                    return (PeerNode)((Event)peerNodeEvent).getData().get("child");
                }
            });
        }
    }

    public Map<String, EditorNode> getActiveEditorNodes() {
        return Collections.unmodifiableMap(this.fActiveEditors);
    }

    private void addEditorNode(PeerNode childNode, String nodeId) {
        this.fActiveEditors.put(nodeId, new EditorNode(childNode, this.fFeaturesLibrary));
    }

    private Observer createRootSetObserver() {
        return new Observer(){

            public void handle(Event event) {
                EditorDataServiceImpl.this.initializeRootListeners();
            }
        };
    }

    private static Map<String, List<String>> createFeaturesLibrary() {
        HashMap<String, List<String>> featuresLibrary = new HashMap<String, List<String>>();
        featuresLibrary.put(SINGLETON_EDITOR_FEATURES_ID, Arrays.asList("com.mathworks.matlabserver.worker.service.breakpoint.impl13b.DebuggerInstaller"));
        featuresLibrary.put("matlab.debug.executionarrow", Arrays.asList("com.mathworks.matlabserver.worker.service.breakpoint.impl13b.executionarrow.ExecutionArrowFeature"));
        featuresLibrary.put("matlabcode.functions", Arrays.asList("com.mathworks.matlabserver.workerR2013b.editorservices.EditorMatlabFunctionsFeature", "com.mathworks.matlabserver.workerR2014a.desktopservices.editorfeatures.EditorMatlabFunctionsFeature"));
        featuresLibrary.put("matlab.code.variables", Arrays.asList("com.mathworks.matlabserver.workerR2013b.editorservices.EditorVariableHighlightingFeature"));
        featuresLibrary.put("matlab.code.codefolding", Arrays.asList("com.mathworks.matlabserver.workerR2013b.editorservices.EditorCodeFoldingFeature"));
        return featuresLibrary;
    }

    public void dispose() {
        if (this.PEER_MODEL_MANAGER.hasRoot()) {
            this.PEER_MODEL_MANAGER.getRoot().destroy();
        }
        this.PEER_MODEL_MANAGER.removeEventListener("rootSet", this.fRootSetObserver);
    }
}

