/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.decorator;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class Base64Decorator
extends FileServiceAbstractDecorator {
    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        block4: {
            String fileType;
            String string = fileType = fileInfo.getType() == null ? "" : fileInfo.getType();
            if (!fileType.startsWith("base64")) break block4;
            InputStream fileContents = null;
            byte[] bytes = null;
            try {
                fileContents = super.readContent(userToken, fileInfo);
                fileInfo.setDirectory(super.readInfo(userToken, fileInfo).isDirectory());
                bytes = IOUtils.toByteArray(fileContents);
            }
            catch (IOException e2) {
                try {
                    throw new MLSException("FileService.IOError", "Unable to read the contents of a file.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileContents);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fileContents);
            return this.encode(fileInfo, bytes);
        }
        return super.read(userToken, fileInfo);
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileType;
        String string = fileType = file.getFileInfo().getType() == null ? "" : file.getFileInfo().getType();
        if (fileType.startsWith("base64")) {
            byte[] bytes = this.decode(file);
            return super.updateContent(userToken, file.getFileInfo(), new ByteArrayInputStream(bytes));
        }
        return super.update(userToken, file);
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileType;
        String string = fileType = file.getFileInfo().getType() == null ? "" : file.getFileInfo().getType();
        if (fileType.startsWith("base64")) {
            byte[] bytes = this.decode(file);
            file.setContent("");
            super.create(userToken, file);
            return super.updateContent(userToken, file.getFileInfo(), new ByteArrayInputStream(bytes));
        }
        return super.create(userToken, file);
    }

    public FileDO encode(FileInfoDO fileInfo, byte[] contents) {
        String fileType;
        FileDO file = new FileDO(fileInfo);
        String string = fileType = fileInfo.getType() == null ? "" : fileInfo.getType();
        if (fileType.contains("base64win") && FileUtils.isTextFile(fileInfo)) {
            contents = this.convertLineEndingsToWindows(contents);
        }
        Base64 base64codec = new Base64();
        String buffer = new String(base64codec.encode(contents));
        file.setContent(buffer);
        return file;
    }

    public byte[] decode(FileDO file) {
        FileInfoDO fileInfo = file.getFileInfo();
        Base64 base64codec = new Base64();
        byte[] bytes = base64codec.decode(file.getContent().getBytes());
        if (FileUtils.isTextFile(fileInfo)) {
            bytes = this.convertLineEndingsToUnix(bytes);
        }
        return bytes;
    }

    private byte[] convertLineEndingsToWindows(byte[] contents) {
        String buffer = new String(contents);
        buffer = buffer.replaceAll("(\\r\\n|\\n\\r|\\n|\\r)", "\r\n");
        return buffer.getBytes();
    }

    private byte[] convertLineEndingsToUnix(byte[] bytes) {
        String buffer = new String(bytes);
        buffer = buffer.replaceAll("(\\r\\n|\\n\\r|\\n|\\r)", "\n");
        return buffer.getBytes();
    }
}

