/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.decorator;

import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileLockDO;
import com.mathworks.matlabserver.internalservices.file.FileLockService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import java.util.logging.Logger;

public class FileServiceLockDecorator
extends FileServiceAbstractDecorator {
    private static final Logger logger = Logger.getLogger(FileServiceLockDecorator.class.getName());

    private FileLockService getFileLockService() {
        RegistryService serviceRegistry = ServiceRegistryFactory.getServiceRegistry();
        return (FileLockService)serviceRegistry.getService(FileLockService.class);
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileLockDO fileLock = this.getFileLockService().lockFile(fileInfo, userToken);
        fileInfo.setFileLock(fileLock);
        return this.decoratedFileService.open(userToken, fileInfo);
    }

    @Override
    public FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileLockDO fileLock = this.getFileLockService().getFileLock(fileInfo, userToken);
        if (fileLock == null) {
            logger.severe("Closing a file but no lock existed: " + fileInfo);
        }
        if (fileLock == null || fileLock.isEditable()) {
            fileInfo = this.decoratedFileService.close(userToken, fileInfo);
        } else {
            logger.warning("Not letting any other services try to close the file. Not owned by the user: lock=" + fileLock + ", user=" + userToken);
        }
        this.getFileLockService().unlockFile(fileInfo, userToken);
        return fileInfo;
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        FileLockDO fileLock = this.getFileLockService().lockFile(file.getFileInfo(), userToken);
        FileInfoDO fileInfo = null;
        if (fileLock == null || fileLock.isEditable()) {
            fileInfo = this.decoratedFileService.create(userToken, file);
        } else {
            logger.warning("Not creating the file. Lock exists and is not owned by the user: lock=" + fileLock + ", user=" + userToken);
        }
        return fileInfo;
    }

    @Override
    public FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        return super.delete(userToken, fileInfo);
    }

    @Override
    public FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        return super.delete(userToken, fileInfoArray);
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        return super.move(userToken, sourceFileInfoArray, destinationFileInfo);
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        FileLockDO fileLock = this.getFileLockService().getFileLock(file.getFileInfo(), userToken);
        if (fileLock == null) {
            logger.severe("Updating a file but no lock existed: " + file.getFileInfo());
        }
        FileInfoDO fileInfo = file.getFileInfo();
        if (fileLock == null || fileLock.isEditable()) {
            fileInfo = this.decoratedFileService.update(userToken, file);
        } else {
            logger.warning("Not updating the file. Not owned by the user: lock=" + fileLock + ", user=" + userToken);
        }
        return fileInfo;
    }
}

