/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalconnector.worker;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.matlabserver.internalservices.eval.EvalRequestMessageDO;
import com.mathworks.matlabserver.internalservices.eval.EvalResponseMessageDO;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.workercommon.desktopservices.eval.AbstractEval;
import com.mathworks.matlabserver.workercommon.desktopservices.eval.SimpleEvalCompletionObserver;
import com.mathworks.matlabserver.workercommon.util.ConcurrencyCheck;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

public final class EvalConnectorImpl
extends AbstractEval {
    private static final Logger logger = Logger.getLogger(EvalConnectorImpl.class.getName());
    private static final int ONE_PERMIT = 1;
    private final MatlabMCR matlab = MatlabMCRFactory.getForCurrentMCR();
    private static final int MAXIMUM_NUMBER_OF_LINES = 550;

    @Override
    public EvalResponseMessageDO authoringEval(EvalRequestMessageDO evalRequest) {
        return this.executionEval(evalRequest);
    }

    @Override
    public EvalResponseMessageDO executionEval(EvalRequestMessageDO evalRequest) {
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        String mcommand = evalRequest.getMcode();
        logger.finer("doSynchronousEval: " + mcommand);
        EvalResponseMessageDO evalMessage = null;
        final Semaphore firstPassSemaphore = new Semaphore(1);
        SimpleEvalCompletionObserver evalObserver = new SimpleEvalCompletionObserver();
        evalObserver.setFirstMutex(firstPassSemaphore);
        try {
            firstPassSemaphore.acquire();
            final Object[] originalWindowSize = new Object[1];
            this.matlab.whenMatlabIdle(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        originalWindowSize[0] = MatlabMCR.mtGet((double)0.0, (String)"CommandWindowSize");
                    }
                    catch (Exception e2) {
                        originalWindowSize[0] = null;
                    }
                    finally {
                        firstPassSemaphore.release();
                    }
                }
            });
            firstPassSemaphore.acquire();
            this.matlab.setWindowSize(evalRequest.getHeight(), evalRequest.getWidth());
            this.matlab.eval(mcommand, (CompletionObserver)evalObserver);
            firstPassSemaphore.acquire();
            this.matlab.setWindowSize((int)((double[])originalWindowSize[0])[1], (int)((double[])originalWindowSize[0])[0]);
            evalMessage = new EvalResponseMessageDO();
            evalMessage.setError(evalObserver.isError());
            evalMessage.setUpdate(true);
            evalMessage.setUuid(evalRequest.getUuid());
            evalMessage.setPromptType(0);
            String result = this.truncateResult(evalMessage, evalObserver.getResult(), 550, evalRequest.getWidth());
            evalMessage.setResponseStr(result);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
        finally {
            firstPassSemaphore.release();
        }
        return evalMessage;
    }

    public String truncateResult(EvalResponseMessageDO evalMessage, String result, int maxLines, int lineWidth) {
        int index;
        block2: {
            int maxCharacters;
            String CHARACTER_TO_BE_SEARCHED = "\n";
            int CHARACTER_NOT_FOUND = -1;
            int n2 = maxCharacters = lineWidth > 0 ? Math.abs(maxLines * lineWidth) : 44000;
            if (result.length() > maxCharacters) {
                result = result.substring(result.length() - maxCharacters);
                evalMessage.setFault(new MessageFaultDO("ComputeService.EvalTruncateResultWarning", "The output has been truncated."));
            }
            int count = 0;
            index = result.length();
            do {
                --index;
                if ((index = result.lastIndexOf("\n", index)) == -1) break block2;
            } while (++count <= maxLines);
            evalMessage.setFault(new MessageFaultDO("ComputeService.EvalTruncateResultWarning", "The output has been truncated."));
        }
        result = result.substring(++index);
        return result;
    }
}

