/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.faults;

import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class FaultUtils {
    private static Logger logger = Logger.getLogger(FaultUtils.class.getName());

    public static MessageFaultDO create(Exception e2) {
        MessageFaultDO messageFault = null;
        if (e2 != null) {
            if (e2 instanceof MLSException) {
                messageFault = FaultUtils.convert((MLSException)e2);
            }
            if (messageFault == null && !FaultUtils.isTimeoutException(e2)) {
                messageFault = new MessageFaultDO();
                messageFault.setFaultCode("GeneralServerFault");
                if (e2.getCause() != null) {
                    messageFault.setMessage(e2.getCause().getMessage());
                } else {
                    messageFault.setMessage(e2.getMessage());
                }
            }
        }
        return messageFault;
    }

    public static MessageFaultDO create(String message) {
        MessageFaultDO messageFault = new MessageFaultDO();
        messageFault.setFaultCode("GeneralServerFault");
        messageFault.setMessage(message);
        return messageFault;
    }

    public static MessageFaultDO convert(MLSException exception) {
        return exception.getMessageFault();
    }

    public static String createResponse(Exception ex) {
        String result = "";
        if (FaultUtils.isTimeoutException(ex)) {
            logger.info("Creating response for TimeoutException with message " + ex.getMessage());
            result = ex.getMessage();
        }
        return result;
    }

    public static boolean isTimeoutException(Exception ex) {
        return ex instanceof TimeoutException || ex.getCause() instanceof TimeoutException;
    }
}

