/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.mathworks.matlabserver.connectorcommon.embeddedwebserver.WebServerConfig;
import com.mathworks.matlabserver.connectorcommon.util.ConnectorEncoder;
import com.mathworks.matlabserver.internalservices.client.ClientTypeRequestMessageDO;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import com.mathworks.matlabserver.jsonconverter.JsonRequestPayload;
import com.mathworks.matlabserver.jsonconverter.JsonResponsePayload;
import com.mathworks.matlabserver.jsonconverter.impl.JsonConverterServiceImpl;

public class PairingKeyJsonConverterServiceImpl
extends JsonConverterServiceImpl {
    private static final String INCORRECT_PAIRING_KEY = "ComputeService.IncorrectPairingKey";
    private static final String PAIRING_KEY_LENGTH_KEY = "pklen";
    private final PairingKeyHelper helper;
    private final ConnectorEncoder encoder = new ConnectorEncoder();

    public PairingKeyJsonConverterServiceImpl(ClassLookupService classLookupService) {
        super(classLookupService);
        this.helper = new PairingKeyHelper();
    }

    @Override
    public JsonRequestPayload convertJsonRequestToPayload(String json) {
        try {
            json = this.encoder.decodeEval(this.helper.getPairingKey(), json);
        }
        catch (Exception e2) {
            throw new MLSException(INCORRECT_PAIRING_KEY, "Incorrect password.");
        }
        JsonRequestPayload payload = super.convertJsonRequestToPayload(json);
        if (!this.isValidPairingKeyLength(payload)) {
            throw new MLSException(INCORRECT_PAIRING_KEY, "Incorrect password.");
        }
        return payload;
    }

    private boolean isValidPairingKeyLength(JsonRequestPayload payload) {
        if (payload != null) {
            MessageContainerDO messages = payload.getMessages();
            for (ClientTypeRequestMessageDO message : messages.getMessages(ClientTypeRequestMessageDO.class)) {
                String strPkLen = message.get(PAIRING_KEY_LENGTH_KEY);
                if (strPkLen == null || strPkLen.length() <= 0) continue;
                return this.helper.getPairingKey().length() == Integer.parseInt(strPkLen);
            }
        }
        return true;
    }

    @Override
    public String convertResponsePayloadToJson(JsonResponsePayload payload) {
        String json = super.convertResponsePayloadToJson(payload);
        try {
            return this.encoder.encodeEval(this.helper.getPairingKey(), json);
        }
        catch (Exception e2) {
            throw new MLSException(INCORRECT_PAIRING_KEY, "Incorrect password.");
        }
    }

    private class PairingKeyHelper {
        private String encodedPairingKey = null;
        private String pairingKey = null;

        private PairingKeyHelper() {
        }

        public String getPairingKey() {
            try {
                if (this.pairingKey == null || !WebServerConfig.getEncodedPairingKey().equals(this.encodedPairingKey)) {
                    this.encodedPairingKey = WebServerConfig.getEncodedPairingKey();
                    this.pairingKey = PairingKeyJsonConverterServiceImpl.this.encoder.decodePairingKey(this.encodedPairingKey);
                }
            }
            catch (Exception e2) {
                throw new MLSException(PairingKeyJsonConverterServiceImpl.INCORRECT_PAIRING_KEY, "Incorrect password.");
            }
            return this.pairingKey;
        }
    }
}

