/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesRequestMessageDO;
import java.lang.reflect.Type;
import java.util.logging.Logger;

public class MoveMultipleFilesRequestConverter
implements JsonDeserializer<MoveMultipleFilesRequestMessageDO>,
JsonSerializer<MoveMultipleFilesRequestMessageDO> {
    private static final Logger logger = Logger.getLogger(MoveMultipleFilesRequestConverter.class.getName());

    @Override
    public JsonElement serialize(MoveMultipleFilesRequestMessageDO o2, Type type, JsonSerializationContext jsonSerializationContext) {
        FileInfoDO destDir;
        JsonElement element;
        JsonObject jsonObject = new JsonObject();
        MoveMultipleFilesRequestMessageDO request = o2;
        FileInfoDO[] fileInfoArray = request.getFileInfoArray();
        if (fileInfoArray != null && fileInfoArray.length > 0) {
            FileInfoDO srcFileInfo = fileInfoArray[0];
            String srcPath = srcFileInfo.getLocation() + (srcFileInfo.getLocation().endsWith("/") ? "" : "/") + srcFileInfo.getName();
            element = jsonSerializationContext.serialize(srcPath, (Type)((Object)String.class));
            jsonObject.add("srcPath", element);
        }
        if ((destDir = request.getDestDir()) != null) {
            String destPath = destDir.getLocation() + (destDir.getLocation().endsWith("/") ? "" : "/") + destDir.getName();
            element = jsonSerializationContext.serialize(destPath, (Type)((Object)String.class));
            jsonObject.add("destPath", element);
        }
        if (request.getUuid() != null) {
            jsonObject.add("uuid", jsonSerializationContext.serialize(request.getUuid()));
        }
        return jsonObject;
    }

    @Override
    public MoveMultipleFilesRequestMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        MoveMultipleFilesRequestMessageDO retval = new MoveMultipleFilesRequestMessageDO();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == MoveMultipleFilesRequestMessageDO.class) {
            JsonElement srcElement;
            MoveMultipleFilesRequestMessageDO request = new MoveMultipleFilesRequestMessageDO();
            JsonElement destElement = jsonObject.get("destPath");
            if (destElement != null) {
                String destination = (String)jsonDeserializationContext.deserialize(destElement, (Type)((Object)String.class));
                FileInfoDO destinationFile = new FileInfoDO(destination);
                this.splitNameFromPath(destinationFile);
                request.setDestDir(destinationFile);
            }
            if ((srcElement = jsonObject.get("srcPath")) != null) {
                FileInfoDO[] srcFileArr = new FileInfoDO[1];
                String sourcePath = (String)jsonDeserializationContext.deserialize(srcElement, (Type)((Object)String.class));
                FileInfoDO sourceFile = new FileInfoDO(sourcePath);
                this.splitNameFromPath(sourceFile);
                srcFileArr[0] = sourceFile;
                request.setFileInfoArray(srcFileArr);
            }
            request.setUuid(this.getUuid(jsonObject));
            retval = request;
        }
        return retval;
    }

    private String getUuid(JsonObject jsonObject) {
        String retval = null;
        JsonPrimitive element = jsonObject.getAsJsonPrimitive("uuid");
        if (element != null) {
            retval = ((JsonElement)element).getAsString();
        }
        return retval;
    }

    private void splitNameFromPath(FileInfoDO fileInfo) {
        if (fileInfo.getName() == null || fileInfo.getName().isEmpty()) {
            FileInfoDO standardFileInfo = new FileInfoDO(fileInfo.getLocation());
            fileInfo.setName(standardFileInfo.getName());
            fileInfo.setLocation(standardFileInfo.getLocation());
        }
    }
}

