/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.breakpoint.impl13b.executionarrow;

import com.mathworks.matlab.api.debug.ExecutionDisplayAdapter;
import com.mathworks.matlab.api.debug.LineDebugState;
import com.mathworks.matlabserver.editordataservice.Document;
import com.mathworks.matlabserver.editordataservice.EditorFeature;
import com.mathworks.matlabserver.editordataservice.EditorNode;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.worker.desktopservices.UserManager;
import com.mathworks.matlabserver.worker.service.breakpoint.impl13b.executionarrow.MatlabExecutionDisplayAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ExecutionArrowFeature
extends EditorFeature {
    private String fFileName = "";
    private int fCurrentNumberOfLines = 0;
    private ExecutionDisplayAdapter.RepaintListener fRepaintListener;
    private MatlabExecutionDisplayAdapter fDisplayAdaptor;

    public ExecutionArrowFeature(EditorNode node) {
        super(node);
    }

    void updateExecutionArrowData(MatlabExecutionDisplayAdapter displayAdapter) {
        Map<String, Object> executionStackData = ExecutionArrowFeature.getExecutionArrowData(displayAdapter, this.fCurrentNumberOfLines);
        this.updateFeatureData(executionStackData);
    }

    public static Map<String, Object> getExecutionArrowData(MatlabExecutionDisplayAdapter displayAdapter, int numberOfLines) {
        ArrayList<Integer> topOfStack = new ArrayList<Integer>();
        ArrayList<Integer> onStack = new ArrayList<Integer>();
        ArrayList<Integer> endOfStack = new ArrayList<Integer>();
        for (int oneBasedLineNumber = 1; oneBasedLineNumber <= numberOfLines; ++oneBasedLineNumber) {
            EnumSet arrowSet = displayAdapter.getLineDebugState(oneBasedLineNumber);
            int zeroBasedLineNumber = oneBasedLineNumber - 1;
            if (arrowSet.contains(LineDebugState.TOP_OF_STACK)) {
                topOfStack.add(zeroBasedLineNumber);
            }
            if (arrowSet.contains(LineDebugState.IN_STACK)) {
                onStack.add(zeroBasedLineNumber);
            }
            if (!arrowSet.contains(LineDebugState.EXITING_STACK)) continue;
            endOfStack.add(zeroBasedLineNumber);
        }
        HashMap<String, Object> executionStackData = new HashMap<String, Object>();
        executionStackData.put(LineDebugState.TOP_OF_STACK.toString(), topOfStack);
        executionStackData.put(LineDebugState.IN_STACK.toString(), onStack);
        executionStackData.put(LineDebugState.EXITING_STACK.toString(), endOfStack);
        return executionStackData;
    }

    @Override
    public void documentChanged(Document document) {
        this.fCurrentNumberOfLines = document.getNumberOfLines();
        if (this.fFileName.isEmpty() && !document.getText().isEmpty()) {
            RegistryService registry = ServiceRegistryFactory.getServiceRegistry();
            FilenameConverter fFilenameConverter = (FilenameConverter)registry.getService(FilenameConverter.class);
            this.fFileName = fFilenameConverter.convertFilenameFromWorkerToServer(this.getUserManager().getUserToken(), document.getUniqueId());
            this.initializeExecutionAdaptor();
        }
    }

    private void initializeExecutionAdaptor() {
        this.fDisplayAdaptor = new MatlabExecutionDisplayAdapter(new File(this.fFileName));
        this.fRepaintListener = this.createRepaintListener(this.fDisplayAdaptor);
        this.fDisplayAdaptor.addListener(this.fRepaintListener);
        this.updateExecutionArrowData(this.fDisplayAdaptor);
    }

    private ExecutionDisplayAdapter.RepaintListener createRepaintListener(final MatlabExecutionDisplayAdapter displayAdapter) {
        return new ExecutionDisplayAdapter.RepaintListener(){

            public void repaintNeeded() {
                ExecutionArrowFeature.this.updateExecutionArrowData(displayAdapter);
            }
        };
    }

    @Override
    public String getFeatureId() {
        return "matlab.debug.executionarrow";
    }

    public UserManager getUserManager() {
        RegistryService registry = ServiceRegistryFactory.getServiceRegistry();
        return (UserManager)registry.getService(UserManager.class);
    }

    @Override
    public void dispose() {
        if (this.fDisplayAdaptor != null) {
            this.fDisplayAdaptor.removeListener(this.fRepaintListener);
            this.fDisplayAdaptor.dispose();
        }
    }
}

