/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.services.syntaxhighlighting.impl11b;

import com.mathworks.matlabserver.internalservices.syntaxhighlighting.SyntaxHighlightingRequestMessageDO;
import com.mathworks.matlabserver.internalservices.syntaxhighlighting.SyntaxHighlightingResponseMessageDO;
import com.mathworks.matlabserver.worker.desktopservices.SyntaxHighlighting;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MLexer;
import com.mathworks.widgets.text.mcode.MTokenContext;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.cell.Cell;
import com.mathworks.widgets.text.mcode.cell.CellUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.TokenCategory;

public class SyntaxHighlightingImpl
implements SyntaxHighlighting {
    @Override
    public SyntaxHighlightingResponseMessageDO getSyntaxHighlighting(SyntaxHighlightingRequestMessageDO request) {
        SyntaxHighlightingResponseMessageDO response = new SyntaxHighlightingResponseMessageDO();
        SyntaxHighlightingImpl.addSyntaxHighlighting(request, response);
        SyntaxHighlightingImpl.addCells(request, response);
        try {
            SyntaxHighlightingImpl.publishFunctionsList(request);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return response;
    }

    private static void publishFunctionsList(SyntaxHighlightingRequestMessageDO request) throws BadLocationException, InvocationTargetException, InterruptedException {
        final String matlabCode = request.getMatlabCode();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map finalFunctionsMap = null;
                try {
                    finalFunctionsMap = SyntaxHighlightingImpl.buildFunctionsMap(matlabCode);
                }
                catch (Exception e2) {
                    System.out.println(e2);
                }
                MessageService messageService = MessageServiceFactory.getMessageService();
                messageService.publish("/matlabfunctions", finalFunctionsMap);
            }
        });
    }

    public static Map buildFunctionsMap(String matlabCode) throws BadLocationException {
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        finalMap.put("matlabCode", matlabCode);
        ArrayList popupActions = new ArrayList();
        BaseDocument document = new BaseDocument(new MLanguage().createDefaultKit().getClass(), false);
        document.insertString(0, matlabCode, null);
        int[] functionLineNumbers = MDocumentUtils.getZeroBasedLineNumbersOfFunctions((BaseDocument)document);
        for (int i2 = 0; i2 < functionLineNumbers.length; ++i2) {
            int functionLineNumber = functionLineNumbers[i2];
            String functionName = MDocumentUtils.getFunctionName((BaseDocument)document, (int)functionLineNumber);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("functionName", functionName);
            map.put("lineNumber", functionLineNumber);
            popupActions.add(map);
            Collections.sort(popupActions, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> mapOne, Map<String, String> mapTwo) {
                    String functionNameOne = mapOne.get("functionName");
                    String functionNameTwo = mapTwo.get("functionName");
                    if (functionNameOne == null || functionNameTwo == null) {
                        return 0;
                    }
                    return functionNameOne.compareTo(functionNameTwo);
                }
            });
        }
        finalMap.put("functions", popupActions);
        return finalMap;
    }

    private static void addSyntaxHighlighting(SyntaxHighlightingRequestMessageDO request, SyntaxHighlightingResponseMessageDO response) {
        char[] matlabCode = request.getMatlabCode().toCharArray();
        MatlabTokenInfo tokenInfo = MLexer.getInstance().tokenizeLines(MLexer.getInstance().getInitialTokenizerState(), matlabCode, 0, matlabCode.length);
        int[] offsets = new int[tokenInfo.getNumTokens()];
        response.setOffsets(offsets);
        int[] tokenCategories = new int[tokenInfo.getNumTokens()];
        response.setTokens(tokenCategories);
        for (int i2 = 0; i2 < tokenInfo.getNumTokens(); ++i2) {
            BaseTokenID tokenId = (BaseTokenID)MTokenContext.getTokenID((int)tokenInfo.getToken(i2));
            TokenCategory category = tokenId.getCategory();
            tokenCategories[i2] = category == null ? tokenId.getNumericID() : category.getNumericID();
            offsets[i2] = tokenInfo.getOffset(i2);
        }
    }

    private static void addCells(SyntaxHighlightingRequestMessageDO request, SyntaxHighlightingResponseMessageDO response) {
        MTree tree = MTree.parse((String)request.getMatlabCode());
        response.setValidTree(tree.isValid());
        if (tree.isValid()) {
            List cells = CellUtils.getCellLocationsAsList((List)tree.findAsList(new MTree.NodeType[]{MTree.NodeType.CELL_TITLE}), (String)request.getMatlabCode());
            int[] locations = new int[cells.size() * 2];
            int counter = 0;
            for (Cell c2 : cells) {
                locations[counter++] = c2.getStartLine() - 1;
                locations[counter++] = c2.getEndLine() - 1;
            }
            response.setCellLocations(locations);
        } else {
            response.setCellLocations(new int[0]);
        }
    }
}

