/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.Namespaces;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Quota;
import javax.mail.QuotaAwareStore;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class IMAPStore
extends Store
implements QuotaAwareStore,
ResponseHandler {
    private String name = "imap";
    private int defaultPort = 143;
    private boolean isSSL = false;
    private int port = -1;
    private int blksize = 16384;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private String host;
    private String user;
    private String password;
    private String proxyAuthUser;
    private String authorizationID;
    private String saslRealm;
    private Namespaces namespaces;
    private boolean disableAuthLogin = false;
    private boolean disableAuthPlain = false;
    private boolean enableStartTLS = false;
    private boolean enableSASL = false;
    private String[] saslMechanisms;
    private boolean forcePasswordRefresh = false;
    private boolean debug;
    private PrintStream out;
    private ConnectionPool pool = new ConnectionPool();

    public IMAPStore(Session session, URLName url) {
        this(session, url, "imap", 143, false);
    }

    protected IMAPStore(Session session, URLName url, String name, int defaultPort, boolean isSSL) {
        super(session, url);
        String s;
        if (url != null) {
            name = url.getProtocol();
        }
        this.name = name;
        this.defaultPort = defaultPort;
        this.isSSL = isSSL;
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        this.out = session.getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
        if ((s = session.getProperty("mail." + name + ".connectionpool.debug")) != null && s.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if ((s = session.getProperty("mail." + name + ".partialfetch")) != null && s.equalsIgnoreCase("false")) {
            this.blksize = -1;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.partialfetch: false");
            }
        } else {
            s = session.getProperty("mail." + name + ".fetchsize");
            if (s != null) {
                this.blksize = Integer.parseInt(s);
            }
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.fetchsize: " + this.blksize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".statuscachetimeout")) != null) {
            this.statusCacheTimeout = Integer.parseInt(s);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.statuscachetimeout: " + this.statusCacheTimeout);
            }
        }
        if ((s = session.getProperty("mail." + name + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(s);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.appendbuffersize: " + this.appendBufferSize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".connectionpoolsize")) != null) {
            try {
                int size = Integer.parseInt(s);
                if (size > 0) {
                    this.pool.poolSize = size;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpoolsize: " + this.pool.poolSize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".connectionpooltimeout")) != null) {
            try {
                int connectionPoolTimeout = Integer.parseInt(s);
                if (connectionPoolTimeout > 0) {
                    this.pool.clientTimeoutInterval = connectionPoolTimeout;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpooltimeout: " + this.pool.clientTimeoutInterval);
            }
        }
        if ((s = session.getProperty("mail." + name + ".servertimeout")) != null) {
            try {
                int serverTimeout = Integer.parseInt(s);
                if (serverTimeout > 0) {
                    this.pool.serverTimeoutInterval = serverTimeout;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.servertimeout: " + this.pool.serverTimeoutInterval);
            }
        }
        if ((s = session.getProperty("mail." + name + ".separatestoreconnection")) != null && s.equalsIgnoreCase("true")) {
            if (this.pool.debug) {
                this.out.println("DEBUG: dedicate a store connection");
            }
            this.pool.separateStoreConnection = true;
        }
        if ((s = session.getProperty("mail." + name + ".proxyauth.user")) != null) {
            this.proxyAuthUser = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.proxyauth.user: " + this.proxyAuthUser);
            }
        }
        if ((s = session.getProperty("mail." + name + ".auth.login.disable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=LOGIN");
            }
            this.disableAuthLogin = true;
        }
        if ((s = session.getProperty("mail." + name + ".auth.plain.disable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=PLAIN");
            }
            this.disableAuthPlain = true;
        }
        if ((s = session.getProperty("mail." + name + ".starttls.enable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable STARTTLS");
            }
            this.enableStartTLS = true;
        }
        if ((s = session.getProperty("mail." + name + ".sasl.enable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable SASL");
            }
            this.enableSASL = true;
        }
        if (this.enableSASL && (s = session.getProperty("mail." + name + ".sasl.mechanisms")) != null && s.length() > 0) {
            if (this.debug) {
                this.out.println("DEBUG: SASL mechanisms allowed: " + s);
            }
            Vector<String> v = new Vector<String>(5);
            StringTokenizer st = new StringTokenizer(s, " ,");
            while (st.hasMoreTokens()) {
                String m2 = st.nextToken();
                if (m2.length() <= 0) continue;
                v.addElement(m2);
            }
            this.saslMechanisms = new String[v.size()];
            v.copyInto(this.saslMechanisms);
        }
        if ((s = session.getProperty("mail." + name + ".sasl.authorizationid")) != null) {
            this.authorizationID = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.authorizationid: " + this.authorizationID);
            }
        }
        if ((s = session.getProperty("mail." + name + ".sasl.realm")) != null) {
            this.saslRealm = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.realm: " + this.saslRealm);
            }
        }
        if ((s = session.getProperty("mail." + name + ".forcepasswordrefresh")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable forcePasswordRefresh");
            }
            this.forcePasswordRefresh = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean protocolConnect(String host, int pport, String user, String password) throws MessagingException {
        block17: {
            IMAPProtocol protocol = null;
            if (host == null || password == null || user == null) {
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect returning false, host=" + host + ", user=" + user + ", password=" + (password != null ? "<non-null>" : "<null>"));
                }
                return false;
            }
            if (pport != -1) {
                this.port = pport;
            } else {
                String portstring = this.session.getProperty("mail." + this.name + ".port");
                if (portstring != null) {
                    this.port = Integer.parseInt(portstring);
                }
            }
            if (this.port == -1) {
                this.port = this.defaultPort;
            }
            try {
                boolean poolEmpty;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    poolEmpty = this.pool.authenticatedConnections.isEmpty();
                }
                if (!poolEmpty) break block17;
                protocol = new IMAPProtocol(this.name, host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect login, host=" + host + ", user=" + user + ", password=" + (password != null ? "<non-null>" : "<null>"));
                }
                this.login(protocol, user, password);
                protocol.addResponseHandler(this);
                this.host = host;
                this.user = user;
                this.password = password;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(protocol);
                }
            }
            catch (CommandFailedException cex) {
                protocol.disconnect();
                protocol = null;
                throw new AuthenticationFailedException(cex.getResponse().getRest());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            catch (IOException ioex) {
                throw new MessagingException(ioex.getMessage(), ioex);
            }
        }
        return true;
    }

    private void login(IMAPProtocol p2, String u, String pw) throws ProtocolException {
        if (this.enableStartTLS && p2.hasCapability("STARTTLS")) {
            p2.startTLS();
            p2.capability();
        }
        if (p2.isAuthenticated()) {
            return;
        }
        String authzid = this.authorizationID != null ? this.authorizationID : (this.proxyAuthUser != null ? this.proxyAuthUser : u);
        if (this.enableSASL) {
            p2.sasllogin(this.saslMechanisms, this.saslRealm, authzid, u, pw);
            if (p2.isAuthenticated()) {
                if (this.proxyAuthUser != null) {
                    p2.proxyauth(this.proxyAuthUser);
                }
                return;
            }
        }
        if (p2.hasCapability("AUTH=PLAIN") && !this.disableAuthPlain) {
            p2.authplain(authzid, u, pw);
        } else if ((p2.hasCapability("AUTH-LOGIN") || p2.hasCapability("AUTH=LOGIN")) && !this.disableAuthLogin) {
            p2.authlogin(u, pw);
        } else if (!p2.hasCapability("LOGINDISABLED")) {
            p2.login(u, pw);
        } else {
            throw new ProtocolException("No login methods supported!");
        }
        if (this.proxyAuthUser != null) {
            p2.proxyauth(this.proxyAuthUser);
        }
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getProtocol(IMAPFolder folder) throws MessagingException {
        IMAPProtocol p2 = null;
        while (p2 == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.authenticatedConnections.isEmpty() || this.pool.separateStoreConnection && this.pool.authenticatedConnections.size() == 1 || this.pool.borrowedStoreConnections > 0L && this.pool.authenticatedConnections.size() == 1) {
                    if (this.debug) {
                        this.out.println("DEBUG: no connections in the pool, creating a new one");
                    }
                    try {
                        if (this.forcePasswordRefresh) {
                            InetAddress addr;
                            try {
                                addr = InetAddress.getByName(this.host);
                            }
                            catch (UnknownHostException e2) {
                                addr = null;
                            }
                            PasswordAuthentication pa = this.session.requestPasswordAuthentication(addr, this.port, this.name, null, this.user);
                            if (pa != null) {
                                this.user = pa.getUserName();
                                this.password = pa.getPassword();
                            }
                        }
                        p2 = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                        this.login(p2, this.user, this.password);
                    }
                    catch (Exception ex1) {
                        if (p2 != null) {
                            try {
                                p2.disconnect();
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                        }
                        p2 = null;
                    }
                    if (p2 == null) {
                        throw new MessagingException("connection failure");
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    p2 = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                    this.pool.authenticatedConnections.removeElement(p2);
                    long lastUsed = System.currentTimeMillis() - p2.getTimestamp();
                    if (lastUsed > this.pool.serverTimeoutInterval) {
                        try {
                            p2.noop();
                        }
                        catch (ProtocolException pex) {
                            try {
                                p2.removeResponseHandler(this);
                                p2.disconnect();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            p2 = null;
                            continue;
                        }
                    }
                    p2.removeResponseHandler(this);
                }
                this.timeoutConnections();
                if (folder != null) {
                    if (this.pool.folders == null) {
                        this.pool.folders = new Vector();
                    }
                    this.pool.folders.addElement(folder);
                }
            }
        }
        return p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol p2 = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty()) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                }
                try {
                    p2 = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                    this.login(p2, this.user, this.password);
                }
                catch (Exception ex1) {
                    if (p2 != null) {
                        try {
                            p2.logout();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    p2 = null;
                }
                if (p2 == null) {
                    throw new ConnectionException("failed to create new store connection");
                }
                p2.addResponseHandler(this);
                this.pool.authenticatedConnections.addElement(p2);
            } else {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                p2 = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
            }
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections++;
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            return p2;
        }
    }

    boolean allowReadOnlySelect() {
        String s = this.session.getProperty("mail." + this.name + ".allowreadonlyselect");
        return s != null && s.equalsIgnoreCase("true");
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                this.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            return this.pool.authenticatedConnections.size() >= this.pool.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProtocol(IMAPFolder folder, IMAPProtocol protocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (protocol != null) {
                if (!this.isConnectionPoolFull()) {
                    protocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(protocol);
                    if (this.debug) {
                        this.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        protocol.logout();
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(folder);
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseStoreProtocol(IMAPProtocol protocol) {
        if (protocol == null) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections--;
                if (this.pool.debug) {
                    this.out.println("DEBUG: releaseStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyConnectionPool(boolean force) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            for (int index = this.pool.authenticatedConnections.size() - 1; index >= 0; --index) {
                try {
                    IMAPProtocol p2 = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    p2.removeResponseHandler(this);
                    if (force) {
                        p2.disconnect();
                        continue;
                    }
                    p2.logout();
                    continue;
                }
                catch (ProtocolException pex) {
                    // empty catch block
                }
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            this.out.println("DEBUG: removed all authenticated connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    this.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                for (int index = this.pool.authenticatedConnections.size() - 1; index > 0; --index) {
                    IMAPProtocol p2 = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    if (this.pool.debug) {
                        this.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - p2.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - p2.getTimestamp() <= this.pool.clientTimeoutInterval) continue;
                    if (this.pool.debug) {
                        this.out.println("DEBUG: authenticated connection timed out");
                        this.out.println("DEBUG: logging out the connection");
                    }
                    p2.removeResponseHandler(this);
                    this.pool.authenticatedConnections.removeElementAt(index);
                    try {
                        p2.logout();
                        continue;
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return this.session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    public boolean hasCapability(String capability) throws MessagingException {
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            boolean bl = p2.hasCapability(capability);
            return bl;
        }
        catch (ProtocolException pex) {
            if (p2 == null) {
                this.cleanup();
            }
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            p2.noop();
        }
        catch (ProtocolException pex) {
            if (p2 == null) {
                this.cleanup();
            }
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
        return super.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        ConnectionPool connectionPool;
        IMAPProtocol protocol;
        block13: {
            boolean isEmpty;
            if (!super.isConnected()) {
                return;
            }
            protocol = null;
            connectionPool = this.pool;
            synchronized (connectionPool) {
                isEmpty = this.pool.authenticatedConnections.isEmpty();
            }
            if (!isEmpty) break block13;
            if (this.pool.debug) {
                this.out.println("DEBUG: close() - no connections ");
            }
            this.cleanup();
            this.releaseStoreProtocol(protocol);
            return;
        }
        try {
            protocol = this.getStoreProtocol();
            connectionPool = this.pool;
            synchronized (connectionPool) {
                this.pool.authenticatedConnections.removeElement(protocol);
            }
            protocol.logout();
            this.releaseStoreProtocol(protocol);
        }
        catch (ProtocolException pex) {
            try {
                this.cleanup();
                throw new MessagingException(pex.getMessage(), pex);
            }
            catch (Throwable throwable) {
                this.releaseStoreProtocol(protocol);
                throw throwable;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private synchronized void cleanup() {
        this.cleanup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup(boolean force) {
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup, force " + force);
        }
        Vector foldersCopy = null;
        boolean done = true;
        block11: while (true) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    done = false;
                    foldersCopy = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    done = true;
                }
            }
            if (done) break;
            int i2 = 0;
            int fsize = foldersCopy.size();
            while (true) {
                if (i2 >= fsize) continue block11;
                IMAPFolder f2 = (IMAPFolder)foldersCopy.elementAt(i2);
                try {
                    if (force) {
                        if (this.debug) {
                            this.out.println("DEBUG: force folder to close");
                        }
                        f2.forceClose();
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG: close folder");
                        }
                        f2.close(false);
                    }
                }
                catch (MessagingException mex) {
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                ++i2;
            }
            break;
        }
        ConnectionPool i2 = this.pool;
        synchronized (i2) {
            this.emptyConnectionPool(force);
        }
        try {
            super.close();
        }
        catch (MessagingException mex) {
            // empty catch block
        }
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup done");
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(name, '\uffff', this);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(url.getFile(), '\uffff', this);
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(ns.personal, null);
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.otherUsers == null) {
            return super.getUserNamespaces(user);
        }
        return this.namespaceToFolders(ns.otherUsers, user);
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(ns.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        this.checkConnected();
        IMAPProtocol p2 = null;
        if (this.namespaces == null) {
            try {
                p2 = this.getStoreProtocol();
                this.namespaces = p2.namespace();
            }
            catch (BadCommandException bex) {
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            finally {
                this.releaseStoreProtocol(p2);
                if (p2 == null) {
                    this.cleanup();
                }
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] ns, String user) {
        Folder[] fa = new Folder[ns.length];
        for (int i2 = 0; i2 < fa.length; ++i2) {
            String name = ns[i2].prefix;
            if (user == null) {
                int len = name.length();
                if (len > 0 && name.charAt(len - 1) == ns[i2].delimiter) {
                    name = name.substring(0, len - 1);
                }
            } else {
                name = name + user;
            }
            fa[i2] = new IMAPFolder(name, ns[i2].delimiter, this, user == null);
        }
        return fa;
    }

    public Quota[] getQuota(String root) throws MessagingException {
        Quota[] qa = null;
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            qa = p2.getQuotaRoot(root);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", bex);
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p2);
            if (p2 == null) {
                this.cleanup();
            }
        }
        return qa;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            p2.setQuota(quota);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", bex);
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p2);
            if (p2 == null) {
                this.cleanup();
            }
        }
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            this.handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.debug) {
                this.out.println("DEBUG: IMAPStore connection dead");
            }
            if (super.isConnected()) {
                this.cleanup(r.isSynthetic());
            }
            return;
        }
    }

    void handleResponseCode(Response r) {
        String s = r.getRest();
        boolean isAlert = false;
        if (s.startsWith("[")) {
            int i2 = s.indexOf(93);
            if (i2 > 0 && s.substring(0, i2 + 1).equalsIgnoreCase("[ALERT]")) {
                isAlert = true;
            }
            s = s.substring(i2 + 1).trim();
        }
        if (isAlert) {
            this.notifyStoreListeners(1, s);
        } else if (r.isUnTagged() && s.length() > 0) {
            this.notifyStoreListeners(2, s);
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private long borrowedStoreConnections = 0L;
        private long clientTimeoutInterval = 45000L;
        private long serverTimeoutInterval = 1800000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;

        ConnectionPool() {
        }
    }
}

