/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class BodyTerm
extends StringTerm {
    private static final long serialVersionUID = -4888862527916911385L;

    public BodyTerm(String pattern) {
        super(pattern);
    }

    public boolean match(Message msg) {
        return this.matchPart(msg);
    }

    private boolean matchPart(Part p2) {
        try {
            if (p2.isMimeType("text/*")) {
                String s = (String)p2.getContent();
                if (s == null) {
                    return false;
                }
                return super.match(s);
            }
            if (p2.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)p2.getContent();
                int count = mp.getCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!this.matchPart(mp.getBodyPart(i2))) continue;
                    return true;
                }
            } else if (p2.isMimeType("message/rfc822")) {
                return this.matchPart((Part)p2.getContent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BodyTerm)) {
            return false;
        }
        return super.equals(obj);
    }
}

